// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


#if !defined(HK_PLATFORM_SPU)
inline hkpConvexShape::hkpConvexShape(ShapeType type, hkReal radius) : hkpSphereRepShape( type )
{
    HK_ASSERT(0x20b67de1, radius >= 0, "hkpConvexShape should not have a negative radius");
    m_radius = radius;
}
#endif

inline const hkReal& hkpConvexShape::getRadius() const
{
    return m_radius;
}

inline void hkpConvexShape::setRadiusUnchecked(hkReal radius)
{
    HK_ASSERT(0x20b67de1, radius >= 0, "hkpConvexShape should not have a negative radius");
    m_radius = radius;
}

inline void hkpConvexShape::setRadius(hkReal radius)
{
    HK_WARN_ON_DEBUG_IF(getType()==hkcdShapeType::CONVEX_VERTICES,0xCF7E3E10,"Changing convex radius of that shape after creation can generate inconsistent collisions");
    setRadiusUnchecked(radius);
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
