// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Types/Geometry/Sphere/hkSphere.h>

HK_INLINE void hkpSphereShape::getSupportingVertex(hkVector4Parameter direction, hkcdVertex& supportingVertexOut) const
{
    supportingVertexOut.setZero();
}

HK_INLINE void hkpSphereShape::convertVertexIdsToVertices(const hkpVertexId* ids, int numIds, hkcdVertex* verticesOut) const
{
    for (int i = numIds - 1; i >= 0; i--)
    {
        verticesOut[i].setZero();
    }
}

HK_INLINE void hkpSphereShape::getCentre(hkVector4& centreOut) const
{
    centreOut.setZero();
}

HK_INLINE int hkpSphereShape::getNumCollisionSpheres() const
{
    return 1;
}

HK_INLINE void hkpSphereShape::getAabb(const hkTransform& localToWorld, hkReal tolerance, hkAabb& out) const
{
    hkSimdReal tol4; tol4.setFromFloat( tolerance + m_radius );

    out.m_min.setSub( localToWorld.getTranslation(), tol4 );
    out.m_max.setAdd( localToWorld.getTranslation(), tol4 );
}

HK_INLINE const hkSphere* hkpSphereShape::getCollisionSpheres(hkSphere* sphereBuffer) const
{
#if !defined(HK_PLATFORM_SPU)
    sphereBuffer->setPositionAndRadius(hkVector4::getZero(), hkSimdReal::fromFloat(m_radius));
#else
    hkVector4 v;
    v.setZero();
    v(3) = m_radius;
    sphereBuffer->setPositionAndRadius(v);
#endif
    return sphereBuffer;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
