// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/Shape/Convex/ConvexTransform/hkpConvexTransformShape.h>

//
//  Allocates a new convex vertices shape at the given memory location

inline hkpConvexVerticesShape* HK_CALL hkpConvexVerticesShape::createInPlace(hkUint8*& memPtr, hkReal convexRadius)
{
    hkpConvexVerticesShape* cvShape;

#ifndef HK_PLATFORM_SPU

    HK_CHECK_ALIGN_REAL(memPtr);
    cvShape = new(memPtr) hkpConvexVerticesShape(convexRadius);

#else

    cvShape = (hkpConvexVerticesShape*)memPtr;
    cvShape->setType(HKCD_SHAPE_TYPE_FROM_CLASS(hkpConvexVerticesShape));
    cvShape->setRadiusUnchecked(convexRadius);
    cvShape->m_useSpuBuffer = true;

#endif

    HKCD_PATCH_SHAPE_VTABLE( cvShape );

    // Increment memory location
    const int memSize = HK_NEXT_MULTIPLE_OF(HK_REAL_ALIGNMENT, sizeof(hkpConvexVerticesShape));
    memPtr = hkAddByteOffset<hkUint8>(memPtr, memSize);

    // Return the shape
    return cvShape;
}

HK_INLINE int hkpConvexVerticesShape::getNumCollisionSpheres() const
{
    return m_numVertices;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
