// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


/// Hold connectivity information for a hkpConvexVerticesShape.
/// This information is optional for the hkpConvexVerticesShape - but having it set can speed up some algorithms,
/// and other algorithms actually require the information (for example the convex hull cutting functionality).
///
/// Connectivity information must be closed.
/// The vertex index order is expected to define the way the face is facing.
class HK_EXPORT_PHYSICS_2012 hkpConvexVerticesConnectivity : public hkReferencedObject
{
    public:
        HK_DECLARE_REFLECTION();
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_CDINFO);

        hkpConvexVerticesConnectivity() {}

            /// Returns true if the connectivity is 'closed'. It is a requirement of all valid connectivity
            /// that it is closed. Loosely being closed means that any surface has no 'holes'. Algorithmically
            /// if every edge exists once - in a forward direction and a backwards direction then the surface
            /// is closed.
            /// Note this definition allows multiple closed surfaces, or vertices which are not indexed.
        hkBool isClosed() const;

            /// Remove all of the connectivity information
        virtual void clear();

            /// Add a face
        void addFace(int* indices,int numIndices);
            /// Returns the total amount of faces
        HK_INLINE int getNumFaces() const { return m_numVerticesPerFace.getSize(); }

        // An array holding the vertex indices for all the the faces
        // Each faces indices is stored in a clockwise is outwards order
        // Faces indices are stored one after another - in the order of the faces inside
        // of the hkpConvexVerticesShape
        hkArray<hkUint16> m_vertexIndices;

        // The number of indices used by each face. Maximum number of indices (and therefore edges) per
        // face is 256.
        hkArray<hkUint8> m_numVerticesPerFace;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
