// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


#pragma once


#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/hkpMoppCompilerInput.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>


class hkpShapeContainer;
class hkpMoppMediator;


/// This class provides useful functionality for managing, maintaining, and creating MOPPs.
class HK_EXPORT_PHYSICS_2012 hkpMoppUtility
{
    public:
            /// Builds the MOPP for a given set of shapes with the specified fit tolerance requirements.
            /// The returned hkpMoppCode is a referenced object, so you just need to call removeReference() when you're finished with it -
            /// the system will look after deleting the object.
            /// Note: This method can take significant time to complete. MOPP code is a platform independent byte code and should
            /// be precomputed offline and loaded at runtime.
            /// If chunk building is used for SPUs then an array can be passed to collect the re-indexing information.
        static hkpMoppCode* HK_CALL buildCode(const hkpShapeContainer* shapeContainer, const hkpMoppCompilerInput& req, hkArray<hkpMoppCodeReindexedTerminal>* reindexInfoOut = HK_NULL);


    protected:

            // called by buildCode()
        static hkpMoppCode* HK_CALL buildCodeInternal(hkpMoppMediator& mediator, const hkpShapeContainer* shapeContainer, const hkpMoppCompilerInput& moppInput, hkArray<hkpMoppCodeReindexedTerminal>* reindexInfo);
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
