// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if !defined(HK_PLATFORM_SPU)

inline const hkpShapeCollection* hkpMoppBvTreeShape::getShapeCollection() const
{
    return static_cast<const hkpShapeCollection*>(m_child.getChild());
}

inline const hkpShapeContainer* hkpMoppBvTreeShape::getContainer() const
{
    return getShapeCollection()->getContainer();
}

#else

inline const hkpShapeCollection* hkpMoppBvTreeShape::getShapeCollectionFromPpu(hkpShapeBuffer& buffer) const
{
    getChildShapeFromPpu(buffer);
    return (hkpShapeCollection*)(buffer);
}

#endif

/// Get the internal data used by the MOPP algorithms
inline const hkpMoppCode*  hkpMoppBvTreeShape::getMoppCode() const
{
    return m_code;
}

inline void  hkpMoppBvTreeShape::setMoppCode(const hkpMoppCode* code)
{
    HK_ASSERT(0xcf45fedc, code, "You can not supply a null MoppCode. Was the MOPP setup correctly?.");
    code->addReference();
    m_code->removeReference();
    m_code = code;
    m_codeInfoCopy = code->m_info.m_offset;
    m_moppData = code->m_data.begin();
    m_moppDataSize = code->getCodeSize();
}


const hkpShape* hkpMoppBvTreeShape::getChild() const
{
    return m_child.getChild();
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
