// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Compound/Tree/hkpBvTreeShape.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>

class hkpMoppCode;

class HK_EXPORT_PHYSICS_2012 hkMoppBvTreeShapeBase : public hkpBvTreeShape
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SHAPE);
        HK_DECLARE_REFLECTION();
        HK_RECORD_ATTR(hk::IncludeInMgd(false));

        /// Empty constructor, to be called by the shape vtable util on SPU
        HK_INLINE hkMoppBvTreeShapeBase()
        {}

            /// Constructs a new hkpMoppBvTreeShape. You can use the <hkpMoppUtility.h> to build a MOPP code.
        hkMoppBvTreeShapeBase( ShapeType type, const hkpMoppCode* code);

#ifndef HK_PLATFORM_SPU

        void afterReflectNew()
        {
            m_bvTreeType = BVTREE_MOPP;
        }

#endif

        inline ~hkMoppBvTreeShapeBase()
        {
            if(m_code) m_code->removeReference();
        }

            // hkpBvTreeShape interface implementation.
        virtual void queryObb( const hkTransform& obbToMopp, const hkVector4& extent, hkReal tolerance, hkArray<hkpShapeKey>& hits ) const;

            // hkpBvTreeShape interface implementation.
        virtual void queryAabb( const hkAabb& aabb, hkArray<hkpShapeKey>& hits ) const;

            // hkpBvTreeShape interface implementation.
        HKP_SHAPE_VIRTUAL hkUint32 queryAabbImpl(HKP_SHAPE_VIRTUAL_THIS const hkAabb& aabb, hkpShapeKey* hits, int maxNumKeys ) HKP_SHAPE_VIRTUAL_CONST;

    public:

        const class hkpMoppCode*        m_code;
        const  hkUint8*             m_moppData;     //+nosave
        hkUint32                    m_moppDataSize; //+nosave
        hkVector4                   m_codeInfoCopy; //+nosave
};


    /// This class implements a hkpBvTreeShape using MOPP technology.
class HK_EXPORT_PHYSICS_2012 hkpMoppBvTreeShape : public hkMoppBvTreeShapeBase
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();
        HK_RECORD_ATTR(hk::IncludeInMgd(false));
        HKCD_DECLARE_SHAPE_TYPE(hkcdShapeType::MOPP);

        /// Empty constructor, to be called by the shape vtable util on SPU
        HK_INLINE hkpMoppBvTreeShape()
        {}

            /// Constructs a new hkpMoppBvTreeShape. You can use the <hkpMoppUtility.h> to build a MOPP code.
        hkpMoppBvTreeShape( const hkpShapeCollection* collection, const hkpMoppCode* code);

#ifndef HK_PLATFORM_SPU

        void afterReflectNew();

            // destructor
        virtual ~hkpMoppBvTreeShape() {}

#endif

        //
        // hkpShape implementation
        //
            // hkpShape interface implementation.
        virtual void getAabb(const hkTransform& localToWorld, hkReal tolerance, hkAabb& out) const;

            //  hkpShape interface implementation.
        virtual hkBool castRay(const hkpShapeRayCastInput& input, hkpShapeRayCastOutput& results) const;

            // hkpShape Interface implementation
        virtual void castRayWithCollector(const hkpShapeRayCastInput& input, const hkpCdBody& cdBody, hkpRayHitCollector& collector) const;

        //  hkpShape interface implementation.
        virtual hkVector4Comparison castRayBundle(const hkpShapeRayBundleCastInput& input, hkpShapeRayBundleCastOutput& results, hkVector4ComparisonParameter mask) const;

            /// Get the internal data used by the MOPP algorithms
        inline const hkpMoppCode* getMoppCode() const;

        inline void setMoppCode(const hkpMoppCode* code);

#if ! defined (HK_PLATFORM_SPU)

            /// Gets the hkpShapeCollection.
        inline const hkpShapeCollection* getShapeCollection() const;

        inline virtual const hkpShapeContainer* getContainer() const;

        virtual int calcSizeForSpu(const CalcSizeForSpuInput& input, int spuBufferSizeLeft) const;

#else
            /// Gets the hkpShapeCollection into the buffer.
        inline const hkpShapeCollection* getShapeCollectionFromPpu(hkpShapeBuffer& buffer) const;

        void getChildShapeFromPpu(hkpShapeBuffer& buffer) const;
#endif

        HK_INLINE const hkpShape* getChild() const;

    protected:

        class hkpSingleShapeContainer m_child;

    public:
        mutable int                 m_childSize;    //+nosave


};

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/hkpMoppBvTreeShape.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
