// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
//
// Havok Memory Optimised Partial Polytope Debugger
// This class helps debugging the MOPP assembler and virtual machine
//



// the idea of the debugger is that we are searching our triangle in the entire original tree and
// remembering all paths to this node.

// when it comes to the final virtual machine, we easily can check, which paths are not taken,
// and which extra paths are processed which shouldn't be processed

#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Splitter/hkpMoppSplitTypes.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Mediator/hkpMoppMediator.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Utility/hkpMoppDebugger.h>
#include <Common/Base/Object/hkSingleton.h>

#define DEBUG_LOG_IDENTIFIER "p12.collide.mopp.debugger"
#include <Common/Base/System/Log/hkLog.hxx>

HK_SINGLETON_IMPLEMENTATION(hkpMoppDebugger);

hkpMoppDebugger::hkpMoppDebugger()
{

}
/*
void hkpMoppDebugger::findNodeRecursive( class hkpMoppMediator *mediator, class hkpMoppTreeNode* node, int triIndex, int meshIndex, char* path, int depth )
{
    if ( node->m_isTerminal )
    {
        hkpMoppTreeTerminal* t = node->toTerminal();
        if ( t->m_primitive->m_primitiveID != static_cast<unsigned>(triIndex) )
        {
            return;
        }

        hkpPrimitiveProperty props[ hkpMoppCode::MAX_PRIMITIVE_PROPERTIES ];
        int numProps = mediator->getPrimitiveProperties( *t->m_primitive, props );
        if ( numProps  && props[0] != static_cast<unsigned>(meshIndex) )
        {
            return;
        }

        // now we found the node
        // append it to our path
        path[ depth ] = 0;
        hkpMoppPath p;
        for (int i=0; i < depth; i++)
        {
            p.m_path[i] = path[i];
        }
        p.m_path[ depth ] = 0;
        m_paths.pushBack(p);
    }
    else
    {
        hkpMoppTreeInternalNode* n = node->toNode();
        path[depth] = 'L';
        findNodeRecursive( mediator, n->m_leftBranch, triIndex, meshIndex, path, depth+1 );
        path[depth] = 'R';
        findNodeRecursive( mediator, n->m_rightBranch, triIndex, meshIndex, path, depth+1 );
    }
}
*/

void hkpMoppDebugger::addHit(unsigned int id, const unsigned int properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES], hkUlong chunkOffset)
{
    if ( id == static_cast<unsigned>(m_searchTriIndex) )
    {
        m_searchPath[ m_searchDepth ] = 0;
        hkpMoppPath p;
        for (int i=0; i < m_searchDepth; i++)
        {
            p.m_path[i] = m_searchPath[i];
        }
        p.m_path[ m_searchDepth ] = 0;
        m_paths.pushBack(p);
    }
}

void hkpMoppDebugger::queryTriOnTree( hkpDbgQuery *query, const unsigned char *PC, int triIndex, char* path, int depth, int chunkOffset)
{
    m_searchTriIndex = triIndex;
    m_searchDepth = depth;
    m_searchPath = path;
    hkpDbgQuery scaledQuery = *query;

    int offsetl;
    int offseth;

    while (1){
        HK_MOPP_LOAD_PC();

        switch (command) {
        case HK_MOPP_SPLIT_YZ:
        case HK_MOPP_SPLIT_YMZ:
        case HK_MOPP_SPLIT_XZ:
        case HK_MOPP_SPLIT_XMZ:
        case HK_MOPP_SPLIT_XY:
        case HK_MOPP_SPLIT_XMY:

        case HK_MOPP_SPLIT_XYZ:
        case HK_MOPP_SPLIT_XYMZ:
        case HK_MOPP_SPLIT_XMYZ:
        case HK_MOPP_SPLIT_XMYMZ:

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            {
                const unsigned int offsetRB = PC3;
                PC += 4;                        //move to the left branch
                path[depth] = 'L';
                queryTriOnTree( &scaledQuery, PC,            triIndex, path, depth+1, chunkOffset );    //move to the left branch
        path[depth] = 'R';
                queryTriOnTree( &scaledQuery, PC + offsetRB, triIndex, path, depth+1, chunkOffset );    //move to the left branch
                return;
            }

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            {
                const unsigned int offsetRB = PC2;
                PC += 3;                        //move to the left branch
                path[depth] = 'L';
                queryTriOnTree( &scaledQuery, PC,               triIndex, path, depth+1, chunkOffset ); //move to the left branch
                path[depth] = 'R';
                queryTriOnTree( &scaledQuery, PC + offsetRB,    triIndex, path, depth+1, chunkOffset ); //move to the left branch
                return;
            }

        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            {
                const unsigned int leftJump = (PC3 << 8) + (PC4);
                const unsigned int rightJump = (PC5 << 8) + (PC6);
                PC += 7;

                path[depth] = 'L';
                queryTriOnTree( &scaledQuery, PC + leftJump,  triIndex, path, depth+1, chunkOffset );   //move to the left branch
                path[depth] = 'R';
                queryTriOnTree( &scaledQuery, PC + rightJump, triIndex, path, depth+1, chunkOffset );   //move to the left branch
                return;
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            {
                PC += 3;
                continue;
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            {
                PC += 7;
                continue;
            }

        case HK_MOPP_JUMP_CHUNK:
            {
                const int chunkId = ( PC1 << 8 ) |  PC2;
                chunkOffset = chunkId * HK_MOPP_CHUNK_SIZE;
                const unsigned char* jumpAddress = m_moppCode->m_data.begin() + chunkOffset;
                PC = jumpAddress;
                continue;
            }

        case HK_MOPP_JUMP_CHUNK32:
            {
                chunkOffset = (PC1<<24) + (PC2<<16) + (PC3<<8) + PC4;
                const unsigned char* jumpAddress = m_moppCode->m_data.begin() + chunkOffset;
                PC = jumpAddress;
                continue;
            }

        case HK_MOPP_DATA_OFFSET:
            {
                // dataOffset = ( PC1 << 8 ) |  PC2;
                // numTerminals = ( PC3 << 8 ) |  PC4;
                // Skip over the command
                PC+=5;
                continue;
            }

        HK_MOPP_JUMP_MACRO




        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                PC += 4;
                continue;
            }

        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_CHUNK_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:

    return;
}

//  void initDebugger(hkpMoppMediator *med, hkpMoppTreeNode* node, int triIndex, int meshIndex );

/*
void hkpMoppDebugger::initUsingMoppTree(hkpMoppMediator *med, hkpMoppTreeNode* node, int triIndex, int meshIndex )
{
    m_currentDepth = 0;

    char buffer[ hkpMoppPath::HK_PATH_MAX_DEPTH ];
    findNodeRecursive( med, node, triIndex, meshIndex, buffer, 0 );
    if(0)   // print paths
    {
        for (int i=0; i < m_paths.getSize(); i++)
        {
            hkprintf("Path for tri %i mesh %i: %s\n", triIndex, meshIndex, m_paths[i].m_path);
        }
    }
}
*/

void hkpMoppDebugger::initUsingCodeAndTri( const hkpMoppCode* moppCode, const int tri)
{
    m_moppCode = moppCode;

    m_currentDepth = 0;

    // search a triangle to collide with
    m_paths.clear();

    // find the path to our triangle

    char buffer[ hkpMoppPath::HK_PATH_MAX_DEPTH ];
    const unsigned char *pc = &moppCode->m_data[0];

    // If the MOPP code contains terminal data then we need to reindex the terminals
    m_reindexingMask = (*pc == HK_MOPP_DATA_OFFSET) ? 0xffffffff : 0x00000000;

    hkpDbgQuery query;
    query.m_primitiveOffset = 0;
    queryTriOnTree( &query, pc, tri, buffer, 0, 0 );
    for (int i=0; i < m_paths.getSize(); i++)
    {
        Log_Info( "***********Start ***********\n\tCorrect Path is {}", m_paths[i].m_path  );
    }

}

hkBool hkpMoppDebugger::find()
{
    hkBool found = false;
    for (int i=0; i < m_paths.getSize(); i++)
    {
        if ( ! hkString::strNcmp( m_currentPath, m_paths[i].m_path, m_currentDepth))
        {
            found = true;
        }
    }
    return found;
}

void hkpMoppDebugger::initDisabled()
{
    m_paths.clear();
}

void hkpMoppDebugger::startRecurse()
{
    m_currentDepth = 0;
}

void hkpMoppDebugger::errorOccured()
{
//  int x = 5;
//  x = 6;
}
    // returns the current recursion depth
int hkpMoppDebugger::recurseLeft()
{

    if ( m_paths.getSize() == 0)
    {
        return m_currentDepth;
    }

    m_currentPath[ m_currentDepth++ ] = 'L';
    m_currentPath[ m_currentDepth ]  = 0;
    if (find())
    {
        Log_Info( "Traversing Correct Path {}", m_currentPath );
    }
    else
    {
        Log_Info( "Traversing Extra Path {}", m_currentPath );
    }
    return m_currentDepth-1;
}

    // returns the current recursion depth
int hkpMoppDebugger::recurseRight()
{

    if ( m_paths.getSize() == 0)
    {
        return m_currentDepth;
    }

    m_currentPath[ m_currentDepth++ ] = 'R';
    m_currentPath[ m_currentDepth ]  = 0;

    if (find())
    {
        Log_Info( "Traversing Correct Path {}", m_currentPath );
    }
    else
    {
        Log_Info( "Traversing Extra Path {}", m_currentPath );
    }
    return m_currentDepth-1;
}


void hkpMoppDebugger::pop(int recursionDepth)
{
    m_currentDepth = recursionDepth;
    m_currentPath[ m_currentDepth ]  = 0;
}

void hkpMoppDebugger::rejectLeft()
{

    if ( m_paths.getSize() == 0)
    {
        return;
    }
    m_currentPath[ m_currentDepth++ ] = 'L';
    m_currentPath[ m_currentDepth ]  = 0;
    if (find())
    {
        Log_Info( "Path wrongfully rejected {}", m_currentPath );
        errorOccured();
    }
    m_currentDepth--;
}

void hkpMoppDebugger::rejectRight()
{

    if ( m_paths.getSize() == 0)
    {
        return;
    }

    m_currentPath[ m_currentDepth++ ] = 'R';
    m_currentPath[ m_currentDepth ]  = 0;
    if (find())
    {
        Log_Info( "Path wrongfully rejected {}", m_currentPath );
        errorOccured();
    }
    m_currentDepth--;
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
