// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//
//

#pragma once

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppModifier.h>
#include <Common/Base/Container/BitField/hkBitField.h>

class hkpMoppCode;
class hkpShapeCollection;



/// This class allows you to efficiently remove terminals from a MOPP.
/// You can use many instances of this class so long as each instance removes different
/// terminals from the MOPP. This class queries the MOPP with the AABB of all terminals
/// being removed to speed up the building of the internal tables. To get good performance,
/// the triangles to remove should be all in the same area (so that the AABB is small).
/// The construction of a hkpRemoveTerminalsMoppModifier does the AABB query described
/// above, so is not as fast as the actual removal, or you can use a pre-calculated AABB.
/// Since applying a modifier (via the applyRemoveTerminals() method) modifies the MOPP
/// code in-place, to 'undo' a removal (for example on level restart/reload) you must use
/// the same modifier and call the undoRemoveTerminals() method.
/// N.B. Modifiers must be 'undone' in the *reverse order* to that in which they were applied.
class HK_EXPORT_PHYSICS_2012 hkpRemoveTerminalsMoppModifier: public hkReferencedObject, public hkpMoppModifier
{
    public:

        HK_DECLARE_CLASS(hkpRemoveTerminalsMoppModifier, New, Reflect, BypassCtor);

            /// Build this modifier (which does an AABB query on the MOPP) but does not
            /// alter the moppCode yet, so you can pre-construct this object.
            /// It calculates the query AABB based on the shapes in the shapesContainer using keysToRemove.
        hkpRemoveTerminalsMoppModifier( const hkpMoppCode* moppCode, const hkpShapeContainer* shapeContainer, const hkArray<hkpShapeKey>& keysToRemove );

        /// Build this modifier (which does an AABB query on the MOPP) but does not
        /// alter the moppCode yet, so you can pre-construct this object. This version
        /// uses a pre-calculated AABB and is roughly 2-10 times faster than the other constructor.
        hkpRemoveTerminalsMoppModifier( const hkpMoppCode* moppCode, const hkAabb& precalculatedAabb, const hkArray<hkpShapeKey>& keysToRemove );

        virtual ~hkpRemoveTerminalsMoppModifier() {}

            /// Actually remove the terminals from the moppCode. This function is very fast.
        void applyRemoveTerminals( hkpMoppCode* moppCode );

            /// Undo the removal of the terminals.
            /// N.B. Modifiers must be 'undone' in the reverse order to that in which they
            /// were 'applied'. This function is very fast.
        void undoRemoveTerminals( hkpMoppCode* moppCode );

    protected:
        hkpRemoveTerminalsMoppModifier(): m_tempShapesToRemove(HK_NULL) { }

            // hkpMoppModifier interface implementation
        virtual hkBool shouldTerminalBeRemoved( hkUint32 id, const hkUint32 *properties );

            // hkpMoppModifier interface implementation
        virtual void addTerminalRemoveInfo( hkInt32 relativeMoppAddress );

    protected:

            /// This member stores history of what has been removed from the MOPP code.
            ///     - Bits 0-7: The original MOPP code instruction.
            ///     - Bits 8-31: The offset in the MOPP where the instruction was located.
        hkArray<hkUint32> m_removeInfo;

            /// for construction only
        const hkArray<hkpShapeKey>* m_tempShapesToRemove; //+nosave
};

class HK_EXPORT_PHYSICS_2012 hkpRemoveTerminalsMoppModifier2: public hkpRemoveTerminalsMoppModifier
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            /// Scan the entire MOPP and remove everything which is not set in enabledKeys.
        hkpRemoveTerminalsMoppModifier2( const hkpMoppCode* moppCode, const hkBitField& enabledKeys );

    protected:
            // hkpMoppModifier interface implementation
        virtual hkBool shouldTerminalBeRemoved( hkUint32 id, const hkUint32 *properties );


    protected:
        const hkBitField* m_enabledKeys;

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
