// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// Virtual Machine command definitions

//#define HK_MOPP_DEBUGGER_ENABLED
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>

#ifdef HK_MOPP_DEBUGGER_ENABLED
#   include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/hkbuilder.h>
#   include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Utility/hkpMoppDebugger.h>
#   define HK_QVM_DBG(x) x
#   define HK_QVM_DBG2(var,x) int var = x
#else
#   define HK_QVM_DBG(x)
#   define HK_QVM_DBG2(var,x)
#endif


//this is the structure that all virtual machines will return on being queried
//it represents a primitive ID and an array of primitive properties
class hkpMoppPrimitiveInfo
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppPrimitiveInfo );

        hkUint32 ID;
        //unsigned int properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES];
};

//class HK_ALIGNED_VARIABLE(hkpMoppVirtualMachine,16)
class HK_EXPORT_PHYSICS_2012 hkpMoppVirtualMachine
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppVirtualMachine );

        typedef int hkpMoppFixedPoint;

    public:
        // standard constructor
        HK_INLINE hkpMoppVirtualMachine();
        // standard destructor
        HK_INLINE ~hkpMoppVirtualMachine();

        HK_INLINE int getNumHits() const ;

    protected:

        HK_INLINE void addHit(unsigned int id, const unsigned int properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES]);

#if !defined(HK_PLATFORM_SPU)

        HK_INLINE void initQuery( hkArray<hkpMoppPrimitiveInfo>* m_primitives_out );

#else

        inline void initQuery( hkpMoppPrimitiveInfo* m_primitives_out, int primitives_out_capacity );

#endif
            /// returns an integer which is smaller than x
        static HK_INLINE int HK_CALL toIntMin(hkReal x);

            /// returns an integer which is larger than x
        static HK_INLINE int HK_CALL toIntMax(hkReal x);

        static HK_INLINE int HK_CALL read24( const unsigned char* PC );


    public:

        hkArray<hkpMoppPrimitiveInfo>* m_primitives_out;
        int     padding[3];
};

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachine.inl>

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
