// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>

template<class QUERY, class QUERY_OBJECT>
hkpMoppUsingFloatAabbVirtualMachine<QUERY,QUERY_OBJECT>::hkpMoppUsingFloatAabbVirtualMachine()
{
}

template<class QUERY, class QUERY_OBJECT>
hkpMoppUsingFloatAabbVirtualMachine<QUERY,QUERY_OBJECT>::~hkpMoppUsingFloatAabbVirtualMachine()
{
    // nothing to do
}

template<class QUERY, class QUERY_OBJECT>
void hkpMoppUsingFloatAabbVirtualMachine<QUERY,QUERY_OBJECT>::queryMoppTree( const hkpMoppUsingFloatAabbVirtualMachineQueryInt* query, const unsigned char* PC, hkpMoppTempAabb& fQueryL)
{
    hkpMoppUsingFloatAabbVirtualMachineQueryInt scaledQuery; // for fast scale commands
    while (1)
    {
        HK_MOPP_LOAD_PC();

        hkpMoppTempAabb fQueryR;

        int offsetl;
        int offseth;


        switch (command)
        {

        case HK_MOPP_SPLIT_YZ:
        case HK_MOPP_SPLIT_YMZ:
        case HK_MOPP_SPLIT_XZ:
        case HK_MOPP_SPLIT_XMZ:
        case HK_MOPP_SPLIT_XY:
        case HK_MOPP_SPLIT_XMY:

        case HK_MOPP_SPLIT_XYZ:
        case HK_MOPP_SPLIT_XYMZ:
        case HK_MOPP_SPLIT_XMYZ:
        case HK_MOPP_SPLIT_XMYMZ:
            {
                offseth = PC3;
                PC += 4;

                fQueryR.m_aabb.m_min = fQueryL.m_aabb.m_min;
                fQueryR.m_aabb.m_max = fQueryL.m_aabb.m_max;

                HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                queryMoppTree( query, PC, fQueryR );
                HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                PC += offseth;
                continue;
            }

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            {
                int tdir = command - HK_MOPP_SPLIT_X;

                fQueryR.m_aabb.m_min = fQueryL.m_aabb.m_min;
                fQueryR.m_aabb.m_max = fQueryL.m_aabb.m_max;

                offseth = PC1;
                offsetl = PC2;
                fQueryL.m_aabb.m_max(tdir) = (float) ( (offseth << query->m_shift) + (&query->m_offset_x)[tdir]) * m_ItoFScale;
                fQueryR.m_aabb.m_min(tdir) = (float) ( (offsetl << query->m_shift) + (&query->m_offset_x)[tdir]) * m_ItoFScale;

                offsetl = 0;
                offseth = PC3;
                PC += 4;

                goto do_compare;
            }
        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:

            {
                int tdir = command - HK_MOPP_SINGLE_SPLIT_X;
                fQueryR.m_aabb.m_min = fQueryL.m_aabb.m_min;
                fQueryR.m_aabb.m_max = fQueryL.m_aabb.m_max;

                offsetl = PC1;
                offseth = offsetl + 1;
                offsetl <<= query->m_shift;
                offseth <<= query->m_shift;
                offsetl += (&query->m_offset_x)[tdir];
                offseth += (&query->m_offset_x)[tdir];

                fQueryR.m_aabb.m_min(tdir) = float( offsetl ) * m_ItoFScale;
                fQueryL.m_aabb.m_max(tdir) = float( offseth ) * m_ItoFScale;

                offsetl = 0;
                offseth = PC2;
                PC += 3;
            }
            goto do_compare;

        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:

            {
                int tdir = command - HK_MOPP_SPLIT_JUMP_X;

                fQueryR.m_aabb.m_min = fQueryL.m_aabb.m_min;
                fQueryR.m_aabb.m_max = fQueryL.m_aabb.m_max;

                offseth = PC1;
                offsetl = PC2;
                fQueryL.m_aabb.m_max(tdir) = (float) ( (offseth << query->m_shift) + (&query->m_offset_x)[tdir]) * m_ItoFScale;
                fQueryR.m_aabb.m_min(tdir) = (float) ( (offsetl << query->m_shift) + (&query->m_offset_x)[tdir]) * m_ItoFScale;

                offsetl = (PC3 << 8) + (PC4);
                offseth = (PC5 << 8) + (PC6);
                PC += 7;
            }

            //goto do_compare;
do_compare:
                // try to get cut commands up
            while(1)
            {
                const hkpMoppCommands c = hkpMoppCommands(PC[offsetl]);
                if ( c < HK_MOPP_DOUBLE_CUT_X || c > HK_MOPP_DOUBLE_CUT24_Z)
                {
                    break;
                }
                if ( c >= HK_MOPP_DOUBLE_CUT24_X)
                {
                    int tdir = c - HK_MOPP_DOUBLE_CUT24_X;
                    fQueryL.m_aabb.m_min(tdir) = float(read24(PC + offsetl + 1) ) * m_ItoFScale;
                    fQueryL.m_aabb.m_max(tdir) = float(read24(PC + offsetl + 4) ) * m_ItoFScale;
                    offsetl += 7;
                }
                else
                {
                    int tdir = c - HK_MOPP_DOUBLE_CUT_X;
                    fQueryL.m_aabb.m_min(tdir) = float(((PC[offsetl + 1] << query->m_shift) + (&query->m_offset_x)[tdir])) * m_ItoFScale;
                    fQueryL.m_aabb.m_max(tdir) = float(((PC[offsetl + 2] << query->m_shift) + (&query->m_offset_x)[tdir])) * m_ItoFScale;
                    offsetl += 3;
                }
            }

            while(1)
            {
                const hkpMoppCommands c = hkpMoppCommands(PC[offseth]);
                if ( c < HK_MOPP_DOUBLE_CUT_X || c > HK_MOPP_DOUBLE_CUT24_Z)
                {
                    break;
                }
                if ( c >= HK_MOPP_DOUBLE_CUT24_X)
                {
                    int tdir = c - HK_MOPP_DOUBLE_CUT24_X;
                    fQueryR.m_aabb.m_min(tdir) = float(read24(PC + offseth + 1) ) * m_ItoFScale;
                    fQueryR.m_aabb.m_max(tdir) = float(read24(PC + offseth + 4) ) * m_ItoFScale;
                    offseth += 7;
                }
                else
                {
                    int tdir = c - HK_MOPP_DOUBLE_CUT_X;
                    fQueryR.m_aabb.m_min(tdir) = float(((PC[offseth + 1] << query->m_shift) + (&query->m_offset_x)[tdir])) * m_ItoFScale;
                    fQueryR.m_aabb.m_max(tdir) = float(((PC[offseth + 2] << query->m_shift) + (&query->m_offset_x)[tdir])) * m_ItoFScale;
                    offseth += 3;
                }
            }

            {
                // not in right branch -> traverse left only
                hkpMoppQueryObject::hkpCheckCollisionResult checkRight = m_queryObject.checkCollision( fQueryR.m_aabb, query, PC+offseth );
                hkpMoppQueryObject::hkpCheckCollisionResult checkLeft = m_queryObject.checkCollision( fQueryL.m_aabb, query, PC+offsetl );
                if ( checkRight != hkpMoppQueryObject::HK_HIT )
                {
                    if ( checkLeft != hkpMoppQueryObject::HK_HIT)
                    {
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                        goto end_of_function;
                    }

                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    PC += offsetl;
                    continue;
                }


                // now we have to check for traversing the right
                if (checkLeft != hkpMoppQueryObject::HK_HIT )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    fQueryL.m_aabb.m_min = fQueryR.m_aabb.m_min;
                    fQueryL.m_aabb.m_max = fQueryR.m_aabb.m_max;
                    PC += offseth;
                    continue;
                }

                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseRight() );
                    //move to the left branch
                    queryMoppTree( query, PC + offseth, fQueryR );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    PC += offsetl;
                    continue;
                }
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            {
                int tdir = command - HK_MOPP_DOUBLE_CUT24_X;

                fQueryL.m_aabb.m_min(tdir) = (float) ((PC1<<16) + (PC2<<8) + PC3) * m_ItoFScale;
                fQueryL.m_aabb.m_max(tdir) = (float) ((PC4<<16) + (PC5<<8) + PC6) * m_ItoFScale;

                PC += 7;
                goto doCut;
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            {
                int tdir = command - HK_MOPP_DOUBLE_CUT_X;

                fQueryL.m_aabb.m_min(tdir) = float(((PC1 << query->m_shift) + (&query->m_offset_x)[tdir])) * m_ItoFScale;
                fQueryL.m_aabb.m_max(tdir) = float(((PC2 << query->m_shift) + (&query->m_offset_x)[tdir])) * m_ItoFScale;
                PC += 3;
            }
doCut:
            {
                // do early out if we find two cut commands following each other
                if ( (HK_MOPP_DOUBLE_CUT_X <= *PC) && (HK_MOPP_DOUBLE_CUT24_Z >= *PC ) )
                {
                    continue;
                }

                hkpMoppQueryObject::hkpCheckCollisionResult result = m_queryObject.checkCollision( fQueryL.m_aabb, query, PC );
                if ( result == hkpMoppQueryObject::HK_HIT )
                {
                    continue;
                }
                else
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }
            }


        HK_MOPP_JUMP_MACRO

        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                const unsigned int shift = command - HK_MOPP_SCALE0;

                //accumulate the offset in root node space
                scaledQuery.m_offset_x = (PC1 << query->m_shift) + query->m_offset_x;
                scaledQuery.m_offset_y = (PC2 << query->m_shift) + query->m_offset_y;
                scaledQuery.m_offset_z = (PC3 << query->m_shift) + query->m_offset_z;

                //the shift has been accumulating
                scaledQuery.m_shift = query->m_shift - shift;

                //no need to copy anything except for the primitive toffset and the properties
                for(int p = 0; p < 1;p++)
                {
                    scaledQuery.m_properties[p] = query->m_properties[p];
                }

                scaledQuery.m_primitiveOffset = query->m_primitiveOffset;
                //no need to copy anything except for the primitive toffset
                query = &scaledQuery;

                PC += 4;
                continue;
            }

        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:

    return;
}

template<class QUERY, class QUERY_OBJECT>
void hkpMoppUsingFloatAabbVirtualMachine<QUERY,QUERY_OBJECT>::queryMopp(const hkpMoppCode* code, const QUERY &queryInput, hkArray<hkpMoppPrimitiveInfo>* partialHitsOut, hkArray<hkpMoppPrimitiveInfo>* fullyIncludedHitsOut)
{
    const unsigned char* programCounter = &code->m_data[0];

    //the result list

    this->initQuery( partialHitsOut );

    HK_ALIGN16( hkpMoppTempAabb queryf );
    hkpMoppUsingFloatAabbVirtualMachineQueryInt   queryi;

    // Float query data:
    m_ItoFScale = 1.0f / float(code->m_info.getScale());

    // Integer query setup:
    queryi.m_offset_x = 0;
    queryi.m_offset_y = 0;
    queryi.m_offset_z = 0;
    queryi.m_shift = 16;
    queryi.m_primitiveOffset = 0;

    for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
    {
        queryi.m_properties[p] = 0;
    }


    queryf.m_aabb.m_min.setZero();
    queryf.m_aabb.m_max.setAll( m_ItoFScale * ( 1<<24)  );

    //
    //  Setup our query
    //

    {
        m_queryObject.initializeQueryObject(queryInput, code);
        m_queryObject.m_primitives_out = fullyIncludedHitsOut;
    }

    //call the query with the left-of-decimal place part
    queryMoppTree( &queryi, programCounter, queryf );
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
