// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0


//
//  Warning: this file uses templates and some functions are not declared inline.
//  This file is meant to be included only by hkMoppMachine.cpp
//


#pragma once

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppFindAllVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>


class hkpMoppQueryObject: public hkpMoppFindAllVirtualMachine
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppQueryObject );

        enum hkpCheckCollisionResult
        {
            HK_NO_HIT,
            HK_INCLUDED,
            HK_HIT
        };
};




template<class QUERY, class QUERY_OBJECT>
class hkpMoppUsingFloatAabbVirtualMachine : public hkpMoppVirtualMachine
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppUsingFloatAabbVirtualMachine );

    struct hkpMoppUsingFloatAabbVirtualMachineQueryInt: public hkpMoppFindAllVirtualMachine::hkpMoppFindAllVirtualMachineQuery
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppUsingFloatAabbVirtualMachineQueryInt );

        //the offset in B space of the all previous scales are accumulated here
        int m_offset_x;
        int m_offset_y;
        int m_offset_z;

        //the shifts from all previous scale commands are accumulated here
        int m_shift;
    };

    struct hkpMoppTempAabb
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppTempAabb );

        hkAabb      m_aabb;
    };

public:

    // standard constructor
    HK_INLINE hkpMoppUsingFloatAabbVirtualMachine();

    // standard destructor
    HK_INLINE ~hkpMoppUsingFloatAabbVirtualMachine();

    /// run a query, the results are added to the hitlist
    // returns the number of hits
    //void queryMopp(const hkpMoppCode* code, const hkSphere &sphere, hkArray<hkpMoppPrimitiveInfo>* partialHitsOut, hkArray<hkpMoppPrimitiveInfo>* fullyIncludedHitsOut);

    HK_INLINE void queryMopp(const hkpMoppCode* code, const QUERY &query, hkArray<hkpMoppPrimitiveInfo>* partialHitsOut, hkArray<hkpMoppPrimitiveInfo>* fullyIncludedHitsOut);

protected:

    // int to float conversion
    float m_ItoFScale;

    //hkMoppSphereQueryObject m_queryObject;
    QUERY_OBJECT m_queryObject;

    void queryMoppTree( const hkpMoppUsingFloatAabbVirtualMachineQueryInt* query, const unsigned char* commands, hkpMoppTempAabb& fQuery);
};

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppUsingFloatAabbVirtualMachine.inl>

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
