// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
//

#include <Physics2012/Collide/hkpCollide.h>
#include <Common/Base/System/Io/OStream/hkOStream.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Splitter/hkpMoppSplitTypes.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Mediator/hkpMoppMediator.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppStatisticsVirtualMachine.h>

int hkpMoppStatisticsVirtualMachine::queryOnTree( const hkpMoppStatisticsVirtualMachineQuery* query, int deep, const unsigned char *PC )
{
    hkpMoppStatisticsVirtualMachineQuery scaledQuery; // for fast scale commands

    int offsetl;
    int offseth;

    while (1){
        HK_MOPP_LOAD_PC();

        switch (command) {
        case HK_MOPP_SPLIT_YZ:
        case HK_MOPP_SPLIT_YMZ:
        case HK_MOPP_SPLIT_XZ:
        case HK_MOPP_SPLIT_XMZ:
        case HK_MOPP_SPLIT_XY:
        case HK_MOPP_SPLIT_XMY:

        case HK_MOPP_SPLIT_XYZ:
        case HK_MOPP_SPLIT_XYMZ:
        case HK_MOPP_SPLIT_XMYZ:
        case HK_MOPP_SPLIT_XMYMZ:
            {
                m_topDown[deep].m_numSplitDiag++;
                const unsigned int offsetRB = PC3;
                PC += 4;
                int m = 1 + hkMath::max2( queryOnTree( query, deep+1, PC ), queryOnTree( query, deep+1, PC + offsetRB ) );
                m_bottomUp[m].m_numSplitDiag++;
                return m;
            }


        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            {
                m_topDown[deep].m_numSplitA++;
                const unsigned int offsetRB = PC3;
                PC += 4;
                int m = 1 + hkMath::max2( queryOnTree( query, deep+1, PC ), queryOnTree( query, deep+1, PC + offsetRB ) );
                m_bottomUp[deep].m_numSplitA++;
                return m;
            }

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            {
                m_topDown[deep].m_numSingleSplit++;
                const unsigned int offsetRB = PC2;
                PC += 3;                        //move to the left branch
                int m = 1 + hkMath::max2( queryOnTree( query, deep+1, PC ), queryOnTree( query, deep+1, PC + offsetRB ) );
                m_bottomUp[m].m_numSingleSplit++;
                return m;
            }

        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            {
                m_topDown[deep].m_numSingleSplitJump++;
                const unsigned int leftJump = (PC3 << 8) + (PC4);
                const unsigned int rightJump = (PC5 << 8) + (PC6);
                PC += 7;
                int m = 1 + hkMath::max2( queryOnTree( query, deep+1, PC + leftJump ), queryOnTree( query, deep+1, PC + rightJump ) );
                m_bottomUp[m].m_numSingleSplitJump++;
                return m;
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            {
                m_topDown[deep].m_numDoubleCut++;
                int m = queryOnTree( query, deep, PC + 3);
                m_bottomUp[m].m_numDoubleCut++;
                return m;
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            {
                m_topDown[deep].m_numDoubleCut24++;
                int m = queryOnTree( query, deep, PC + 7);
                m_bottomUp[m].m_numDoubleCut24++;
                return m;
            }

        case HK_MOPP_JUMP8:
            {
                offsetl = PC1;
                PC += 2;
                PC += offsetl;

                m_topDown[deep].m_numJump8++;
                int m = queryOnTree( query, deep, PC);
                m_bottomUp[m].m_numJump8++;
                return m;
            }
        case HK_MOPP_JUMP16:
            {
                offseth = PC1;
                offsetl = PC2;
                PC += 3;
                PC += (offseth << 8) + offsetl;
                m_topDown[deep].m_numJump16++;
                int m = queryOnTree( query, deep, PC);
                m_bottomUp[m].m_numJump16++;
                return m;
            }
        case HK_MOPP_JUMP24:
            {
                offseth = PC1;
                const unsigned int offsetm = PC2;
                offsetl = PC3;
                PC += 4;
                PC += (offseth << 16) + (offsetm << 8) + offsetl;
                m_topDown[deep].m_numJump24++;
                int m = queryOnTree( query, deep, PC);
                m_bottomUp[m].m_numJump24++;
                return m;
            }


        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                m_topDown[deep].m_numScale++;
                int m = queryOnTree( query, deep, PC+4);
                m_bottomUp[m].m_numScale++;
                return m;
            }

        case HK_MOPP_TERM_REOFFSET8:
            {
                m_topDown[deep].m_numReoffset8++;
                int m = queryOnTree( query, deep, PC+2);
                m_bottomUp[m].m_numReoffset8++;
                return m;
            }
        case HK_MOPP_TERM_REOFFSET16:
            {
                m_topDown[deep].m_numReoffset16++;
                int m = queryOnTree( query, deep, PC+3);
                m_bottomUp[m].m_numReoffset16++;
                return m;
            }
        case HK_MOPP_TERM_REOFFSET32:
            {
                m_topDown[deep].m_numReoffset32++;
                int m = queryOnTree( query, deep, PC+5);
                m_bottomUp[m].m_numReoffset32++;
                return m;
            }


        case HK_MOPP_RETURN:            return 0;
        case HK_MOPP_TERM8:
            {
                m_topDown[deep].m_numTerm8++;
                m_bottomUp[0].m_numTerm8++;
                return 0;
            }
        case HK_MOPP_TERM16:
            {
                m_topDown[deep].m_numTerm16++;
                m_bottomUp[0].m_numTerm16++;
                return 0;
            }
        case HK_MOPP_TERM24:
            {
                m_topDown[deep].m_numTerm24++;
                m_bottomUp[0].m_numTerm24++;
                return 0;
            }
        case HK_MOPP_TERM32:
            {
                m_topDown[deep].m_numTerm32++;
                m_bottomUp[0].m_numTerm32++;
                return 0;
            }
        case HK_MOPP_TERM4_0:
        case HK_MOPP_TERM4_1:
        case HK_MOPP_TERM4_2:
        case HK_MOPP_TERM4_3:
        case HK_MOPP_TERM4_4:
        case HK_MOPP_TERM4_5:
        case HK_MOPP_TERM4_6:
        case HK_MOPP_TERM4_7:
        case HK_MOPP_TERM4_8:
        case HK_MOPP_TERM4_9:
        case HK_MOPP_TERM4_A:
        case HK_MOPP_TERM4_B:
        case HK_MOPP_TERM4_C:
        case HK_MOPP_TERM4_D:
        case HK_MOPP_TERM4_E:
        case HK_MOPP_TERM4_F:
        case HK_MOPP_TERM4_10:
        case HK_MOPP_TERM4_11:
        case HK_MOPP_TERM4_12:
        case HK_MOPP_TERM4_13:
        case HK_MOPP_TERM4_14:
        case HK_MOPP_TERM4_15:
        case HK_MOPP_TERM4_16:
        case HK_MOPP_TERM4_17:
        case HK_MOPP_TERM4_18:
        case HK_MOPP_TERM4_19:
        case HK_MOPP_TERM4_1A:
        case HK_MOPP_TERM4_1B:
        case HK_MOPP_TERM4_1C:
        case HK_MOPP_TERM4_1D:
        case HK_MOPP_TERM4_1E:
        case HK_MOPP_TERM4_1F:
            offsetl = command - HK_MOPP_TERM4_0;
            {
                m_topDown[deep].m_numTerm4++;
                m_bottomUp[0].m_numTerm4++;
                return 0;
            }

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

// not referenced: end_of_function:

    return 0;
}

static void printEntry(const hkpMoppStatisticsVirtualMachine::Entry& entry, hkOstream& ostream)
{
        ostream.printf("\tnumSplitA/Diag      %i:%i\n",entry.m_numSplitA,entry.m_numSplitDiag);
        ostream.printf("\tnumSingleSplit      %i\n",entry.m_numSingleSplit);
        ostream.printf("\tnumSingleSplitJump  %i\n",entry.m_numSingleSplitJump);
        ostream.printf("\tnumDoubleCut8,24    %i:%i\n",entry.m_numDoubleCut,entry.m_numDoubleCut24);
        ostream.printf("\tnumJump8,16,24      %i:%i:%i\n",entry.m_numJump8,entry.m_numJump16, entry.m_numJump24);
        ostream.printf("\tnumScale            %i\n",entry.m_numScale);
        ostream.printf("\tnumReoffset8,16,32  %i:%i:%i\n",entry.m_numReoffset8,entry.m_numReoffset16,entry.m_numReoffset32);

        ostream.printf("\tnumTerm4,8,>8       %i:%i:%i\n",entry.m_numTerm4,entry.m_numTerm8, entry.m_numTerm16 + entry.m_numTerm24 + entry.m_numTerm32);
}

void hkpMoppStatisticsVirtualMachine::printStatistics(const hkpMoppCode* code)
{
    hkOstream ostream("MoppStatistics.txt");

    ostream.printf("\n\n************* Summary **********\n" );
    {
        Entry sum;
        hkString::memSet( &sum, 0, sizeof(sum));

        for (int i = 0; i < MAX_DEEP; i++)
        {
            int *s = (int*)&sum;
            int *a = (int*)(&m_bottomUp[i]);
            for (int j = 0; j < int(sizeof(Entry)/sizeof(int)); j++)
            {
                s[j] += a[j];
            }
        }
        printEntry(sum, ostream);
        int totalTerm = sum.m_numTerm4 + sum.m_numTerm8 + sum.m_numTerm16 + sum.m_numTerm24 + sum.m_numTerm32;

        ostream.printf("\n\n************* Bytes Used **********\n" );

        sum.m_numSplitA += sum.m_numSplitDiag;
        sum.m_numSplitDiag = 0;
        sum.m_numSplitA *= 4;

        sum.m_numSingleSplit *= 3;
        sum.m_numSingleSplitJump *= 7;

        sum.m_numDoubleCut *= 3;
        sum.m_numDoubleCut24 *= 7;
        sum.m_numJump8 *= 2;
        sum.m_numJump16 *= 2;
        sum.m_numJump24 *= 3;

        sum.m_numScale *= 4;

        sum.m_numReoffset8 *= 2;
        sum.m_numReoffset16 *= 3;
        sum.m_numReoffset32 *= 5;

        sum.m_numTerm8 *= 2;
        sum.m_numTerm16 *= 3;
        sum.m_numTerm24 *= 4;
        sum.m_numTerm32 *= 5;


        printEntry(sum, ostream);

        int totalBytes = 0;
        {
            int *s = (int*)&sum;
            for (int j = 0; j < int(sizeof(Entry)/sizeof(int)); j++)
            {
                totalBytes += s[j];
            }
        }

        ostream.printf("\n************* Total **********\n" );
        ostream.printf("\t bytes: %i\n", totalBytes);
        ostream.printf("\t tris:  %i\n", totalTerm);
        ostream.printf("\t bytes/tri: %f\n", float(totalBytes) / float(totalTerm) );

        ostream.printf("\t MOPP says: %i\n", code->m_data.getSize());


    }




    ostream.printf("\n\n************* Bottom Up **********\n" );
    {
        for (int i = 0; i < MAX_DEEP; i++)
        {
            ostream.printf("deep %i\n",i);
            printEntry(m_bottomUp[i], ostream);
        }
    }

    ostream.printf("\n\n************* Top Down **********\n" );
    {
        for (int i = 0; i < MAX_DEEP; i++)
        {
            ostream.printf("deep %i\n",i);
            printEntry(m_topDown[i], ostream);
        }
    }


}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
