// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachine.h>

class hkpMoppSphereVirtualMachine : public hkpMoppVirtualMachine
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppSphereVirtualMachine );

        struct hkpMoppSphereVirtualMachineQuery
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppSphereVirtualMachine::hkpMoppSphereVirtualMachineQuery );

            // this order must be preserved: x,y,z,radius
            int m_x;
            int m_y;
            int m_z;
            int m_radius;

            //the offset of the all previous scales are accumulated here
            int m_offset_x;
            int m_offset_y;
            int m_offset_z;
            // the current offset for the primitives
            unsigned int m_primitiveOffset;

            //the shifts from all previous scale commands are accumulated here
            int m_shift;

            unsigned int m_properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES];
        };

    public:

        // standard constructor
        inline hkpMoppSphereVirtualMachine();
        // standard destructor
        inline ~hkpMoppSphereVirtualMachine();

        /// run a query, the results are added to the hitlist
        // returns the number of hits
        void querySphere(const hkpMoppCode* code, const hkSphere &sphere, hkArray<hkpMoppPrimitiveInfo>* primitives_out);

        /// run a query on a P4 system
        // returns the number of hits
        void querySphereP4(const hkpMoppCode* code, const hkSphere &sphere, hkArray<hkpMoppPrimitiveInfo>* primitives_out);


    protected:
        //
        //these are for the sphere query
        //
        // this order must be preserved: x,y,z,radius
        HK_ALIGN16( hkpMoppFixedPoint m_x );
        hkpMoppFixedPoint m_y;
        hkpMoppFixedPoint m_z;
        hkpMoppFixedPoint m_radius;

        void querySphereOnTree  ( const hkpMoppSphereVirtualMachineQuery* query, const unsigned char* commands);
};

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppSphereVirtualMachine.inl>

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
