// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

// MOPP Virtual Machine implementation


// include all default MOPP headers
#include <Physics2012/Collide/hkpCollide.h>

#include <Common/Base/Types/Geometry/Sphere/hkSphere.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppSphereVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>


#define SPLIT2( POS )                                       \
            offseth = PC1<<1;                                       \
            offsetl = PC2<<1;                                       \
            position = POS;                                         \
            /* radius: approximate 1.4 for root 2   */              \
            radius = query->m_radius + (query->m_radius >> 1) + 1;  \
            goto do_compare;

#define SPLIT3( POS )                                       \
            offseth = (PC1<<1)+PC1;                             \
            offsetl = (PC2<<1)+PC2;                             \
            position = POS;                                         \
            /* radius: approximate 2.0 for root 3   */              \
            radius = query->m_radius << 2;                          \
            goto do_compare;

void hkpMoppSphereVirtualMachine::querySphereOnTree( const hkpMoppSphereVirtualMachineQuery* query, const unsigned char* PC)
{
    hkpMoppSphereVirtualMachineQuery scaledQuery; // for fast scale commands
    while (1)
    {
        HK_MOPP_LOAD_PC();

        int position;
        int radius;
        int offseth;
        int offsetl;

        switch (command)
        {
        case HK_MOPP_SPLIT_YZ:      SPLIT2( (query->m_y) + (query->m_z) );
        case HK_MOPP_SPLIT_YMZ:     SPLIT2( (query->m_y) + (HK_MOPP_RESOLUTION-query->m_z) );
        case HK_MOPP_SPLIT_XZ:      SPLIT2( (query->m_x) + (query->m_z) );
        case HK_MOPP_SPLIT_XMZ:     SPLIT2( (query->m_x) + (HK_MOPP_RESOLUTION-query->m_z) );
        case HK_MOPP_SPLIT_XY:      SPLIT2( (query->m_x) + (query->m_y) );
        case HK_MOPP_SPLIT_XMY:     SPLIT2( (query->m_x) + (HK_MOPP_RESOLUTION-query->m_y) );

        case HK_MOPP_SPLIT_XYZ:     SPLIT3( (query->m_x) + (query->m_y) + (query->m_z) );
        case HK_MOPP_SPLIT_XYMZ:        SPLIT3( (query->m_x) + (query->m_y) + (HK_MOPP_RESOLUTION-query->m_z) );
        case HK_MOPP_SPLIT_XMYZ:        SPLIT3( (query->m_x) + (HK_MOPP_RESOLUTION-query->m_y) + (query->m_z) );
        case HK_MOPP_SPLIT_XMYMZ:   SPLIT3( (query->m_x) + (HK_MOPP_RESOLUTION-query->m_y) + (HK_MOPP_RESOLUTION-query->m_z) );

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            offseth = PC1;
            offsetl = PC2;
            position = (&query->m_x)[command - HK_MOPP_SPLIT_X];
            radius = query->m_radius;
do_compare:
            {
                //move to the left branch
                const unsigned int offsetRB = PC3;
                PC += 4;

                // not in right branch -> traverse left only
                if ( (position + radius) < offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    continue;
                }

                PC += offsetRB;

                // now we have to check for traversing the right
                if ( position > offseth + radius )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    querySphereOnTree( query, PC - (offsetRB));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            offsetl = PC1;
            radius = query->m_radius;
            position = (&query->m_x)[command - HK_MOPP_SINGLE_SPLIT_X];
            {

                //move to the left branch
                const unsigned int offsetRB = PC2;
                PC += 3;
                // not in right branch -> traverse left only
                if ( (position + radius) < offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    continue;
                }
                PC += offsetRB;

                // now we have to check for traversing the right
                if ( position > offsetl + radius + 1 )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    querySphereOnTree( query, PC - (offsetRB));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            offseth = PC1;
            offsetl = PC2;

            position = (&query->m_x)[command - HK_MOPP_SPLIT_JUMP_X];
            radius = query->m_radius;
            {
                const unsigned int leftJump = (PC3 << 8) + (PC4);
                const unsigned int rightJump = (PC5 << 8) + (PC6);
                PC += 7;

                // not in right branch -> traverse left only
                if ( (position + radius) < offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    PC += leftJump;
                    continue;
                }

                PC += rightJump;

                // now we have to check for traversing the right
                if ( position > offseth + radius  )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    querySphereOnTree( query, PC - rightJump + leftJump );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            {
                position = (&query->m_x)[command - HK_MOPP_DOUBLE_CUT_X];
                radius = query->m_radius;
                offsetl = PC1;
                offseth = PC2;

                if( ( (position + radius) >= offsetl ) && ( position <= offseth + radius ) )
                {
                    PC += 3;
                    continue;
                }
                else
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            {
                position = (&this->m_x)[command - HK_MOPP_DOUBLE_CUT24_X];
                radius = this->m_radius;
                offsetl = ((PC1<<16) + (PC2<<8) + PC3);
                offseth = ((PC4<<16) + (PC5<<8) + PC6);

                if( ( (position + radius) >= offsetl ) && ( position <= offseth + radius ) )
                {
                    PC += 7;
                    continue;
                }
                else
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }
            }

        HK_MOPP_JUMP_MACRO


#define UPDATE_OFFSET( N, X )                                   \
    {                                                           \
        int offset = (PC##N + query->m_offset_##X)<<shift;      \
        scaledQuery.m_offset_##X = offset;                      \
        scaledQuery.m_##X = (int(m_##X) >> rShift) - offset;    \
    }


        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                const unsigned int shift = command - HK_MOPP_SCALE0;
                const unsigned int rShift = query->m_shift - shift;
                scaledQuery.m_shift = rShift;

                //the shift has been accumulating, and will be stored in child space
                UPDATE_OFFSET(1,x);
                UPDATE_OFFSET(2,y);
                UPDATE_OFFSET(3,z);

                scaledQuery.m_radius = 1 + (((int)m_radius) >> (rShift));

                scaledQuery.m_primitiveOffset = query->m_primitiveOffset;
                for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
                {
                    scaledQuery.m_properties[p] = query->m_properties[p];
                }

                //no need to copy anything except for the primitive offset
                query = &scaledQuery;

                PC += 4;
                continue;
            }

        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:

    return;
}

//
// query - for a sphere
//
void hkpMoppSphereVirtualMachine::querySphere(const hkpMoppCode* code, const hkSphere &sphere, hkArray<hkpMoppPrimitiveInfo>* primitiveResults) // true on successful execution
{
    const unsigned char* programCounter = &code->m_data[0];
    //the result list
    this->initQuery( primitiveResults );

    hkpMoppSphereVirtualMachineQuery query;

    const hkVector4& center = sphere.getPosition();

    //Scales the query into 16.16 fixed precision integer format
    m_x = toIntMin((center(0) - code->m_info.m_offset(0)) * code->m_info.getScale());
    m_y = toIntMin((center(1) - code->m_info.m_offset(1)) * code->m_info.getScale());
    m_z = toIntMin((center(2) - code->m_info.m_offset(2)) * code->m_info.getScale());
    m_radius = 1 + toIntMax( center(3) * code->m_info.getScale());

    query.m_x = m_x>>16;
    query.m_y = m_y>>16;
    query.m_z = m_z>>16;
    query.m_radius = (int)((m_radius>>16)+1);

    query.m_offset_x = 0;
    query.m_offset_y = 0;
    query.m_offset_z = 0;
    query.m_shift = 16;

    //any re-offsetting will occur in the tree
    query.m_primitiveOffset = 0;

    for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
    {
        query.m_properties[p] = 0;
    }


    //call the query with the left-of-decimal place part
    querySphereOnTree( &query, programCounter );
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
