// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

// MOPP Virtual Machine implementation


// include all default MOPP headers
#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppRayVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>

//#define HK_PRINTF(a) hkprintf a
#define HK_PRINTF(a)

#define SPLIT2( POSL, POSH )                                        \
            offseth = PC1<<1;                                       \
            offsetl = PC2<<1;                                       \
            positionl = POSL;                                       \
            positionh = POSH;                                       \
            /* radius: approximate 1.4 for root 2   */              \
            radius = query->m_radius + (query->m_radius >> 1) + 1;  \
            goto do_compare;

#define SPLIT3( POSL, POSH )                                        \
            offseth = (PC1<<1)+PC1;                             \
            offsetl = (PC2<<1)+PC2;                             \
            positionl = POSL;                                       \
            positionh = POSH;                                       \
            /* radius: approximate 2.0 for root 3   */              \
            radius = query->m_radius << 2;                          \
            goto do_compare;



void hkpMoppRayVirtualMachine::queryRayOnTree( const hkpMoppRayVirtualMachineQuery* query, const unsigned char* PC)
{
    hkpMoppRayVirtualMachineQuery scaledQuery; // for fast scale commands
    while (1)
    {
        HK_MOPP_LOAD_PC();

        int positionh,positionl;
        int radius;

        int offseth;
        int offsetl;

        HK_PRINTF(("PC: %5i: ", PC));
        switch (command)
        {

        case HK_MOPP_SPLIT_YZ:      SPLIT2( (query->m_starty) + (query->m_startz),                          (query->m_endy) + (query->m_endz) );
        case HK_MOPP_SPLIT_YMZ:     SPLIT2( (query->m_starty) + (HK_MOPP_RESOLUTION-query->m_startz),       (query->m_endy) + (HK_MOPP_RESOLUTION-query->m_endz) );
        case HK_MOPP_SPLIT_XZ:      SPLIT2( (query->m_startx) + (query->m_startz),                          (query->m_endx) + (query->m_endz) );
        case HK_MOPP_SPLIT_XMZ:     SPLIT2( (query->m_startx) + (HK_MOPP_RESOLUTION-query->m_startz),       (query->m_endx) + (HK_MOPP_RESOLUTION-query->m_endz) );
        case HK_MOPP_SPLIT_XY:      SPLIT2( (query->m_startx) + (query->m_starty),                          (query->m_endx) + (query->m_endy) );
        case HK_MOPP_SPLIT_XMY:     SPLIT2( (query->m_startx) + (HK_MOPP_RESOLUTION-query->m_starty),       (query->m_endx) + (HK_MOPP_RESOLUTION-query->m_endy) );

        case HK_MOPP_SPLIT_XYZ:     SPLIT3( (query->m_startx) + (query->m_starty) + (query->m_startz),                  (query->m_endx) + (query->m_endy) + (query->m_endz) );
        case HK_MOPP_SPLIT_XYMZ:        SPLIT3( (query->m_startx) + (query->m_starty) + (HK_MOPP_RESOLUTION-query->m_startz),(query->m_endx) + (query->m_endy) + (HK_MOPP_RESOLUTION-query->m_endz) );
        case HK_MOPP_SPLIT_XMYZ:        SPLIT3( (query->m_startx) + (HK_MOPP_RESOLUTION-query->m_starty) + (query->m_startz),(query->m_endx) + (HK_MOPP_RESOLUTION-query->m_endy) + (query->m_endz) );
        case HK_MOPP_SPLIT_XMYMZ:   SPLIT3( (query->m_startx) + (HK_MOPP_RESOLUTION-query->m_starty) + (HK_MOPP_RESOLUTION-query->m_startz), (query->m_endx) + (HK_MOPP_RESOLUTION-query->m_endy) + (HK_MOPP_RESOLUTION-query->m_endz) );

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            offseth = PC1;
            offsetl = PC2;
            positionl = (&query->m_startx)[command - HK_MOPP_SPLIT_X];
            positionh = (&query->m_endx)[command - HK_MOPP_SPLIT_X];
            radius = query->m_radius;
do_compare:
            {
                //move to the left branch
                const unsigned int offsetRB = PC3;
                PC += 4;

                // not in right branch -> traverse left only
                if ( (positionh + radius < offsetl) && (positionl + radius < offsetl) )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    continue;
                }

                PC += offsetRB;

                // now we have to check for traversing the right
                if ((positionl > offseth + radius) && (positionh > offseth + radius))
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryRayOnTree( query, PC - (offsetRB));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            offsetl = PC1;
            positionl = (&query->m_startx)[command - HK_MOPP_SINGLE_SPLIT_X];
            positionh = (&query->m_endx)  [command - HK_MOPP_SINGLE_SPLIT_X];
            radius = query->m_radius;
            {
                HK_PRINTF(("SingleSplit p(%d,%d,%d),(%d,%d,%d)->(%d,%d) r(%d), l(%d) h(%d) dir(%d)\n",query->m_startx,query->m_starty,query->m_startz,query->m_endx,query->m_endy,query->m_endz,positionl,positionh,radius,offsetl,offsetl+1,command));
                //move to the left branch
                const unsigned int offsetRB = PC2;
                PC += 3;
                // not in right branch -> traverse left only
                if ( (positionh + radius < offsetl) && (positionl + radius < offsetl))
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    continue;
                }
                PC += offsetRB;

                // now we have to check for traversing the right
                if ((positionl > offsetl + radius + 1) && (positionh > offsetl + radius + 1))
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryRayOnTree( query, PC - (offsetRB));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            offseth = PC1;
            offsetl = PC2;

            positionl = (&query->m_startx)[command - HK_MOPP_SPLIT_JUMP_X];
            positionh = (&query->m_endx)  [command - HK_MOPP_SPLIT_JUMP_X];

            radius = query->m_radius;
            {
                HK_PRINTF(("SingleSplitJump p(%d,%d,%d),(%d,%d,%d)->(%d,%d) r(%d), l(%d) h(%d) dir(%d)\n",query->m_startx,query->m_starty,query->m_startz,query->m_endx,query->m_endy,query->m_endz,positionl,positionh,radius,offsetl,offsetl+1,command));
                const unsigned int leftJump = (PC3 << 8) + (PC4);
                const unsigned int rightJump = (PC5 << 8) + (PC6);
                PC += 7;

                // not in right branch -> traverse left only
                if ( (positionh + radius < offsetl) && (positionl + radius < offsetl))
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    PC += leftJump;
                    continue;
                }

                PC += rightJump;

                // now we have to check for traversing the right
                if ( (positionl > offseth + radius) && (positionh > offseth + radius))
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryRayOnTree( query, PC - rightJump + leftJump );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            {
                positionl = (&query->m_startx)[command - HK_MOPP_DOUBLE_CUT_X];
                positionh = (&query->m_endx)  [command - HK_MOPP_DOUBLE_CUT_X];

                offsetl = PC1;
                offseth = PC2;
                radius = query->m_radius;

                if (
                        ((positionh + radius < offsetl) && (positionl + radius < offsetl))  ||
                        ((positionl > offseth + radius) && (positionh > offseth + radius))
                        )
                {
                    goto end_of_function;
                }
                {
                    PC += 3;
                    continue;
                }
            }
        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            {
                positionl = (&this->m_startx)[command - HK_MOPP_DOUBLE_CUT24_X];
                positionh = (&this->m_endx)  [command - HK_MOPP_DOUBLE_CUT24_X];

                offsetl = ((PC1<<16) + (PC2<<8) + PC3);
                offseth = ((PC4<<16) + (PC5<<8) + PC6);
                radius = query->m_radius;

                if (
                        ((positionh + radius < offsetl) && (positionl + radius < offsetl))  ||
                        ((positionl > offseth + radius) && (positionh > offseth + radius))
                        )
                {
                    goto end_of_function;
                }
                {
                    PC += 7;
                    continue;
                }
            }

        HK_MOPP_JUMP_MACRO

        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {

                const unsigned int shift = command - HK_MOPP_SCALE0;

                HK_PRINTF(("Rescale(%d) Offset(%d,%d,%d)\n",shift,PC1,PC2,PC3));

                //the shift has been accumulating, and will be stored in child space
                //the offset

                scaledQuery.m_offset_x = (PC1 + query->m_offset_x) << shift;
                scaledQuery.m_offset_y = (PC2 + query->m_offset_y) << shift;
                scaledQuery.m_offset_z = (PC3 + query->m_offset_z) << shift;

                scaledQuery.m_shift = query->m_shift + shift;
                const int rShift = 0x10 - scaledQuery.m_shift;

                scaledQuery.m_startx = ((int)m_startx) >> (rShift);
                //now subtract the offset in the child space (hence the offset shifting above)
                scaledQuery.m_startx -= scaledQuery.m_offset_x;

                scaledQuery.m_starty = ((int)m_starty) >> (rShift);
                scaledQuery.m_starty -= scaledQuery.m_offset_y;

                scaledQuery.m_startz = ((int)m_startz) >> (rShift);
                scaledQuery.m_startz -= scaledQuery.m_offset_z;

                scaledQuery.m_endx = ((int)m_endx) >> (rShift);
                //now subtract the offset in the child space (hence the offset shifting above)
                scaledQuery.m_endx -= scaledQuery.m_offset_x;

                scaledQuery.m_endy = ((int)m_endy) >> (rShift);
                scaledQuery.m_endy -= scaledQuery.m_offset_y;

                scaledQuery.m_endz = ((int)m_endz) >> (rShift);
                scaledQuery.m_endz -= scaledQuery.m_offset_z;

                scaledQuery.m_radius = 1 + (((int)m_radius) >> (rShift));

                //no need to copy anything except for the primitive offset and the properties
                for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES;p++)
                {
                    scaledQuery.m_properties[p] = query->m_properties[p];
                }

                scaledQuery.m_primitiveOffset = query->m_primitiveOffset;
                //no need to copy anything except for the primitive offset
                query = &scaledQuery;

                PC += 4;
                continue;
            }
        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:
    return;
}

//
// query - for a sphere
//
void hkpMoppRayVirtualMachine::queryRay(const hkpMoppCode* code, const hkVector4 &start, const hkVector4 &end, float inRadius, hkArray<hkpMoppPrimitiveInfo>* primitiveResults) // true on successful execution
{
    const unsigned char* programCounter = &code->m_data[0];

    //the result list
    this->initQuery( primitiveResults );

    //Scales the query into 16.16 fixed precision integer format

    hkpMoppRayVirtualMachineQuery query;

    m_startx = toIntMin((start(0) - code->m_info.m_offset(0)) * code->m_info.getScale());
    m_starty = toIntMin((start(1) - code->m_info.m_offset(1)) * code->m_info.getScale());
    m_startz = toIntMin((start(2) - code->m_info.m_offset(2)) * code->m_info.getScale());

    m_endx = toIntMax((end(0) - code->m_info.m_offset(0)) * code->m_info.getScale());
    m_endy = toIntMax((end(1) - code->m_info.m_offset(1)) * code->m_info.getScale());
    m_endz = toIntMax((end(2) - code->m_info.m_offset(2)) * code->m_info.getScale());
    m_radius = toIntMax( inRadius * code->m_info.getScale());

    query.m_startx = m_startx>>16;
    query.m_starty = m_starty>>16;
    query.m_startz = m_startz>>16;

    query.m_endx = m_endx>>16;
    query.m_endy = m_endy>>16;
    query.m_endz = m_endz>>16;

    //this is actually a sphere cast (though for most cases the radius will be 0)
    query.m_radius = (int)((m_radius>>16)+1);

    query.m_offset_x = 0;
    query.m_offset_y = 0;
    query.m_offset_z = 0;

    //any re-offsetting will occur in the tree
    query.m_primitiveOffset = 0;
    query.m_shift = 0;

    for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
    {
        query.m_properties[p] = 0;
    }

    //call the query with the left-of-decimal place part
    queryRayOnTree( &query, programCounter );
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
