// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachine.h>

#if defined(HK_PLATFORM_SPU)
#include <Common/Base/Spu/Dma/Manager/hkSpuDmaManager.h>
#endif

// 20
typedef int hkpMoppFixedPoint;

struct hkpMoppObbVirtualMachineQuery
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppObbVirtualMachineQuery );

    //since the box is converted to axis-aligned, we need only a min and max value
    HK_ALIGN16(int m_xHi);
    //for each of the major axes
    int m_yHi;
    int m_zHi;
    int m_HiPadding;

    int m_xLo;
    int m_yLo;
    int m_zLo;
    int m_LoPadding;

    //the offset of the all previous scales are accumulated here
    int m_offset_x;
    int m_offset_y;
    int m_offset_z;
    // the current offset for the primitives
    unsigned int m_primitiveOffset;

    //the shifts from all previous scale commands are accumulated here
    int m_shift;

    unsigned int m_properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES];

};

class HK_EXPORT_PHYSICS_2012 hkpMoppObbVirtualMachine : public hkpMoppVirtualMachine
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppObbVirtualMachine );

        // standard constructor
        inline hkpMoppObbVirtualMachine();
        // standard destructor
        inline ~hkpMoppObbVirtualMachine();

#if !defined(HK_PLATFORM_SPU)
        typedef hkArray<hkpMoppPrimitiveInfo>* hkpPrimitiveOutputArray;

        void queryObb(const hkpMoppCode* code, const hkTransform& BvToWorld, const hkVector4& extent, const float radius, hkArray<hkpMoppPrimitiveInfo>* primitives_out);
#else
        typedef hkpMoppPrimitiveInfo* hkpPrimitiveOutputArray;
#endif

#if !defined(HK_PLATFORM_SPU)
        void queryAabb(const hkpMoppCode* code, const hkAabb& aabb, hkpPrimitiveOutputArray primitives_out);
#else
        int queryAabbWithMaxCapacity(const hkpMoppCode* code, const hkAabb& aabb, hkpPrimitiveOutputArray primitives_out, int primitives_out_capacity);
#endif


    ////////////////////////////////////////////////////////////////
    //
    // THE REMAINDER OF THIS FILE IS FOR INTERNAL USE
    //
    ////////////////////////////////////////////////////////////////

    protected:
        HK_ALIGN16( hkpMoppFixedPoint m_xHi );  // for ps2
        hkpMoppFixedPoint   m_yHi;
        hkpMoppFixedPoint   m_zHi;
        hkpMoppFixedPoint   m_HiPadding;

        hkpMoppFixedPoint   m_xLo;
        hkpMoppFixedPoint   m_yLo;
        hkpMoppFixedPoint   m_zLo;
        hkpMoppFixedPoint   m_LoPadding;

        //the information about the byte tree
        const hkpMoppCode*  m_code;

        // If set (-1) this mask ensures that the chunkId is stored in the shape key
        int             m_reindexingMask;
    protected:

        void queryAabbOnTree    (const hkpMoppObbVirtualMachineQuery* query, const unsigned char* commands, int chunkOffset);
#if !defined(HK_PLATFORM_SPU)
        HK_INLINE void generateQueryFromNode(const hkVector4& extent, const hkTransform& BvToWorld, const float radius, hkpMoppObbVirtualMachineQuery& query);
#endif
        HK_INLINE void generateQueryFromAabb(const hkVector4& aabbMin, const hkVector4& aabbMax, hkpMoppObbVirtualMachineQuery& query);

};

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppObbVirtualMachine.inl>

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
