// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

// MOPP Virtual Machine implementation


// include all default MOPP headers
#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppObbVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>


//#define HK_PRINTF(a) hkprintf a
#define HK_PRINTF(a)

#define SPLIT2( POSL, POSH, NEG )                                   \
{                                                                   \
            offseth = int(PC1)<<1;                              \
            offsetl = int(PC2)<<1;                              \
            offseth -= (255 * NEG);                                 \
            offsetl -= (255 * NEG);                                 \
            positionl = POSL;                                       \
            positionh = POSH;                                       \
            goto do_compare;                                        \
}

#define SPLIT3( POSL, POSH, NEG )                                   \
{                                                                   \
            offseth = (int(PC1)<<1)+int(PC1);                   \
            offsetl = (int(PC2)<<1)+int(PC2);                   \
            offseth -= (255 * NEG);                                 \
            offsetl -= (255 * NEG);                                 \
            positionl = POSL;                                       \
            positionh = POSH;                                       \
            goto do_compare;                                        \
}


#if defined(HK_PLATFORM_SPU)
static inline const hkUint8* recheckCache( int chunkOffset, const hkUint8* originalBaseAddress, int dmaGroup )
{
    // Fetch the chunk
    const unsigned char* chunkAddress = originalBaseAddress + chunkOffset;
    unsigned char* chunkBase = (unsigned char*)g_SpuMoppCache->getFromMainMemoryInlined( chunkAddress, HK_MOPP_CHUNK_SIZE, dmaGroup, true );
    HK_ASSERT(0x45657653, ((hkUlong)chunkBase & HK_MOPP_CHUNK_MASK) == 0, "Cache must be aligned to HK_MOPP_CHUNK_SIZE bytes");
    return chunkBase;
}
#endif

void hkpMoppObbVirtualMachine::queryAabbOnTree(const hkpMoppObbVirtualMachineQuery* query, const unsigned char* HK_RESTRICT PC, int chunkOffset)
{
    // for fast scale commands
    hkpMoppObbVirtualMachineQuery scaledQuery;
    while (1)
    {
        HK_MOPP_LOAD_PC_INTEGERONLY();

        int positionh;
        int positionl;

        //these need to be changed later
        int offseth;
        int offsetl;

        HK_PRINTF(("PC: %5i: ", PC));

        //hkpMoppFixedPoint RS0 = query->m_xLo
        switch (command)
        {
#define RS(I) (query->m_##I##Lo)
#define RE(I) (query->m_##I##Hi)
        case HK_MOPP_SPLIT_YZ:      SPLIT2( (RS(y) + RS(z)),    (RE(y) + RE(z)), 0 );
        case HK_MOPP_SPLIT_YMZ:     SPLIT2( (RS(y) - RE(z)),    (RE(y) - RS(z)), 1 );
        case HK_MOPP_SPLIT_XZ:      SPLIT2( (RS(x) + RS(z)),    (RE(x) + RE(z)), 0 );
        case HK_MOPP_SPLIT_XMZ:     SPLIT2( (RS(x) - RE(z)),    (RE(x) - RS(z)), 1 );
        case HK_MOPP_SPLIT_XY:      SPLIT2( (RS(x) + RS(y)),    (RE(x) + RE(y)), 0 );
        case HK_MOPP_SPLIT_XMY:     SPLIT2( (RS(x) - RE(y)),    (RE(x) - RS(y)), 1 );

        case HK_MOPP_SPLIT_XYZ:     SPLIT3( (RS(x) + RS(y) + RS(z)),    (RE(x) + RE(y) + RE(z)), 0);
        case HK_MOPP_SPLIT_XYMZ:    SPLIT3( (RS(x) + RS(y) - RE(z)),    (RE(x) + RE(y) - RS(z)), 1);
        case HK_MOPP_SPLIT_XMYZ:    SPLIT3( (RS(x) - RE(y) + RS(z)),    (RE(x) - RS(y) + RE(z)), 1);
        case HK_MOPP_SPLIT_XMYMZ:   SPLIT3( (RS(x) - RE(y) - RE(z)),    (RE(x) - RS(y) - RS(z)), 2);
#undef RS
#undef RE

do_compare:
            {
                const unsigned int offsetRB = PC3;

                PC += 4;

                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    if ( positionl < offseth )
                    {
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                        continue;
                    }
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }

                // now we have to check for traversing the right
                if ( positionl >= offseth )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    PC += offsetRB;
                    continue;
                }
                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryAabbOnTree( query, PC, chunkOffset );
#if defined ( HK_PLATFORM_SPU )
                    const hkUint8* spuAddress = recheckCache( chunkOffset, m_originalBaseAddress, m_dmaGroup );

                    // We may have been given a different way in the cache so our local PC is potentially incorrect
                    // Since each chunk is aligned we can use the bottom bits and the new address
                    PC = (const unsigned char*) ( (hkUlong)spuAddress | ((hkUlong)PC & HK_MOPP_CHUNK_MASK ) );
#endif
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    PC += offsetRB;
                    continue;
                }
            }

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            offseth = PC1;
            offsetl = PC2;
            positionl = (&query->m_xLo)[command - HK_MOPP_SPLIT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SPLIT_X];
            {
                //move to the left branch
                const unsigned int offsetRB = PC3;
                PC += 4;
                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    if ( positionl < offseth )
                    {
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                        continue;
                    }
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }

                PC += offsetRB;

                // now we have to check for traversing the right
                if ( positionl >= offseth )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryAabbOnTree( query, PC - (offsetRB), chunkOffset);
#if defined ( HK_PLATFORM_SPU )
                    const hkUint8* spuAddress = recheckCache( chunkOffset, m_originalBaseAddress, m_dmaGroup );

                    // We may have been given a different way in the cache so our local PC is potentially incorrect
                    // Since each chunk is aligned we can use the bottom bits and the new address
                    PC = (const unsigned char*) ( (hkUlong)spuAddress | ((hkUlong)PC & HK_MOPP_CHUNK_MASK ) );
#endif
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            offsetl = PC1;
            positionl = (&query->m_xLo)[command - HK_MOPP_SINGLE_SPLIT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SINGLE_SPLIT_X];
            {
                //move to the left branch
                const unsigned int offsetRB = PC2;
                PC += 3;
                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    continue;
                }
                PC += offsetRB;

                // now we have to check for traversing the right
                if ( positionl > offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryAabbOnTree( query, PC - (offsetRB), chunkOffset);
#if defined ( HK_PLATFORM_SPU )
                    const hkUint8* spuAddress = recheckCache( chunkOffset, m_originalBaseAddress, m_dmaGroup );

                    // We may have been given a different way in the cache so our local PC is potentially incorrect
                    // Since each chunk is aligned we can use the bottom bits and the new address
                    PC = (const unsigned char*) ( (hkUlong)spuAddress | ((hkUlong)PC & HK_MOPP_CHUNK_MASK ) );
#endif
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }


        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            offseth = PC1;
            offsetl = PC2;

            positionl = (&query->m_xLo)[command - HK_MOPP_SPLIT_JUMP_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SPLIT_JUMP_X];
            {
                const unsigned int leftJump = (PC3 << 8) + (PC4);
                const unsigned int rightJump = (PC5 << 8) + (PC6);
                PC += 7;

                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    if ( positionl < offseth )
                    {
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                        PC += leftJump;
                        continue;
                    }
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }

                PC += rightJump;

                // now we have to check for traversing the right
                if ( positionl >= offseth )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the OBB is either on one (or both of the planes) or it is in between
                {
                    //put in the node splitting code here

                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryAabbOnTree( query, PC - rightJump + leftJump, chunkOffset);
#if defined ( HK_PLATFORM_SPU )
                    const hkUint8* spuAddress = recheckCache( chunkOffset, m_originalBaseAddress, m_dmaGroup );

                    // We may have been given a different way in the cache so our local PC is potentially incorrect
                    // Since each chunk is aligned we can use the bottom bits and the new address
                    PC = (const unsigned char*) ( (hkUlong)spuAddress | ((hkUlong)PC & HK_MOPP_CHUNK_MASK ) );
#endif
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            positionl = (&query->m_xLo)[command - HK_MOPP_DOUBLE_CUT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_DOUBLE_CUT_X];
            {
                offsetl = PC1;
                offseth = PC2;

                if( (positionh < offsetl) || (positionl >= offseth) )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }
                else
                {
                    PC += 3;
                    continue;
                }
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            positionl = (&this->m_xLo)[command - HK_MOPP_DOUBLE_CUT24_X];
            positionh = (&this->m_xHi)[command - HK_MOPP_DOUBLE_CUT24_X];
            {
                offsetl = ((PC1<<16) + (PC2<<8) + PC3);
                offseth = ((PC4<<16) + (PC5<<8) + PC6);

                if( (positionh >= offsetl) && (positionl <= offseth) )
                {
                    PC += 7;
                    continue;
                }
                else
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }
            }

        HK_MOPP_JUMP_MACRO

        case HK_MOPP_JUMP_CHUNK:
        {
            const int chunkId = ( PC1 << 8 ) |  PC2;
            chunkOffset = HK_MOPP_CHUNK_SIZE * chunkId;
            goto jumpRecheckCache;

        }

        case HK_MOPP_JUMP_CHUNK32:
        {
                chunkOffset = (PC1<<24) + (PC2<<16) + (PC3<<8) + PC4;
jumpRecheckCache:

#if defined(HK_PLATFORM_SPU)
                const hkUint8* spuAddress = recheckCache( chunkOffset, m_originalBaseAddress, m_dmaGroup );
                PC = spuAddress;
#else
                const unsigned char* jumpAddress = m_code->m_data.begin() + chunkOffset;
                PC = jumpAddress;
#endif
                continue;
        }

        case HK_MOPP_DATA_OFFSET:
            {
                // dataOffset = ( PC1 << 8 ) |  PC2;
                // numTerminals = ( PC3 << 8 ) |  PC4;
                // Skip over the command
                PC+=5;
                continue;
            }

        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                const unsigned int shift = command - HK_MOPP_SCALE0;

                //the shift has been accumulating, and will be stored in child space
                //the offset
#if ( defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_SIM) ) || defined(HK_PLATFORM_XBOX360)
                volatile hkpMoppObbVirtualMachineQuery& q = scaledQuery;
#else
#               define q scaledQuery
#endif
                q.m_offset_x = (PC1   + query->m_offset_x) << shift;
                q.m_offset_y = (PC2   + query->m_offset_y) << shift;
                q.m_offset_z = (PC3 + query->m_offset_z) << shift;

                q.m_shift = query->m_shift + shift;
                const int rShift = 0x10 - scaledQuery.m_shift;

                q.m_xLo = (int(m_xLo) >> rShift) - q.m_offset_x;    // and subtract the offset in the child space (hence the offset shifting above)
                q.m_yLo = (int(m_yLo) >> rShift) - q.m_offset_y;
                q.m_zLo = (int(m_zLo) >> rShift) - q.m_offset_z;

                q.m_xHi = (int(m_xHi) >> rShift) + (1 - q.m_offset_x);
                q.m_yHi = (int(m_yHi) >> rShift) + (1 - q.m_offset_y);
                q.m_zHi = (int(m_zHi) >> rShift) + (1 - q.m_offset_z);

#if ( defined(HK_PLATFORM_WIN32) && !defined(HK_PLATFORM_SIM) ) || defined(HK_PLATFORM_XBOX360)
#else
#   undef q
#endif
                //no need to copy anything except for the primitive offset and the properties
                for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
                {
                    scaledQuery.m_properties[p] = query->m_properties[p];
                }

                scaledQuery.m_primitiveOffset = query->m_primitiveOffset;
                query = &scaledQuery;

                PC += 4;
                continue;
            }
        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_CHUNK_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:
    return;
}

#if !defined(HK_PLATFORM_SPU)

void hkpMoppObbVirtualMachine::generateQueryFromNode(const hkVector4& extent, const hkTransform& BvToWorld, const float radius, hkpMoppObbVirtualMachineQuery& query)
{
    const hkRotation& rot = BvToWorld.getRotation();

    hkVector4 e0; e0.setBroadcast<0>( extent );
    hkVector4 e1; e1.setBroadcast<1>( extent );
    hkVector4 e2; e2.setBroadcast<2>( extent );

    hkVector4 transformedX;
    hkVector4 transformedY;
    hkVector4 transformedZ;

    transformedX.setMul(e0, rot.getColumn<0>() );
    transformedY.setMul(e1, rot.getColumn<1>() );
    transformedZ.setMul(e2, rot.getColumn<2>() );


    transformedX.setAbs(transformedX);
    transformedY.setAbs(transformedY);
    transformedZ.setAbs(transformedZ);

    {
        hkVector4 max;
        max.setAdd(transformedX,transformedY);
        max.add(transformedZ);

        hkSimdReal rad4;    rad4.setFromFloat(radius);

        max.setAdd(max,rad4);

        hkVector4 min;
        min.setNeg<4>(max);

        hkVector4 offset; offset.setSub(BvToWorld.getTranslation(), m_code->m_info.m_offset );
        max.add(offset);
        min.add(offset);

        hkSimdReal scale; scale.setFromFloat(m_code->m_info.getScale());
        max.mul( scale );
        min.mul( scale );

        //Scales the query into 16.16 fixed precision integer format
        hkIntVector i_min; i_min.setConvertF32toS32(min);
        hkIntVector i_max; i_max.setConvertF32toS32(max);
        m_xLo = i_min.getU32<0>()-1;
        m_xHi = i_max.getU32<0>()+1;

        m_yLo = i_min.getU32<1>()-1;
        m_yHi = i_max.getU32<1>()+1;

        m_zLo = i_min.getU32<2>()-1;
        m_zHi = i_max.getU32<2>()+1;
    }


    query.m_xLo = (m_xLo >> 16);
    query.m_xHi = (m_xHi >> 16) + 1;

    query.m_yLo = (m_yLo >> 16);
    query.m_yHi = (m_yHi >> 16) + 1;

    query.m_zLo = (m_zLo >> 16);
    query.m_zHi = (m_zHi >> 16) + 1;

    query.m_offset_x = 0;
    query.m_offset_y = 0;
    query.m_offset_z = 0;

    //any re-offsetting will occur in the tree
    query.m_primitiveOffset = 0;
    query.m_shift = 0;

    HK_COMPILE_TIME_ASSERT( hkpMoppCode::MAX_PRIMITIVE_PROPERTIES == 1);
    query.m_properties[0] = 0;

    /*
    for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
    {
        query.m_properties[p] = 0;
    }
    */

    //now that the tempState is the currentState, we can override the currentState
}

//
// query - for an OBB
//
void hkpMoppObbVirtualMachine::queryObb(const hkpMoppCode* code, const hkTransform& BvToWorld, const hkVector4& extent, const float radius, hkArray<hkpMoppPrimitiveInfo>* primitives_out)
{

    m_code = code;


    this->initQuery( primitives_out );

    HK_ALIGN16( hkpMoppObbVirtualMachineQuery query );

    generateQueryFromNode(extent,BvToWorld,radius,query);


    //call the query with the left-of-decimal place part
    const unsigned char* programCounter = &m_code->m_data[0];

    // If the MOPP code contains terminal data then we need to reindex the terminals
    m_reindexingMask = (*programCounter == HK_MOPP_DATA_OFFSET) ? 0xffffffff : 0x00000000;

    queryAabbOnTree( &query, programCounter, 0);
}
#endif


//
// query - for an AABB with an extra radius
//
#if !defined(HK_PLATFORM_SPU)
void hkpMoppObbVirtualMachine::queryAabb(const hkpMoppCode* code, const hkAabb& aabb, hkpMoppObbVirtualMachine::hkpPrimitiveOutputArray primitives_out)
#else
int hkpMoppObbVirtualMachine::queryAabbWithMaxCapacity(const hkpMoppCode* code, const hkAabb& aabb, hkpMoppObbVirtualMachine::hkpPrimitiveOutputArray primitives_out, int primitives_out_capacity)
#endif
{
    //HK_INTERNAL_TIMER_BEGIN_LIST("mopp", "setup" );
    m_code = code;

#if !defined(HK_PLATFORM_SPU)
    this->initQuery( primitives_out );
#else
    this->initQuery( primitives_out, primitives_out_capacity );
#endif

    HK_ALIGN16( hkpMoppObbVirtualMachineQuery query );

    generateQueryFromAabb(aabb.m_min, aabb.m_max , query);

#ifdef HK_PLATFORM_SPU
    m_originalBaseAddress = code->m_data.begin();

    const int moppBytes = hkMath::min2( HK_MOPP_CHUNK_SIZE, HK_NEXT_MULTIPLE_OF(16, code->m_data.getSize()) );
    const hkpMoppChunk* spuCode = (const hkpMoppChunk*)g_SpuMoppCache->getFromMainMemoryInlined( m_originalBaseAddress, moppBytes, m_dmaGroup, true );

    HK_DECLARE_ALIGNED_LOCAL_PTR( hkpMoppCode, spuMoppCode, 16 );
    spuMoppCode->initialize( code->m_info, (const hkUint8*)spuCode, moppBytes );
    code = spuMoppCode;
#endif

    //call the query with the left-of-decimal place part
    const unsigned char* programCounter = &code->m_data[0];

    // If the MOPP code contains terminal data then we need to reindex the terminals
    m_reindexingMask = (*programCounter == HK_MOPP_DATA_OFFSET) ? 0xffffffff : 0x00000000;

    //HK_INTERNAL_TIMER_SPLIT_LIST("query");
    queryAabbOnTree( &query, programCounter, 0);
    //HK_INTERNAL_TIMER_END_LIST();

#if defined(HK_PLATFORM_SPU)
    return m_primitives_idx;
#endif
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
