// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppObbVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppModifier.h>

class HK_EXPORT_PHYSICS_2012 hkpMoppModifyVirtualMachine : public hkpMoppObbVirtualMachine
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppModifyVirtualMachine );

        // standard constructor
        inline hkpMoppModifyVirtualMachine(){}
        // standard destructor
        inline ~hkpMoppModifyVirtualMachine(){}

            /// Read the hkMoppModifyVirtualMachine_queryAabb documentation
        void queryAabb( const hkpMoppCode* code, const hkAabb& aabb, hkpMoppModifier* modifierOut );

    protected:
        HK_INLINE void addHit(unsigned int id, const unsigned int properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES], hkUlong chunkId=0);

            /// returns true if this node should be removed
        hkBool queryModicationPointsRecursive   (const hkpMoppObbVirtualMachineQuery* query, const unsigned char* commands, int chunkId);

    protected:
        hkBool          m_tempLastShouldTerminalBeRemoved;
        hkpMoppModifier* m_modifier;

        // If set (-1) this mask ensures that the chunkId is stored in the shape key
        int m_reindexingMask;
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
