// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

// MOPP Virtual Machine implementation


// include all default MOPP headers
#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppModifyVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>


void hkpMoppModifyVirtualMachine::addHit(unsigned int id, const unsigned int properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES], hkUlong chunkId_unused)
{
    m_tempLastShouldTerminalBeRemoved = m_modifier->shouldTerminalBeRemoved( id, properties );
}


#define SPLIT2( POSL, POSH, NEG )                                   \
{                                                                   \
            offseth = PC1<<1;                                       \
            offsetl = PC2<<1;                                       \
            offseth -= (255 * NEG);                                 \
            offsetl -= (255 * NEG);                                 \
            positionl = POSL;                                       \
            positionh = POSH;                                       \
            goto do_compare;                                        \
}

#define SPLIT3( POSL, POSH, NEG )                                   \
{                                                                   \
            offseth = (PC1<<1)+PC1;                             \
            offsetl = (PC2<<1)+PC2;                             \
            offseth -= (255 * NEG);                                 \
            offsetl -= (255 * NEG);                                 \
            positionl = POSL;                                       \
            positionh = POSH;                                       \
            goto do_compare;                                        \
}




hkBool hkpMoppModifyVirtualMachine::queryModicationPointsRecursive(const hkpMoppObbVirtualMachineQuery* query, const unsigned char* PC, int chunkOffset)
{
    // for fast scale commands
    hkpMoppObbVirtualMachineQuery scaledQuery;
    while (1)
    {
        HK_MOPP_LOAD_PC();

        int positionh,positionl;

        int offsetl;
        int offseth;

        unsigned int offsetLB;
        unsigned int offsetRB;

        switch (command)
        {
#define RS(I) ((&query->m_xLo)[I])
#define RE(I) ((&query->m_xHi)[I])
        case HK_MOPP_SPLIT_YZ:      SPLIT2( (RS(1) + RS(2)),    (RE(1) + RE(2)), 0 );
        case HK_MOPP_SPLIT_YMZ:     SPLIT2( (RS(1) - RE(2)),    (RE(1) - RS(2)), 1 );
        case HK_MOPP_SPLIT_XZ:      SPLIT2( (RS(0) + RS(2)),    (RE(0) + RE(2)), 0 );
        case HK_MOPP_SPLIT_XMZ:     SPLIT2( (RS(0) - RE(2)),    (RE(0) - RS(2)), 1 );
        case HK_MOPP_SPLIT_XY:      SPLIT2( (RS(0) + RS(1)),    (RE(0) + RE(1)), 0 );
        case HK_MOPP_SPLIT_XMY:     SPLIT2( (RS(0) - RE(1)),    (RE(0) - RS(1)), 1 );

        case HK_MOPP_SPLIT_XYZ:     SPLIT3( (RS(0) + RS(1) + RS(2)),    (RE(0) + RE(1) + RE(2)), 0);
        case HK_MOPP_SPLIT_XYMZ:    SPLIT3( (RS(0) + RS(1) - RE(2)),    (RE(0) + RE(1) - RS(2)), 1);
        case HK_MOPP_SPLIT_XMYZ:    SPLIT3( (RS(0) - RE(1) + RS(2)),    (RE(0) - RS(1) + RE(2)), 1);
        case HK_MOPP_SPLIT_XMYMZ:   SPLIT3( (RS(0) - RE(1) - RE(2)),    (RE(0) - RS(1) - RS(2)), 2);
#undef RS
#undef RE
        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            offseth = PC1;
            offsetl = PC2;
            positionl = (&query->m_xLo)[command - HK_MOPP_SPLIT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SPLIT_X];
            goto do_compare;

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            offsetl = PC1;
            offseth = offsetl+1;
            positionl = (&query->m_xLo)[command - HK_MOPP_SINGLE_SPLIT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SINGLE_SPLIT_X];
            PC -= 1;
            HK_MOPP_RELOAD_PC();
            goto do_compare;

        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            offseth = PC1;
            offsetl = PC2;
            positionl = (&query->m_xLo)[command - HK_MOPP_SPLIT_JUMP_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SPLIT_JUMP_X];
            {
                offsetLB = (PC3 << 8) + (PC4);
                offsetRB = (PC5 << 8) + (PC6);
                PC += 7;
                goto do_compare2;
            }

do_compare:
            {
                //move to the left branch
                offsetLB = 0;
                offsetRB = PC3;
                PC += 4;
            }
do_compare2:
            {
                hkBool removeLeftChild = false;
                hkBool removeRightChild = false;

                while(1)
                {
                    // not in right branch -> traverse left only
                    if ( positionh <= offsetl )
                    {
                        if ( positionl < offseth )
                        {
                            HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                            HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                            removeLeftChild = queryModicationPointsRecursive( query, PC + offsetLB, chunkOffset);
                            break;
                        }
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                        return false;
                    }


                    // now we have to check for traversing the right
                    if ( positionl >= offseth )
                    {
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                        removeRightChild = queryModicationPointsRecursive( query, PC + offsetRB, chunkOffset);
                        break;
                    }

                    //the point is either on one (or both of the planes) or it is in between
                    {
                        HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                        //move to the left branch
                        removeLeftChild = queryModicationPointsRecursive( query, PC + offsetLB, chunkOffset);
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                        removeRightChild = queryModicationPointsRecursive( query, PC + offsetRB, chunkOffset);
                        break;
                    }
                } // while(1)
                if ( removeLeftChild & !removeRightChild)
                {
                    m_modifier->addTerminalRemoveInfo( hkPointerToInt32(PC) + offsetLB - hkPointerToInt32(&m_code->m_data[0]));
                }
                if ( removeRightChild & !removeLeftChild)
                {
                    m_modifier->addTerminalRemoveInfo( hkPointerToInt32(PC) + offsetRB - hkPointerToInt32(&m_code->m_data[0]));
                }
                return removeLeftChild & removeRightChild;
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            positionl = (&query->m_xLo)[command - HK_MOPP_DOUBLE_CUT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_DOUBLE_CUT_X];
            {
                offsetl = PC1;
                offseth = PC2;

                if( (positionh < offsetl) || (positionl >= offseth) )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    return false;
                }
                else
                {
                    PC += 3;
                    continue;
                }
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            positionl = (&this->m_xLo)[command - HK_MOPP_DOUBLE_CUT24_X];
            positionh = (&this->m_xHi)[command - HK_MOPP_DOUBLE_CUT24_X];
            {
                offsetl = ((PC1<<16) + (PC2<<8) + PC3);
                offseth = ((PC4<<16) + (PC5<<8) + PC6);

                if( (positionh >= offsetl) && (positionl <= offseth) )
                {
                    PC += 7;
                    continue;
                }
                else
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    return false;
                }
            }

        HK_MOPP_JUMP_MACRO

        case HK_MOPP_JUMP_CHUNK:
            {
                const int chunkId = ( PC1 << 8 ) |  PC2;
                chunkOffset = chunkId * HK_MOPP_CHUNK_SIZE;
                const unsigned char* jumpAddress = m_code->m_data.begin() + chunkOffset;
                PC = jumpAddress;
                continue;
            }

        case HK_MOPP_JUMP_CHUNK32:
            {
                chunkOffset = (PC1<<24) + (PC2<<16) + (PC3<<8) + PC4;
                const unsigned char* jumpAddress = m_code->m_data.begin() + chunkOffset;
                PC = jumpAddress;
                continue;
            }


        case HK_MOPP_DATA_OFFSET:
            {
                // dataOffset = ( PC1 << 8 ) |  PC2;
                // numTerminals = ( PC3 << 8 ) |  PC4;
                // Skip over the command
                PC+=5;
                continue;
            }

        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                const unsigned int shift = command - HK_MOPP_SCALE0;

                //the shift has been accumulating, and will be stored in child space
                //the offset

                scaledQuery.m_offset_x = (PC1 + query->m_offset_x) << shift;
                scaledQuery.m_offset_y = (PC2 + query->m_offset_y) << shift;
                scaledQuery.m_offset_z = (PC3 + query->m_offset_z) << shift;

                scaledQuery.m_shift = query->m_shift + shift;
                const int rShift = 0x10 - scaledQuery.m_shift;

                scaledQuery.m_xLo = (int(m_xLo) >> rShift) - scaledQuery.m_offset_x;    // and subtract the offset in the child space (hence the offset shifting above)
                scaledQuery.m_yLo = (int(m_yLo) >> rShift) - scaledQuery.m_offset_y;
                scaledQuery.m_zLo = (int(m_zLo) >> rShift) - scaledQuery.m_offset_z;

                scaledQuery.m_xHi = (int(m_xHi) >> rShift) + (1 - scaledQuery.m_offset_x);
                scaledQuery.m_yHi = (int(m_yHi) >> rShift) + (1 - scaledQuery.m_offset_y);
                scaledQuery.m_zHi = (int(m_zHi) >> rShift) + (1 - scaledQuery.m_offset_z);

                //no need to copy anything except for the primitive offset and the properties
                for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
                {
                    scaledQuery.m_properties[p] = query->m_properties[p];
                }

                scaledQuery.m_primitiveOffset = query->m_primitiveOffset;
                query = &scaledQuery;

                PC += 4;
                continue;
            }
        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_CHUNK_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:
    return m_tempLastShouldTerminalBeRemoved;
}

//
// query - for an AABB with an extra radius
//
void hkpMoppModifyVirtualMachine::queryAabb(const hkpMoppCode* code, const hkAabb& aabb, hkpMoppModifier* modifierOut)
{
    //HK_INTERNAL_TIMER_BEGIN_LIST("mopp", "setup" );
    m_code = code;
    m_modifier = modifierOut;

    this->initQuery( HK_NULL );

    HK_ALIGN16( hkpMoppObbVirtualMachineQuery query );

    generateQueryFromAabb(aabb.m_min, aabb.m_max ,query);

    //call the query with the left-of-decimal place part
    const unsigned char* programCounter = &m_code->m_data[0];

    // If the MOPP code contains terminal data then we need to reindex the terminals
    m_reindexingMask = (*programCounter == HK_MOPP_DATA_OFFSET) ? 0xffffffff : 0x00000000;

    //HK_INTERNAL_TIMER_SPLIT_LIST("query");
    hkBool shouldRemove = queryModicationPointsRecursive( &query, programCounter, 0);
    if ( shouldRemove )
    {
        int offset = (m_code->m_data[0] == HK_MOPP_DATA_OFFSET) ? 5 : 0;
        modifierOut->addTerminalRemoveInfo( offset );
    }
    //HK_INTERNAL_TIMER_END_LIST();
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
