// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

    /// Interface used by a MOPP machine to add/remove terminals from an existing MOPP.
    /// Read hkMoppModifyVirtualMachine_queryAabb for details
class HK_EXPORT_PHYSICS_2012 hkpMoppModifier
{
    public:
        HK_DECLARE_CLASS(hkpMoppModifier, New, ReflectVirtualBase);
        HK_RECORD_ATTR(hk::Serialize(false));

        virtual ~hkpMoppModifier() { }

            /// Implementations of this function should return true for every terminal, which should be removed
        virtual hkBool shouldTerminalBeRemoved( unsigned int id, const unsigned int *properties ) = 0;

            /// This function will be called for every subtree which has only 'to-be-removed' children.
            /// Changing the MOPP code at this address to zero will remove those children.
        virtual void addTerminalRemoveInfo( int relativeMoppAddress ) = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
