// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
//

#include <Physics2012/Collide/hkpCollide.h>

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppMachine.h>

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppFindAllVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppSphereVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppObbVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppEarlyExitObbVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppUsingFloatAabbVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppModifyVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppKDopGeometriesVirtualMachine.h>

// moved from hkMoppVirtualMachineMacros.h
HK_COMPILE_TIME_ASSERT( hkpMoppCode::MAX_PRIMITIVE_PROPERTIES == 1);

// For sphere queries
class hkMoppSphereQueryObject: public hkpMoppQueryObject
{
    public:
        HK_INLINE hkpCheckCollisionResult checkCollision( const hkAabb& aabb, const hkpMoppFindAllVirtualMachine::hkpMoppFindAllVirtualMachineQuery* query, const unsigned char* commands );
        HK_INLINE void initializeQueryObject( const hkSphere& sphere, const hkpMoppCode* code);
        hkSphere m_sphere2;  // the sphere*2
};

class hkMoppSphereQueryObjectOptimized: public hkMoppSphereQueryObject
{
    public:
        HK_INLINE hkpCheckCollisionResult checkCollision( const hkAabb& aabb, const hkpMoppFindAllVirtualMachine::hkpMoppFindAllVirtualMachineQuery* query, const unsigned char* commands );
};



class hkMoppPlanesQueryObject: public hkpMoppQueryObject
{
    public:
        HK_INLINE hkpCheckCollisionResult checkCollision( const hkAabb& aabb, const hkpMoppFindAllVirtualMachine::hkpMoppFindAllVirtualMachineQuery* query, const unsigned char* commands );
        HK_INLINE void initializeQueryObject( const hkpMoppPlanesQueryInput& sphere, const hkpMoppCode* code);

    protected:
        int m_numTransforms;

            // The rotated plane equations.
        hkTransform m_rotatedPlanes[hkpMoppPlanesQueryInput::HK_MAX_NUM_PLANES/4];
        hkTransform m_absRotPlanes[hkpMoppPlanesQueryInput::HK_MAX_NUM_PLANES/4];
};


class hkMoppPlanesQueryObjectOptimized: public hkMoppPlanesQueryObject
{
    public:
        HK_INLINE hkpCheckCollisionResult checkCollision( const hkAabb& aabb, const hkpMoppFindAllVirtualMachine::hkpMoppFindAllVirtualMachineQuery* query, const unsigned char* commands );
};



hkMoppSphereQueryObject::hkpCheckCollisionResult hkMoppSphereQueryObject::checkCollision( const hkAabb& aabb, const hkpMoppFindAllVirtualMachine::hkpMoppFindAllVirtualMachineQuery* query, const unsigned char* commands )
{
    hkVector4 center2; center2.setAdd( aabb.m_min, aabb.m_max);
    hkVector4 extents2; extents2.setSub( aabb.m_max, aabb.m_min );

    center2.sub( m_sphere2.getPosition());
    center2.setAbs( center2);

    hkVector4 clippedCenter;
    clippedCenter.setMin( center2,  extents2);

    hkVector4 diff; diff.setSub( clippedCenter, center2);

    hkSimdReal dist2Squared = diff.lengthSquared<3>();

    hkSimdReal radius = m_sphere2.getPositionAndRadius().getW();
    hkSimdReal rad2Squared = radius * radius;
    if ( dist2Squared >  rad2Squared)
    {
        return HK_NO_HIT;
    }

    hkVector4 oppositeCorner; oppositeCorner.setAdd( center2, extents2);
    hkSimdReal dist2 = oppositeCorner.lengthSquared<3>();
    if ( dist2 < rad2Squared)
    {
        this->queryOnTree( query, commands );
        return HK_INCLUDED;
    }

    return HK_HIT;
}

hkMoppSphereQueryObject::hkpCheckCollisionResult hkMoppSphereQueryObjectOptimized::checkCollision( const hkAabb& aabb, const hkpMoppFindAllVirtualMachine::hkpMoppFindAllVirtualMachineQuery* query, const unsigned char* commands )
{
    hkVector4 center2; center2.setAdd( aabb.m_min, aabb.m_max);
    hkVector4 extents2; extents2.setSub( aabb.m_max, aabb.m_min );

    center2.sub( m_sphere2.getPosition());
    center2.setAbs( center2);

    hkVector4 clippedCenter;
    clippedCenter.setMin( center2,  extents2);

    hkVector4 diff; diff.setSub( clippedCenter, center2);

    hkSimdReal dist2Squared = diff.lengthSquared<3>();
    hkSimdReal radius = m_sphere2.getPositionAndRadius().getW();
    hkSimdReal rad2Squared = radius * radius;
    if ( dist2Squared >  rad2Squared)
    {
        return HK_NO_HIT;
    }

    hkVector4 oppositeCorner; oppositeCorner.setAdd( center2, extents2);
    hkSimdReal dist2 = oppositeCorner.lengthSquared<3>();
    if ( dist2 < rad2Squared)
    {
        this->queryOnTreeLeft( query, commands );
        this->queryOnTreeRight( query, commands );
        return HK_INCLUDED;
    }

    return HK_HIT;
}

void hkMoppSphereQueryObject::initializeQueryObject( const hkSphere& sphere, const hkpMoppCode* code )
{
    const hkVector4 sph = sphere.getPositionAndRadius();
    hkVector4 center2;
    center2.setSub( sph, code->m_info.m_offset );
    center2.add( center2 );
    this->m_sphere2.setPositionAndRadius( center2, sph.getW() * hkSimdReal_2 );
}

void hkMoppPlanesQueryObject::initializeQueryObject( const hkpMoppPlanesQueryInput& in, const hkpMoppCode* code )
{
    HK_ASSERT(0x4fca669d,  in.m_numPlanes < hkpMoppPlanesQueryInput::HK_MAX_NUM_PLANES, "Maximum number of planes exceeded");

    // copy planes
    int end = in.m_numPlanes & ~3;
    hkTransform* destTrans = this->m_rotatedPlanes;
    const hkVector4* planes = in.m_planes;
    m_numTransforms = 0;

    int i;
    for ( i = 0; i < end; i+=4)
    {
        destTrans->setRows4( planes[0], planes[1], planes[2], planes[3]);
        destTrans++;
        m_numTransforms++;
        planes += 4;
    }

    const hkVector4* p0 = planes;
    const hkVector4* p1 = planes+1;
    const hkVector4* p2 = planes+2;
    const hkVector4* p3 = planes+3;
    switch ( in.m_numPlanes - i )
    {
    case 0:
        break;
    case 1:
        p1 = p0;
    case 2:
        p2 = p0;
    case 3:
        p3 = p0;

        destTrans->setRows4(*p0,*p1,*p2,*p3);
        destTrans++;
        m_numTransforms++;
    }

    hkTransform* absTrans = m_absRotPlanes + m_numTransforms;
    absTrans--;
    destTrans--;

    while ( destTrans >= &m_rotatedPlanes[0] )
    {
        absTrans->getColumn(0).setAbs( destTrans->getColumn<0>());
        absTrans->getColumn(1).setAbs( destTrans->getColumn<1>());
        absTrans->getColumn(2).setAbs( destTrans->getColumn<2>());
        absTrans->getColumn(3).setZero();

        hkVector4 diff; diff._setRotatedDir( destTrans->getRotation(), code->m_info.m_offset);
        destTrans->getColumn(3).add( diff );

        // multiply the plane offset by 2
        destTrans->getColumn(3).add( destTrans->getColumn<3>() );
        destTrans--;
        absTrans--;
    }
}


hkMoppPlanesQueryObject::hkpCheckCollisionResult hkMoppPlanesQueryObject::checkCollision( const hkAabb& aabb, const hkpMoppFindAllVirtualMachine::hkpMoppFindAllVirtualMachineQuery* query, const unsigned char* commands )
{
    int inBits = 0xf;

    const hkTransform* rotPlanes = m_rotatedPlanes;
    const hkTransform* absPlanes = m_absRotPlanes;

    hkVector4 center2; center2.setAdd( aabb.m_min, aabb.m_max);
    hkVector4 extents2; extents2.setSub( aabb.m_max, aabb.m_min );

    for ( int i = m_numTransforms-1; i>=0; i--)
    {
        hkVector4 absDiagDist;              absDiagDist._setRotatedDir( absPlanes->getRotation(), extents2 );
        hkVector4 centerDistToPlanes;       centerDistToPlanes._setTransformedPos( *rotPlanes, center2 );
        hkVector4 outDist; outDist.setSub( centerDistToPlanes, absDiagDist );
        hkVector4 inDist; inDist.setAdd( centerDistToPlanes, absDiagDist );

        int outBits = outDist.lessZero().getMask();
        if ( outBits != hkVector4ComparisonMask::MASK_XYZW )
        {
            return HK_NO_HIT;
        }
        inBits &= inDist.lessZero().getMask();

        rotPlanes++;
        absPlanes++;
    }


    if ( inBits == 0xf )
    {
        this->queryOnTree(query, commands );
        return HK_INCLUDED;
    }
    return HK_HIT;
}

hkMoppPlanesQueryObjectOptimized::hkpCheckCollisionResult hkMoppPlanesQueryObjectOptimized::checkCollision( const hkAabb& aabb, const hkpMoppFindAllVirtualMachine::hkpMoppFindAllVirtualMachineQuery* query, const unsigned char* commands )
{
    int inBits = 0xf;

    const hkTransform* rotPlanes = m_rotatedPlanes;
    const hkTransform* absPlanes = m_absRotPlanes;

    hkVector4 center2; center2.setAdd( aabb.m_min, aabb.m_max);
    hkVector4 extents2; extents2.setSub( aabb.m_max, aabb.m_min );

    for ( int i = m_numTransforms-1; i>=0; i--)
    {
        hkVector4 absDiagDist;              absDiagDist._setTransformedPos( *absPlanes, extents2 );
        hkVector4 centerDistToPlanes;       centerDistToPlanes._setTransformedPos( *rotPlanes, center2 );
        hkVector4 outDist; outDist.setSub( centerDistToPlanes, absDiagDist );
        hkVector4 inDist; inDist.setAdd( centerDistToPlanes, absDiagDist );

        int outBits = outDist.lessZero().getMask();
        if ( outBits != hkVector4ComparisonMask::MASK_XYZW )
        {
            return HK_NO_HIT;
        }
        inBits &=  inDist.lessZero().getMask();

        rotPlanes++;
        absPlanes++;
    }


    if ( inBits == 0xf )
    {
        this->queryOnTreeLeft( query, commands );
        this->queryOnTreeRight( query, commands );
        return HK_INCLUDED;
    }
    return HK_HIT;
}




int hkMoppEarlyExitObbVirtualMachine_queryObb(const hkpMoppCode* code, const hkTransform& BvToWorld, const hkVector4& extent, const float& radius)
{
    hkpMoppEarlyExitObbVirtualMachine machine;
    // this function can not return a hkBool due to its C linkage, instead it'll return an int {0|1}
    int retVal = machine.queryObb( code, BvToWorld, extent, radius);
    return retVal;
}


HK_COMPILE_TIME_ASSERT( sizeof(hkpMoppPrimitiveInfo) == sizeof( hkpShapeKey ) );
void hkMoppFindAllVirtualMachine_getAllKeys(   const hkpMoppCode* code, hkArray<hkpShapeKey>* primitives_out)
{
    hkpMoppFindAllVirtualMachine machine;
    machine.queryAll( code, reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(primitives_out) );
}

void hkMoppObbVirtualMachine_queryObb(const hkpMoppCode* code, const hkTransform& BvToWorld, const hkVector4& extent, const float radius, hkArray<hkpShapeKey>* primitives_out)
{
    hkpMoppObbVirtualMachine machine;
    machine.queryObb( code, BvToWorld, extent, radius, reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(primitives_out));
}

void hkMoppObbVirtualMachine_queryAabb(const hkpMoppCode* code, const hkAabb& aabb, hkArray<hkpShapeKey>* primitives_out)
{
    hkpMoppObbVirtualMachine machine;
    machine.queryAabb( code, aabb, reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(primitives_out));
}

void hkMoppSphereVirtualMachine_querySphere(const hkpMoppCode* code, const hkSphere &sphere, hkArray<hkpShapeKey>* primitives_out)
{
    hkpMoppSphereVirtualMachine machine;
    machine.querySphere( code, sphere, reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(primitives_out) );
}

void hkMoppUsingFloatAabbVirtualMachine_queryPlanes( const hkpMoppCode* code, const hkpMoppPlanesQueryInput &query, hkArray<hkpShapeKey>* partialHitsOut, hkArray<hkpShapeKey>* fullyIncludedHitsOut)
{
    typedef hkpMoppUsingFloatAabbVirtualMachine<hkpMoppPlanesQueryInput,hkMoppPlanesQueryObject> Machine;
    HK_ALIGN16( Machine machine );
    machine.queryMopp( code, query, reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(partialHitsOut), reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(fullyIncludedHitsOut));
}

void hkMoppUsingFloatAabbVirtualMachine_queryPlanesOptimized( const hkpMoppCode* code, const hkpMoppPlanesQueryInput &query, hkArray<hkpShapeKey>* partialHitsOut, hkArray<hkpShapeKey>* fullyIncludedHitsOut)
{
    typedef hkpMoppUsingFloatAabbVirtualMachine<hkpMoppPlanesQueryInput,hkMoppPlanesQueryObjectOptimized> hkOptimizedPlaneMachine;
    HK_ALIGN16( hkOptimizedPlaneMachine machine );
    machine.queryMopp( code, query, reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(partialHitsOut), reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(fullyIncludedHitsOut));
}

void hkMoppUsingFloatAabbVirtualMachine_querySphere( const hkpMoppCode* code, const hkSphere &query, hkArray<hkpShapeKey>* partialHitsOut, hkArray<hkpShapeKey>* fullyIncludedHitsOut)
{
    typedef hkpMoppUsingFloatAabbVirtualMachine<hkSphere,hkMoppSphereQueryObject> Machine;
    HK_ALIGN16( Machine machine );
    machine.queryMopp( code, query, reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(partialHitsOut), reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(fullyIncludedHitsOut));
}

void hkMoppUsingFloatAabbVirtualMachine_querySphereOptimized( const hkpMoppCode* code, const hkSphere &query, hkArray<hkpShapeKey>* partialHitsOut, hkArray<hkpShapeKey>* fullyIncludedHitsOut)
{
    typedef hkpMoppUsingFloatAabbVirtualMachine<hkSphere,hkMoppSphereQueryObjectOptimized> Machine;
    HK_ALIGN16( Machine machine );
    machine.queryMopp( code, query, reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(partialHitsOut), reinterpret_cast<hkArray<hkpMoppPrimitiveInfo>*>(fullyIncludedHitsOut));
}

void hkMoppModifyVirtualMachine_queryAabb(const hkpMoppCode* code, const hkAabb& aabb, hkpMoppModifier* modifierOut )
{
    hkpMoppModifyVirtualMachine machine;
    machine.queryAabb( code, aabb, modifierOut );
}

void hkMoppKDopGeometriesVirtualMachine_query( const hkpMoppCode* code, const hkpMoppKDopQuery &query, hkpMoppInfo* kDopGeometries )
{
    hkpMoppKDopGeometriesVirtualMachine machine;
    machine.queryMopp( code, query, kDopGeometries );
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
