// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// Virtual Machine command definitions
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachine.h>
#include <Physics2012/Collide/Shape/hkpShape.h>
#include <Physics2012/Collide/Shape/Query/hkpShapeRayCastInput.h>

#if defined(HK_PLATFORM_SPU)
#include <Common/Base/Spu/Dma/Manager/hkSpuDmaManager.h>
#include <Physics2012/Collide/Query/Multithreaded/Spu/hkpSpuConfig.h>
#endif

// Read detailed comment in the cpp class
class hkpMoppLongRayVirtualMachine : public hkpMoppVirtualMachine
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppLongRayVirtualMachine );

        inline hkpMoppLongRayVirtualMachine(){}
        inline ~hkpMoppLongRayVirtualMachine(){}

        // data driven query
        hkBool queryLongRay(const class HK_SHAPE_CONTAINER* collection, const hkpMoppCode* code, const hkpShapeRayCastInput& input, hkpShapeRayCastOutput& rayResult);

        // collector based raycast
        void queryLongRay(const class HK_SHAPE_CONTAINER* collection, const hkpMoppCode* code, const hkpShapeRayCastInput& input, const hkpCdBody& body, hkpRayHitCollector& collector);

    ////////////////////////////////////////////////////////////////
    //
    // THE REMAINDER OF THIS FILE IS FOR INTERNAL USE
    //
    ////////////////////////////////////////////////////////////////

    protected:

        //we will use the information here to go from int to float space
        const hkpMoppCode*          m_code;
        float                       m_ItoFScale;

        //used for ray intersection test
        //the original ray (must be in primitive space)
        hkpShapeRayCastInput m_ray;

        //whether a hkReal hit has been discovered already
        bool                    m_hitFound;
        hkReal                  m_earlyOutHitFraction;

        // either one of those is set

        // for data driven
        hkpShapeRayCastOutput*      m_rayResultPtr;

        // for callback driven
        hkpRayHitCollector*         m_collector;
        const hkpCdBody*            m_body;

        const HK_SHAPE_CONTAINER*   m_collection;

        // If set (-1) this mask ensures that the chunkId is stored in the shape key
        int                         m_reindexingMask;

#if defined(HK_PLATFORM_SPU)
        const hkUint8*          m_originalBaseAddress;
#endif

    protected:

        struct QueryInt;
        struct QueryFloat;

        void queryRayOnTree ( const QueryInt* query, const unsigned char* commands, QueryFloat* const fQuery, int chunkOffset);

            // only add a hit if it definitely is a hit
#ifndef HK_ARCH_ARM
        HK_INLINE
#endif
        void addHit(unsigned int id, const unsigned int properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES]);

        HK_INLINE void queryLongRaySub(const hkpMoppCode* code,   const hkpShapeRayCastInput& input );
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
