// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppObbVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppEarlyExitObbVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkp26Dop.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppMachine.h>

struct hkpMoppInfo;

class hkpMoppKDopGeometriesVirtualMachine : public hkpMoppVirtualMachine
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppKDopGeometriesVirtualMachine );

    struct hkpMoppKDopGeometriesVirtualMachineQuery
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppKDopGeometriesVirtualMachine::hkpMoppKDopGeometriesVirtualMachineQuery );

        //the offset of the all previous scales are accumulated here. Do not change order.
        int m_offset_x;
        int m_offset_y;
        int m_offset_z;
        //the shifts from all previous scale commands are accumulated here
        int m_shift;

        // the current offset for the primitives
        unsigned int m_primitiveOffset;

        // props
        unsigned int m_properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES];
    };

public:

    // standard constructor
    hkpMoppKDopGeometriesVirtualMachine();
    // standard destructor
    ~hkpMoppKDopGeometriesVirtualMachine();

    void queryMopp( const hkpMoppCode* code, const hkpMoppKDopQuery &queryInput, hkpMoppInfo* kDopGeometries );

protected:

    hkReal      m_ItoFScale;    // int to float space scale
    hkVector4   m_offset;

    unsigned int m_terminaloffset;
    hkArray<unsigned int> m_visitedTerminals;

    hkpMoppInfo* m_kDopGeometries;

    hkp26Dop        m_kdop;
    int         m_level;
    hkpMoppKDopQuery m_queryObject;

    hkBool m_hitFound, m_earlyExit;

    void queryMoppKDopGeometriesRecurse( const hkpMoppKDopGeometriesVirtualMachineQuery* query, const unsigned char* PC);

    void addHit( unsigned int id, const unsigned int properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES] );

    void pushKDop( hkBool isTerminal = false, hkpShapeKey id = hkpShapeKey(-1) );
    void popKDop();
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
