// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppKDopGeometriesVirtualMachine.h>


#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>

// For calculating the display geometries
//#include <hkmath/basetypes/hkSphere.h>


//
//*****

#define ROOT2 1.4142136f
#define ROOT3 1.7320508f

#define GETOFFSETSPLIT2( OFF, NEG, I2F )                    \
    offseth = float( (((PC1 << 1) - (255 * NEG)) << (0x10 - query->m_shift)) + OFF);    \
    offsetl = float( (((PC2 << 1) - (255 * NEG)) << (0x10 - query->m_shift)) + OFF);    \
    offseth *= float(I2F);                                                              \
    offsetl *= float(I2F);

#define GETOFFSETSPLIT3( OFF, NEG, I2F )        \
    offseth = float( (((PC1 * 3) - (255 * NEG)) << (0x10 - query->m_shift)) + OFF); \
    offsetl = float( (((PC2 * 3) - (255 * NEG)) << (0x10 - query->m_shift)) + OFF); \
    offseth *= float(I2F);                                                              \
    offsetl *= float(I2F);

// For the update of the A tree query
#define STOREOFFSETA( AXIS )        \
    m_vLowAinB.setMul4( offsetl, m_transformedAxisA[AXIS] );  \
    m_vHighAinB.setMul4( offseth, m_transformedAxisA[AXIS] ); \
    m_vLowAinB.add4( m_moppA2B.getTranslation() );  \
    m_vHighAinB.add4( m_moppA2B.getTranslation() );  \
    m_iAxisA = (int)(AXIS);

#define UPDATEPCSPLIT() \
    offsetLB = 0;           \
    offsetRB = PC3;         \
    PC += 4;


static inline bool isMoppTerminal(const hkpMoppCommands& c)
{
    return ( (c >= HK_MOPP_TERM4_0) && (c < HK_MOPP_NTERM32) );
}



hkpMoppKDopGeometriesVirtualMachine::hkpMoppKDopGeometriesVirtualMachine()
{
}

//
// hkpMoppKDopGeometriesVirtualMachine Destructor
//
hkpMoppKDopGeometriesVirtualMachine::~hkpMoppKDopGeometriesVirtualMachine()
{
    // nothing to do
}


//
// Dop 'cut'
//
static inline void doubleCut( hkp26Dop& dop, hkp26Dop::DOP_AXIS axis, float newL, float newH, float& oldL, float& oldH)
{
    // This is not quite fitting the kdop to the new extents as we are not resizing the other
    // possibly affected dop extents.. but it is very fast :)
    // Can change of the dops stay too big.
    oldL = float(dop.getLow(axis));
    oldH = float(dop.getHigh(axis));
    dop.setLow( axis, newL );
    dop.setHigh( axis, newH );
}

//
// Dop 'split' low
//
static inline float shiftDopLow( hkp26Dop& dop, hkp26Dop::DOP_AXIS axis, float newOffsetLow)
{
    // This is not quite fitting the kdop to the new extents as we are not resizing the other
    // possibly affected dop extents.. but it is very fast :)
    // Can change of the dops stay too big.
    float l = float(dop.getLow(axis));
    dop.setLow( axis, newOffsetLow );
    return l;
}

//
// Dop 'split' high
//
static inline float shiftDopHigh( hkp26Dop& dop, hkp26Dop::DOP_AXIS axis, float newOffsetHigh)
{
    // This is not quite fitting the kdop to the new extents as we are not resizing the other
    // possibly affected dop extents.. but it is very fast :)
    // Can change of the dops stay too big.
    float h = float(dop.getHigh(axis));
    dop.setHigh( axis, newOffsetHigh );
    return h;
}

//
// query - for MOPP-MOPP
//
void hkpMoppKDopGeometriesVirtualMachine::queryMopp( const hkpMoppCode* code, const hkpMoppKDopQuery &queryInput, hkpMoppInfo* kDopGeometries )
{
    m_kDopGeometries = kDopGeometries;

    hkpMoppKDopGeometriesVirtualMachineQuery query;

    m_ItoFScale = 1.0f / (code->m_info.getScale());

    m_offset = code->m_info.m_offset;
    m_hitFound = false;
    m_queryObject = queryInput;

    // Integer query setup:
    query.m_offset_x = 0;
    query.m_offset_y = 0;
    query.m_offset_z = 0;
    query.m_shift = 0;

    // Any re-offsetting will occur in the tree
    query.m_primitiveOffset = 0;

    // state var
    m_terminaloffset = 0xffffffff;

    // the colour level
    m_level = 0;

    // setup the starting dop for B to be the full possible extents of the B MOPP
    float worldSize = float( (unsigned int)( 0x01000000 ) * m_ItoFScale );

    for (int i=0; i < 13; ++i)
    {
        if (i < 3)
        {
            m_kdop.setLow(i, -worldSize*2);
            m_kdop.setHigh(i, worldSize*2);
        }
        else if ( i < 9 )
        {
            m_kdop.setLow(i, -worldSize*2 * hkReal(1.4142135623730950488016887242097f)); // sqrt(2)
            m_kdop.setHigh(i, worldSize*2 * hkReal(1.4142135623730950488016887242097f)); // sqrt(2)
        }
        else
        {
            m_kdop.setLow(i, -worldSize*2 * hkReal(1.7320508075688772935274463415059f)); // sqrt(3)
            m_kdop.setHigh(i, worldSize*2 * hkReal(1.7320508075688772935274463415059f)); // sqrt(3)
        }
        // the max fixed point integer is of the form 0x00ff0000
    }


    // Program counter:
    const unsigned char* PC = reinterpret_cast<const unsigned char*>( &code->m_data[0] );

    for(int p = 0; p < int( hkpMoppCode::MAX_PRIMITIVE_PROPERTIES ); p++)
    {
        query.m_properties[p] = 0;
    }

    queryMoppKDopGeometriesRecurse( &query, PC );

    //hkcout << m_kDopGeometries - kDopGeometries << '\n';
}

void hkpMoppKDopGeometriesVirtualMachine::addHit( unsigned int id, const unsigned int properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES] )
{
    if ( m_visitedTerminals.indexOf(id) == -1 )
    {
        // only push this kdop if the ID matches the ID in the query
        hkBool specifiedIdFound = ( m_queryObject.m_useSpecifiedID && (id == m_queryObject.m_specifiedId ));
        if ((! m_queryObject.m_useSpecifiedID ) || ( specifiedIdFound ))
        {
            pushKDop( true, id );

            m_queryObject.m_earlyExit = ( m_queryObject.m_earlyExit || specifiedIdFound );
        }
        m_visitedTerminals.pushBack(id);
    }

    if ( m_queryObject.m_earlyExit )
    {
        m_hitFound = true;
    }
}


void hkpMoppKDopGeometriesVirtualMachine::pushKDop( hkBool isTerminal, hkpShapeKey id )
{
    //hkcout << m_kDopGeometries->getSize() << " ";

    // save the current hk26dop to the list of m_kDopGeometries
    hkpMoppInfo* savedKDop = m_kDopGeometries;
    savedKDop->m_isTerminal = isTerminal;

    if ( savedKDop->m_isTerminal )
    {
        savedKDop->m_shapeKey = id;
    }
    savedKDop->m_level = char(m_level);

    savedKDop->m_dop = m_kdop;

    m_kDopGeometries++;
}


inline void hkpMoppKDopGeometriesVirtualMachine::popKDop()
{
    m_kDopGeometries--;
}


// jjp 2006-05-24: never inline this method as it will cause cw to go into an
// infinite recursion that will consume all available memory.
void hkpMoppKDopGeometriesVirtualMachine::queryMoppKDopGeometriesRecurse( const hkpMoppKDopGeometriesVirtualMachineQuery* query, const unsigned char* PC )
{
    hkpMoppKDopGeometriesVirtualMachineQuery scaledQuery; // for fast scale commands

    while (1)
    {

        HK_MOPP_LOAD_PC();

        if( m_hitFound )
        {
            return;
        }


        float offseth;
        float offsetl;

        int tdir=999;
        int offsetRB;
        int offsetLB;
        hkp26Dop::DOP_AXIS queryAxis;

        switch (command)
        {
        case HK_MOPP_SPLIT_YZ:      GETOFFSETSPLIT2( (query->m_offset_y + query->m_offset_z), 0, m_ItoFScale);
            queryAxis = hkp26Dop::AXIS_YZ;
            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SPLIT_YMZ:     GETOFFSETSPLIT2( (query->m_offset_y - query->m_offset_z), 1, m_ItoFScale);
            queryAxis = hkp26Dop::AXIS_YMZ;
            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SPLIT_XZ:      GETOFFSETSPLIT2( (query->m_offset_x + query->m_offset_z), 0, m_ItoFScale);
            queryAxis = hkp26Dop::AXIS_XZ;
            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SPLIT_XMZ:     GETOFFSETSPLIT2( (query->m_offset_x - query->m_offset_z), 1, m_ItoFScale);
            queryAxis = hkp26Dop::AXIS_XMZ;
            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SPLIT_XY:      GETOFFSETSPLIT2( (query->m_offset_x + query->m_offset_y), 0, m_ItoFScale);
            queryAxis = hkp26Dop::AXIS_XY;
            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SPLIT_XMY:     GETOFFSETSPLIT2( (query->m_offset_x - query->m_offset_y), 1, m_ItoFScale);
            queryAxis = hkp26Dop::AXIS_XMY;
            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SPLIT_XYZ:     GETOFFSETSPLIT3( (query->m_offset_x + query->m_offset_y + query->m_offset_z), 0, m_ItoFScale);
            queryAxis = hkp26Dop::AXIS_XYZ;
            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SPLIT_XYMZ:    GETOFFSETSPLIT3( (query->m_offset_x + query->m_offset_y - query->m_offset_z), 1, m_ItoFScale);
            queryAxis = hkp26Dop::AXIS_XYMZ;
            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SPLIT_XMYZ:    GETOFFSETSPLIT3( (query->m_offset_x - query->m_offset_y + query->m_offset_z), 1, m_ItoFScale);
            queryAxis = hkp26Dop::AXIS_XMYZ;
            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SPLIT_XMYMZ:   GETOFFSETSPLIT3( (query->m_offset_x - query->m_offset_y - query->m_offset_z), 2, m_ItoFScale);
            queryAxis = hkp26Dop::AXIS_XMYMZ;
            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:

            tdir = command - HK_MOPP_SPLIT_X;

            offseth = float( ( (PC1 << (0x10 - query->m_shift)) + (&query->m_offset_x)[tdir]) * m_ItoFScale );
            offsetl = float( ( (PC2 << (0x10 - query->m_shift)) + (&query->m_offset_x)[tdir]) * m_ItoFScale );

            queryAxis = hkp26Dop::DOP_AXIS( tdir );

            UPDATEPCSPLIT();
            goto do_compare;

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:

            tdir = command - HK_MOPP_SINGLE_SPLIT_X;

            offsetl = (float) ( (PC1 << (0x10 - query->m_shift)) + (&query->m_offset_x)[tdir]);
            offseth = offsetl + float( 1 << (0x10 - query->m_shift) );

            offsetl *= float(m_ItoFScale);
            offseth *= float(m_ItoFScale);

            queryAxis = hkp26Dop::DOP_AXIS( tdir );


            offsetLB = 0;
            offsetRB = PC2;
            PC += 3;

            goto do_compare;

        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:

            tdir = command - HK_MOPP_SPLIT_JUMP_X;

            offseth = float( ( (PC1 << (0x10 - query->m_shift)) + (&query->m_offset_x)[tdir]) * m_ItoFScale );
            offsetl = float( ( (PC2 << (0x10 - query->m_shift)) + (&query->m_offset_x)[tdir]) * m_ItoFScale );

            queryAxis = hkp26Dop::DOP_AXIS( tdir );

            offsetLB = (PC3 << 8) + (PC4);
            offsetRB = (PC5 << 8) + (PC6);
            PC += 7;

            //goto do_compare;
do_compare:

            {
                // We want to traverse every part of the MOPP.

                float ls = shiftDopHigh( m_kdop, queryAxis, offseth );
                HK_ASSERT_NO_MSG(0x51a79a3b, m_kdop.getHigh( queryAxis ) > m_kdop.getLow( queryAxis ) );

                // 'Recurse' left
                PC += offsetLB;

                queryMoppKDopGeometriesRecurse( query, PC );

                shiftDopHigh( m_kdop, queryAxis, ls ); // back to previous state
                ls = shiftDopLow( m_kdop, queryAxis, offsetl ); // to recurse Right state
                HK_ASSERT_NO_MSG(0x7410e967, m_kdop.getHigh( queryAxis ) > m_kdop.getLow( queryAxis ) );

                PC -= offsetLB - offsetRB;
                queryMoppKDopGeometriesRecurse( query, PC );

                // restore our dop and exit.
                shiftDopLow( m_kdop, queryAxis, ls ); // back to previous state
                HK_ASSERT_NO_MSG(0x7aaae93e, m_kdop.getHigh( queryAxis ) > m_kdop.getLow( queryAxis ) );

                goto end_of_function;
                //continue;
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            {
                tdir = command - HK_MOPP_DOUBLE_CUT_X;

                offsetl = float( (((PC1 << (0x10 - query->m_shift)) + (&query->m_offset_x)[tdir])) * m_ItoFScale );
                offseth = float( (((PC2 << (0x10 - query->m_shift)) + (&query->m_offset_x)[tdir])) * m_ItoFScale );

                // Cut is a unary command. It resizes the kdop to offsetl->offseth along the given axis.
                // thus we resize the dop and always continue.

                float preCutL, preCutH;
                queryAxis = hkp26Dop::DOP_AXIS( tdir );

                // The colorLevel maintains the depth we are currently at.
                // If the depth to display is specified in the query object, then use
                // that. (The special values of the kdopDepth are -1 to just display nodes, 0 to display all)

                hkBool displayThisKDop = ( m_queryObject.m_kdopDepth == 0 ) || ( m_level < m_queryObject.m_kdopDepth );
                if ( displayThisKDop )
                {
                    pushKDop();
                }

                doubleCut( m_kdop, queryAxis, offsetl, offseth, preCutL, preCutH );
                HK_ASSERT_NO_MSG(0x870919c, m_kdop.getHigh( queryAxis ) > m_kdop.getLow( queryAxis ) );

                // recurse (just to save state, optimize later to enable non recursion (continue) )
                PC += 3;

                m_level++;
                queryMoppKDopGeometriesRecurse( query, PC );
                m_level--;

                if ( displayThisKDop && m_queryObject.m_useSpecifiedID && !m_hitFound )
                {
                    popKDop();
                }

                // restore our dop and exit.
                doubleCut( m_kdop, queryAxis, preCutL, preCutH, offsetl, offseth );
                HK_ASSERT_NO_MSG(0x35dc532b, m_kdop.getHigh( queryAxis ) > m_kdop.getLow( queryAxis ) );

                goto end_of_function;
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            {
                tdir = command - HK_MOPP_DOUBLE_CUT24_X;

                offsetl = float( ((PC1<<16) + (PC2<<8) + PC3) * m_ItoFScale );
                offseth = float( ((PC4<<16) + (PC5<<8) + PC6) * m_ItoFScale );

                float preCutL, preCutH;
                queryAxis = hkp26Dop::DOP_AXIS( tdir );

                hkBool displayThisKDop = ( m_queryObject.m_kdopDepth == 0 ) || ( m_level < m_queryObject.m_kdopDepth );
                if ( displayThisKDop )
                {
                    pushKDop();
                }

                doubleCut( m_kdop, queryAxis, offsetl, offseth, preCutL, preCutH );
                HK_ASSERT_NO_MSG(0x6930a37a, m_kdop.getHigh( queryAxis ) > m_kdop.getLow( queryAxis ) );

                // recurse (just to save state, optimize later to enable non recursion (continue) )
                PC += 7;

                m_level++;
                queryMoppKDopGeometriesRecurse( query, PC );
                m_level--;

                if ( displayThisKDop && m_queryObject.m_useSpecifiedID )
                {
                    popKDop();
                }

                doubleCut( m_kdop, queryAxis, preCutL, preCutH, offsetl, offseth );
                HK_ASSERT_NO_MSG(0x188e5d6b, m_kdop.getHigh( queryAxis ) > m_kdop.getLow( queryAxis ) );

                goto end_of_function;
            }

        case HK_MOPP_JUMP8:
            {
                offsetLB = PC1;
                PC += 2;
                PC += offsetLB;
                continue;
            }
        case HK_MOPP_JUMP16:
            {
                offsetRB  = PC1;
                offsetLB  = PC2;
                PC += 3;
                PC += (offsetRB << 8) + offsetLB;
                continue;
            }
        case HK_MOPP_JUMP24:
            {
                offsetRB = PC1;
                const unsigned int offsetm = PC2;
                offsetLB = PC3;
                PC += 4;
                PC += (offsetRB << 16) + (offsetm << 8) + offsetLB;
                continue;
            }

        case HK_MOPP_SCALE0: //this is a dummy
        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                //
                // Query Scale does not affect our kdop as it is float (root) space.
                //

                const unsigned int shift = command - HK_MOPP_SCALE0;

                //accumulate the offset in root node space
                scaledQuery.m_offset_x = (PC1 << (0x10 - query->m_shift)) + query->m_offset_x;
                scaledQuery.m_offset_y = (PC2 << (0x10 - query->m_shift)) + query->m_offset_y;
                scaledQuery.m_offset_z = (PC3 << (0x10 - query->m_shift)) + query->m_offset_z;

                //the shift has been accumulating
                scaledQuery.m_shift = query->m_shift + shift;

                //no need to copy anything except for the primitive toffset and the properties
                for(int p = 0; p < 1;p++)
                {
                    scaledQuery.m_properties[p] = query->m_properties[p];
                }

                scaledQuery.m_primitiveOffset = query->m_primitiveOffset;
                //no need to copy anything except for the primitive toffset
                query = &scaledQuery;

                PC += 4;
                continue;
            }

            HK_MOPP_REOFFSET_MACRO

                //  HK_MOPP_TERMINAL_MACRO --> Can't use this as it references 'offsetl' etc which are now floats, not ints
        case HK_MOPP_TERM8:
            {
                m_terminaloffset = PC1;
                goto add_Terminal;
            }
        case HK_MOPP_TERM16:
            {
                tdir = PC1;
                tdir <<=8;
                m_terminaloffset = PC2;
                m_terminaloffset += tdir;
                goto add_Terminal;
            }
        case HK_MOPP_TERM24:
            {
                tdir = PC1;
                tdir <<=16;
                m_terminaloffset = PC2;
                m_terminaloffset <<=8;
                m_terminaloffset += PC3;
                m_terminaloffset += tdir;
                goto add_Terminal;
            }
        case HK_MOPP_TERM4_0:
        case HK_MOPP_TERM4_1:
        case HK_MOPP_TERM4_2:
        case HK_MOPP_TERM4_3:
        case HK_MOPP_TERM4_4:
        case HK_MOPP_TERM4_5:
        case HK_MOPP_TERM4_6:
        case HK_MOPP_TERM4_7:
        case HK_MOPP_TERM4_8:
        case HK_MOPP_TERM4_9:
        case HK_MOPP_TERM4_A:
        case HK_MOPP_TERM4_B:
        case HK_MOPP_TERM4_C:
        case HK_MOPP_TERM4_D:
        case HK_MOPP_TERM4_E:
        case HK_MOPP_TERM4_F:
        case HK_MOPP_TERM4_10:
        case HK_MOPP_TERM4_11:
        case HK_MOPP_TERM4_12:
        case HK_MOPP_TERM4_13:
        case HK_MOPP_TERM4_14:
        case HK_MOPP_TERM4_15:
        case HK_MOPP_TERM4_16:
        case HK_MOPP_TERM4_17:
        case HK_MOPP_TERM4_18:
        case HK_MOPP_TERM4_19:
        case HK_MOPP_TERM4_1A:
        case HK_MOPP_TERM4_1B:
        case HK_MOPP_TERM4_1C:
        case HK_MOPP_TERM4_1D:
        case HK_MOPP_TERM4_1E:
        case HK_MOPP_TERM4_1F:

            m_terminaloffset = command - HK_MOPP_TERM4_0;

            {
add_Terminal:
                m_terminaloffset += query->m_primitiveOffset;

                // if we are at a leaf in both A and B, add the hit and continue
                // otherwise we need to to recurse further on B

                addHit( m_terminaloffset, query->m_properties);

                m_terminaloffset = 0xffffffff;

                goto end_of_function;
            }

            HK_MOPP_PROPERTY_MACRO

            HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:

    return;
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
