// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

// MOPP Virtual Machine implementation

// include all default MOPP headers
#include <Physics2012/Collide/hkpCollide.h>

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppIntAabbVirtualMachine.h>


//#define HK_PRINTF(a) hkprintf a
#define HK_PRINTF(a)

#define SPLIT2( POSL, POSH, NEG )                                   \
{                                                                   \
            offseth = int(PC1)<<1;                              \
            offsetl = int(PC2)<<1;                              \
            offseth -= (255 * NEG);                                 \
            offsetl -= (255 * NEG);                                 \
            positionl = POSL;                                       \
            positionh = POSH;                                       \
            goto do_compare;                                        \
}

#define SPLIT3( POSL, POSH, NEG )                                   \
{                                                                   \
            offseth = (int(PC1)<<1)+int(PC1);                   \
            offsetl = (int(PC2)<<1)+int(PC2);                   \
            offseth -= (255 * NEG);                                 \
            offsetl -= (255 * NEG);                                 \
            positionl = POSL;                                       \
            positionh = POSH;                                       \
            goto do_compare;                                        \
}



void hkpMoppIntAabbVirtualMachine::queryAabbOnTree(const hkpMoppIntAabbVirtualMachineQuery* query, const unsigned char* PC)
{
    // for fast scale commands
    hkpMoppIntAabbVirtualMachineQuery scaledQuery;
    while (1)
    {
        HK_MOPP_LOAD_PC();

        int positionh;
        int positionl;

        //these need to be changed later
        int offseth;
        int offsetl;
        HK_PRINTF(("PC: %5i: ", PC));
        switch (command)
        {
#define RS(I) ((&query->m_xLo)[I])
#define RE(I) ((&query->m_xHi)[I])
        case HK_MOPP_SPLIT_YZ:      SPLIT2( (RS(1) + RS(2)),    (RE(1) + RE(2)), 0 );
        case HK_MOPP_SPLIT_YMZ:     SPLIT2( (RS(1) - RE(2)),    (RE(1) - RS(2)), 1 );
        case HK_MOPP_SPLIT_XZ:      SPLIT2( (RS(0) + RS(2)),    (RE(0) + RE(2)), 0 );
        case HK_MOPP_SPLIT_XMZ:     SPLIT2( (RS(0) - RE(2)),    (RE(0) - RS(2)), 1 );
        case HK_MOPP_SPLIT_XY:      SPLIT2( (RS(0) + RS(1)),    (RE(0) + RE(1)), 0 );
        case HK_MOPP_SPLIT_XMY:     SPLIT2( (RS(0) - RE(1)),    (RE(0) - RS(1)), 1 );

        case HK_MOPP_SPLIT_XYZ:     SPLIT3( (RS(0) + RS(1) + RS(2)),    (RE(0) + RE(1) + RE(2)), 0);
        case HK_MOPP_SPLIT_XYMZ:    SPLIT3( (RS(0) + RS(1) - RE(2)),    (RE(0) + RE(1) - RS(2)), 1);
        case HK_MOPP_SPLIT_XMYZ:    SPLIT3( (RS(0) - RE(1) + RS(2)),    (RE(0) - RS(1) + RE(2)), 1);
        case HK_MOPP_SPLIT_XMYMZ:   SPLIT3( (RS(0) - RE(1) - RE(2)),    (RE(0) - RS(1) - RS(2)), 2);
#undef RS
#undef RE

do_compare:
            {
                const unsigned int offsetRB = PC3;
                PC += 4;

                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    if ( positionl < offseth )
                    {
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                        continue;
                    }
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }

                // now we have to check for traversing the right
                if ( positionl >= offseth )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    PC += offsetRB;
                    continue;
                }
                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryAabbOnTree( query, PC );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    PC += offsetRB;
                    continue;
                }
            }

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            offseth = PC1;
            offsetl = PC2;
            positionl = (&query->m_xLo)[command - HK_MOPP_SPLIT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SPLIT_X];
            {
                //move to the left branch
                const unsigned int offsetRB = PC3;
                PC += 4;
                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    if ( positionl < offseth )
                    {
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                        continue;
                    }
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }

                PC += offsetRB;

                // now we have to check for traversing the right
                if ( positionl >= offseth )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryAabbOnTree( query, PC - (offsetRB));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            offsetl = PC1;
            positionl = (&query->m_xLo)[command - HK_MOPP_SINGLE_SPLIT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SINGLE_SPLIT_X];
            {
                //move to the left branch
                const unsigned int offsetRB = PC2;
                PC += 3;
                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    continue;
                }
                PC += offsetRB;

                // now we have to check for traversing the right
                if ( positionl > offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryAabbOnTree( query, PC - (offsetRB));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }


        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            offseth = PC1;
            offsetl = PC2;

            positionl = (&query->m_xLo)[command - HK_MOPP_SPLIT_JUMP_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SPLIT_JUMP_X];
            {
                const unsigned int leftJump = (PC3 << 8) + (PC4);
                const unsigned int rightJump = (PC5 << 8) + (PC6);
                PC += 7;

                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    if ( positionl < offseth )
                    {
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                        PC += leftJump;
                        continue;
                    }
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }

                PC += rightJump;

                // now we have to check for traversing the right
                if ( positionl >= offseth )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the OBB is either on one (or both of the planes) or it is in between
                {
                    //put in the node splitting code here

                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryAabbOnTree( query, PC - rightJump + leftJump);
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            positionl = (&query->m_xLo)[command - HK_MOPP_DOUBLE_CUT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_DOUBLE_CUT_X];
            {
                offsetl = PC1;
                offseth = PC2;

                if( (positionh < offsetl) || (positionl >= offseth) )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }
                else
                {
                    PC += 3;
                    continue;
                }
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            positionl = (&this->m_xLo)[command - HK_MOPP_DOUBLE_CUT24_X];
            positionh = (&this->m_xHi)[command - HK_MOPP_DOUBLE_CUT24_X];
            {
                offsetl = ((PC1<<16) + (PC2<<8) + PC3);
                offseth = ((PC4<<16) + (PC5<<8) + PC6);

                if( (positionh >= offsetl) && (positionl <= offseth) )
                {
                    PC += 7;
                    continue;
                }
                else
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }
            }

        HK_MOPP_JUMP_MACRO

        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                const unsigned int shift = command - HK_MOPP_SCALE0;

                //the shift has been accumulating, and will be stored in child space
                //the offset

                scaledQuery.m_offset_x = (PC1 + query->m_offset_x) << shift;
                scaledQuery.m_offset_y = (PC2 + query->m_offset_y) << shift;
                scaledQuery.m_offset_z = (PC3 + query->m_offset_z) << shift;

                scaledQuery.m_shift = query->m_shift + shift;
                const int rShift = 0x10 - scaledQuery.m_shift;

                scaledQuery.m_xLo = ((int)m_xLo) >> (rShift);
                //now subtract the offset in the child space (hence the offset shifting above)
                scaledQuery.m_xLo -= scaledQuery.m_offset_x;

                scaledQuery.m_yLo = ((int)m_yLo) >> (rShift);
                scaledQuery.m_yLo -= scaledQuery.m_offset_y;

                scaledQuery.m_zLo = ((int)m_zLo) >> (rShift);
                scaledQuery.m_zLo -= scaledQuery.m_offset_z;

                scaledQuery.m_xHi = ((int)m_xHi) >> (rShift);
                scaledQuery.m_xHi += 1;
                scaledQuery.m_xHi -= scaledQuery.m_offset_x;

                scaledQuery.m_yHi = ((int)m_yHi) >> (rShift);
                scaledQuery.m_yHi += 1;
                scaledQuery.m_yHi -= scaledQuery.m_offset_y;

                scaledQuery.m_zHi = ((int)m_zHi) >> (rShift);
                scaledQuery.m_zHi += 1;
                scaledQuery.m_zHi -= scaledQuery.m_offset_z;

                //no need to copy anything except for the primitive offset and the properties
                for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
                {
                    scaledQuery.m_properties[p] = query->m_properties[p];
                }

                scaledQuery.m_primitiveOffset = query->m_primitiveOffset;
                query = &scaledQuery;

                PC += 4;
                continue;
            }
        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:
    return;
}



//
// query - for an AABB with an extra radius
//
void hkpMoppIntAabbVirtualMachine::queryAabb(const hkpMoppCode* code, const hkInt32* aabb, hkArray<hkpMoppPrimitiveInfo>* primitives_out)
{
    //HK_INTERNAL_TIMER_BEGIN_LIST("mopp", "setup" );
    m_code = code;

    this->initQuery( primitives_out );

    HK_ALIGN16( hkpMoppIntAabbVirtualMachineQuery query );

    m_xLo = aabb[0];
    m_xHi = aabb[1];
    m_yLo = aabb[2];
    m_yHi = aabb[3];
    m_zLo = aabb[4];
    m_zHi = aabb[5];

    query.m_xLo = (m_xLo >> 16);
    query.m_xHi = (m_xHi >> 16) + 1;
    query.m_yLo = (m_yLo >> 16);
    query.m_yHi = (m_yHi >> 16) + 1;
    query.m_zLo = (m_zLo >> 16);
    query.m_zHi = (m_zHi >> 16) + 1;

    query.m_offset_x = 0;
    query.m_offset_y = 0;
    query.m_offset_z = 0;

    //any re-offsetting will occur in the tree
    query.m_primitiveOffset = 0;
    query.m_shift = 0;

    query.m_properties[0] = 0;

    //call the query with the left-of-decimal place part
    const unsigned char* programCounter = &m_code->m_data[0];
    //HK_INTERNAL_TIMER_SPLIT_LIST("query");
    queryAabbOnTree( &query, programCounter);
    //HK_INTERNAL_TIMER_END_LIST();

//  for ( int i = 0; i < primitives_out->getSize(); i++)
//  {
//      hkprintf("%i,", (*primitives_out)[i]);
//  }
//  hkprintf("\n");
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
