// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
//



#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Splitter/hkpMoppSplitTypes.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Mediator/hkpMoppMediator.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppFindAllVirtualMachine.h>



void hkpMoppFindAllVirtualMachine::queryOnTree( const hkpMoppFindAllVirtualMachineQuery* query, const unsigned char *PC )
{
    hkpMoppFindAllVirtualMachineQuery scaledQuery; // for fast scale commands

    int offsetl;
    int offseth;

    while (1){
        HK_MOPP_LOAD_PC();

        switch (command) {
        case HK_MOPP_SPLIT_YZ:
        case HK_MOPP_SPLIT_YMZ:
        case HK_MOPP_SPLIT_XZ:
        case HK_MOPP_SPLIT_XMZ:
        case HK_MOPP_SPLIT_XY:
        case HK_MOPP_SPLIT_XMY:

        case HK_MOPP_SPLIT_XYZ:
        case HK_MOPP_SPLIT_XYMZ:
        case HK_MOPP_SPLIT_XMYZ:
        case HK_MOPP_SPLIT_XMYMZ:

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            {
                const unsigned int offsetRB = PC3;
                PC += 4;
                queryOnTree( query, PC );
                PC += offsetRB;
                continue;
            }

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            {
                const unsigned int offsetRB = PC2;
                PC += 3;                        //move to the left branch
                queryOnTree( query, PC );
                PC += offsetRB;
                continue;
            }

        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            {
                const unsigned int leftJump = (PC3 << 8) + (PC4);
                const unsigned int rightJump = (PC5 << 8) + (PC6);
                PC += 7;
                queryOnTree( query, PC + leftJump );
                PC += rightJump;
                continue;
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            {
                PC += 3;
                continue;
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            {
                PC += 7;
                continue;
            }

        HK_MOPP_JUMP_MACRO


        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                PC += 4;
                continue;
            }

        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:

    return;
}



void hkpMoppFindAllVirtualMachine::queryOnTreeRight( const hkpMoppFindAllVirtualMachineQuery* query, const unsigned char *PC )
{
    hkpMoppFindAllVirtualMachineQuery scaledQuery; // for fast scale commands

    int offsetl;
    int offseth;

    while (1){
        HK_MOPP_LOAD_PC();

        switch (command) {
        case HK_MOPP_SPLIT_YZ:
        case HK_MOPP_SPLIT_YMZ:
        case HK_MOPP_SPLIT_XZ:
        case HK_MOPP_SPLIT_XMZ:
        case HK_MOPP_SPLIT_XY:
        case HK_MOPP_SPLIT_XMY:

        case HK_MOPP_SPLIT_XYZ:
        case HK_MOPP_SPLIT_XYMZ:
        case HK_MOPP_SPLIT_XMYZ:
        case HK_MOPP_SPLIT_XMYMZ:

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            {
                const unsigned int offsetRB = PC3;
                PC += 4;
                PC += offsetRB;
                continue;
            }

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            {
                const unsigned int offsetRB = PC2;
                PC += 3;                        //move to the left branch
                PC += offsetRB;
                continue;
            }

        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            {
                const unsigned int rightJump = (PC5 << 8) + (PC6);
                PC += 7;
                PC += rightJump;
                continue;
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            {
                PC += 3;
                continue;
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            {
                PC += 7;
                continue;
            }

        HK_MOPP_JUMP_MACRO


        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                PC += 4;
                continue;
            }

        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:

    return;
}



void hkpMoppFindAllVirtualMachine::queryOnTreeLeft( const hkpMoppFindAllVirtualMachineQuery* query, const unsigned char *PC )
{
    hkpMoppFindAllVirtualMachineQuery scaledQuery; // for fast scale commands

    int offsetl;
    int offseth;

    while (1){
        HK_MOPP_LOAD_PC();

        switch (command) {
        case HK_MOPP_SPLIT_YZ:
        case HK_MOPP_SPLIT_YMZ:
        case HK_MOPP_SPLIT_XZ:
        case HK_MOPP_SPLIT_XMZ:
        case HK_MOPP_SPLIT_XY:
        case HK_MOPP_SPLIT_XMY:

        case HK_MOPP_SPLIT_XYZ:
        case HK_MOPP_SPLIT_XYMZ:
        case HK_MOPP_SPLIT_XMYZ:
        case HK_MOPP_SPLIT_XMYMZ:

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            {
                PC += 4;
                continue;
            }

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            {
                PC += 3;                        //move to the left branch
                continue;
            }

        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            {
                const unsigned int leftJump = (PC3 << 8) + (PC4);
                PC += 7;
                PC += leftJump;
                continue;
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            {
                PC += 3;
                continue;
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            {
                PC += 7;
                continue;
            }

        HK_MOPP_JUMP_MACRO


        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                PC += 4;
                continue;
            }

        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:

    return;
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
