// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

// MOPP Virtual Machine implementation


// include all default MOPP headers
#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppEarlyExitObbVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>

#define HK_PRINTF(a)

#define SPLIT2( POS )                                       \
            offseth = PC1<<1;                                       \
            offsetl = PC2<<1;                                       \
            position = POS;                                         \
            /* radius: approximate 1.4 for root 2   */              \
            radius = query->m_cradius + (query->m_cradius >> 1) + 1;    \
            goto do_compare;

#define SPLIT3( POS )                                       \
            offseth = (PC1<<1)+PC1;                             \
            offsetl = (PC2<<1)+PC2;                             \
            position = POS;                                         \
            /* radius: approximate 2.0 for root 3   */              \
            radius = query->m_cradius << 2;                         \
            goto do_compare;



void hkpMoppEarlyExitObbVirtualMachine::queryOBBOnTree(const hkpMoppEarlyExitObbVirtualMachineQuery* query, const unsigned char* PC)
{
    hkpMoppEarlyExitObbVirtualMachineQuery scaledQuery; // for fast scale commands
    while (1)
    {
        HK_MOPP_LOAD_PC();

        if( m_hitFound )
        {
            return;
        }


        int positionh,positionl,position;
        int radius;

        int offseth;
        int offsetl;
        HK_PRINTF(("PC: %5i: ", PC));
        switch (command)
        {
        case HK_MOPP_SPLIT_YZ:      SPLIT2( (query->m_cy) + (query->m_cz) );
        case HK_MOPP_SPLIT_YMZ:     SPLIT2( (query->m_cy) + (HK_MOPP_RESOLUTION-query->m_cz) );
        case HK_MOPP_SPLIT_XZ:      SPLIT2( (query->m_cx) + (query->m_cz) );
        case HK_MOPP_SPLIT_XMZ:     SPLIT2( (query->m_cx) + (HK_MOPP_RESOLUTION-query->m_cz) );
        case HK_MOPP_SPLIT_XY:      SPLIT2( (query->m_cx) + (query->m_cy) );
        case HK_MOPP_SPLIT_XMY:     SPLIT2( (query->m_cx) + (HK_MOPP_RESOLUTION-query->m_cy) );

        case HK_MOPP_SPLIT_XYZ:     SPLIT3( (query->m_cx) + (query->m_cy) + (query->m_cz) );
        case HK_MOPP_SPLIT_XYMZ:        SPLIT3( (query->m_cx) + (query->m_cy) + (HK_MOPP_RESOLUTION-query->m_cz) );
        case HK_MOPP_SPLIT_XMYZ:        SPLIT3( (query->m_cx) + (HK_MOPP_RESOLUTION-query->m_cy) + (query->m_cz) );
        case HK_MOPP_SPLIT_XMYMZ:   SPLIT3( (query->m_cx) + (HK_MOPP_RESOLUTION-query->m_cy) + (HK_MOPP_RESOLUTION-query->m_cz) );

do_compare:
            {
                //move to the left branch
                const unsigned int offsetRB = PC3;
                PC += 4;

                // not in right branch -> traverse left only
                if ( (position + radius) <= offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    continue;
                }

                PC += offsetRB;

                // now we have to check for traversing the right
                if ( position >= offseth + radius )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryOBBOnTree( query, PC - (offsetRB));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            offseth = PC1;
            offsetl = PC2;
            positionl = (&query->m_xLo)[command - HK_MOPP_SPLIT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SPLIT_X];
            {
                //move to the left branch
                const unsigned int offsetRB = PC3;
                PC += 4;
                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    continue;
                }

                PC += offsetRB;

                // now we have to check for traversing the right
                if ( positionl >= offseth )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryOBBOnTree( query, PC - (offsetRB));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            offsetl = PC1;
            positionl = (&query->m_xLo)[command - HK_MOPP_SINGLE_SPLIT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SINGLE_SPLIT_X];
            {
                //move to the left branch
                const unsigned int offsetRB = PC2;
                PC += 3;
                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    continue;
                }
                PC += offsetRB;

                // now we have to check for traversing the right
                if ( positionl > offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the point is either on one (or both of the planes) or it is in between
                {
                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryOBBOnTree( query, PC - (offsetRB));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }


        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            offseth = PC1;
            offsetl = PC2;

            positionl = (&query->m_xLo)[command - HK_MOPP_SPLIT_JUMP_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_SPLIT_JUMP_X];
            {
                const unsigned int leftJump = (PC3 << 8) + (PC4);
                const unsigned int rightJump = (PC5 << 8) + (PC6);
                PC += 7;

                // not in right branch -> traverse left only
                if ( positionh <= offsetl )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    PC += leftJump;
                    continue;
                }

                PC += rightJump;

                // now we have to check for traversing the right
                if ( positionl >= offseth )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the OBB is either on one (or both of the planes) or it is in between
                {
                    //put in the node splitting code here

                    HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                    //move to the left branch
                    queryOBBOnTree( query, PC - rightJump + leftJump);
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            positionl = (&query->m_xLo)[command - HK_MOPP_DOUBLE_CUT_X];
            positionh = (&query->m_xHi)[command - HK_MOPP_DOUBLE_CUT_X];
            {
                offsetl = PC1;
                offseth = PC2;

                if( (positionh < offsetl) || (positionl >= offseth) )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }
                else
                {
                    PC += 3;
                    continue;
                }
            }

        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            positionl = (&this->m_xLo)[command - HK_MOPP_DOUBLE_CUT24_X];
            positionh = (&this->m_xHi)[command - HK_MOPP_DOUBLE_CUT24_X];
            {
                offsetl = ((PC1<<16) + (PC2<<8) + PC3);
                offseth = ((PC4<<16) + (PC5<<8) + PC6);

                if( (positionh >= offsetl) && (positionl <= offseth) )
                {
                    PC += 7;
                    continue;
                }
                else
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    goto end_of_function;
                }
            }

        HK_MOPP_JUMP_MACRO

        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                const unsigned int shift = command - HK_MOPP_SCALE0;

                //the shift has been accumulating, and will be stored in child space
                //the offset

                scaledQuery.m_offset_x = (PC1 + query->m_offset_x) << shift;
                scaledQuery.m_offset_y = (PC2 + query->m_offset_y) << shift;
                scaledQuery.m_offset_z = (PC3 + query->m_offset_z) << shift;

                scaledQuery.m_shift = query->m_shift + shift;
                const int rShift = 0x10 - scaledQuery.m_shift;

                scaledQuery.m_xLo = ((int)m_xLo) >> (rShift);
                //now subtract the offset in the child space (hence the offset shifting above)
                scaledQuery.m_xLo -= scaledQuery.m_offset_x;

                scaledQuery.m_yLo = ((int)m_yLo) >> (rShift);
                scaledQuery.m_yLo -= scaledQuery.m_offset_y;

                scaledQuery.m_zLo = ((int)m_zLo) >> (rShift);
                scaledQuery.m_zLo -= scaledQuery.m_offset_z;

                scaledQuery.m_xHi = ((int)m_xHi) >> (rShift);
                scaledQuery.m_xHi += 1;
                scaledQuery.m_xHi -= scaledQuery.m_offset_x;

                scaledQuery.m_yHi = ((int)m_yHi) >> (rShift);
                scaledQuery.m_yHi += 1;
                scaledQuery.m_yHi -= scaledQuery.m_offset_y;

                scaledQuery.m_zHi = ((int)m_zHi) >> (rShift);
                scaledQuery.m_zHi += 1;
                scaledQuery.m_zHi -= scaledQuery.m_offset_z;

                scaledQuery.m_cx = ((int)m_cx) >> (rShift);
                scaledQuery.m_cx -= scaledQuery.m_offset_x;

                scaledQuery.m_cy = ((int)m_cy) >> (rShift);
                scaledQuery.m_cy -= scaledQuery.m_offset_y;

                scaledQuery.m_cz = ((int)m_cz) >> (rShift);
                scaledQuery.m_cz -= scaledQuery.m_offset_z;

                scaledQuery.m_cradius = 1 + (((int)m_cradius) >> (rShift));

                //no need to copy anything except for the primitive offset and the properties
                for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES;p++)
                {
                    scaledQuery.m_properties[p] = query->m_properties[p];
                }

                scaledQuery.m_primitiveOffset = query->m_primitiveOffset;
                query = &scaledQuery;

                PC += 4;
                continue;
            }
        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_TERMINAL_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:
    return;
}



void hkpMoppEarlyExitObbVirtualMachine::generateQueryFromNode(const hkVector4& extent, const hkTransform& BvToWorld, const float& radius, hkpMoppEarlyExitObbVirtualMachineQuery& query)
{
    const hkRotation& rot = BvToWorld.getRotation();

    hkVector4 e0; e0.setBroadcast<0>(extent);
    hkVector4 e1; e1.setBroadcast<1>(extent);
    hkVector4 e2; e2.setBroadcast<2>(extent);

    hkVector4 transformedX;
    hkVector4 transformedY;
    hkVector4 transformedZ;

    transformedX.setMul(e0, rot.getColumn<0>() );
    transformedY.setMul(e1, rot.getColumn<1>() );
    transformedZ.setMul(e2, rot.getColumn<2>() );

    hkVector4 max;
    hkVector4 min;

    transformedX.setAbs(transformedX);
    transformedY.setAbs(transformedY);
    transformedZ.setAbs(transformedZ);

    max.setAdd(transformedX,transformedY);
    max.add(transformedZ);

    hkSimdReal rad4;
    rad4.setFromFloat(radius);
    max.setAdd(max,rad4);

    min.setNeg<4>(max);

    max.add(BvToWorld.getTranslation());
    min.add(BvToWorld.getTranslation());

    //Scales the query into 16.16 fixed precision integer format
    const hkSimdReal sscale = hkSimdReal::fromFloat(m_code->m_info.getScale());
    hkVector4 v_min; v_min.setSub(min, m_code->m_info.m_offset); v_min.mul(sscale);
    hkVector4 v_max; v_max.setSub(max, m_code->m_info.m_offset); v_max.mul(sscale);
    hkIntVector i_min; i_min.setConvertF32toS32(v_min);
    hkIntVector i_max; i_max.setConvertF32toS32(v_max);

    m_xLo = i_min.getU32<0>()-1;
    m_xHi = i_max.getU32<0>()+1;

    m_yLo = i_min.getU32<1>()-1;
    m_yHi = i_max.getU32<1>()+1;

    m_zLo = i_min.getU32<2>()-1;
    m_zHi = i_max.getU32<2>()+1;

    m_cx = (m_xLo + m_xHi) >> 1;
    m_cy = (m_yLo + m_yHi) >> 1;
    m_cz = (m_zLo + m_zHi) >> 1;

    //int m_rx = m_xHi - m_cx;
    //int m_ry = m_yHi - m_cy;
    //int m_rz = m_zHi - m_cz;

    hkSimdReal obbRadius = extent.length<3>() + rad4;

    m_cradius = toIntMax( (obbRadius * sscale).getReal() );

    query.m_xLo = (m_xLo >> 16);
    query.m_xHi = (m_xHi >> 16) + 1;

    query.m_yLo = (m_yLo >> 16);
    query.m_yHi = (m_yHi >> 16) + 1;

    query.m_zLo = (m_zLo >> 16);
    query.m_zHi = (m_zHi >> 16) + 1;

    //the center of the sphere query
    query.m_cx = m_cx >> 16;
    query.m_cy = m_cy >> 16;
    query.m_cz = m_cz >> 16;

    //no point in having spheres on the ends of an AABBTreecast - so min radius
    query.m_cradius = (m_cradius >> 16) + 1;

    query.m_offset_x = 0;
    query.m_offset_y = 0;
    query.m_offset_z = 0;

    //any re-offsetting will occur in the tree
    query.m_primitiveOffset = 0;
    query.m_shift = 0;

    for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
    {
        query.m_properties[p] = 0;
    }

    //now that the tempState is the currentState, we can override the currentState
}

//
// query - for a sphere
//
hkBool hkpMoppEarlyExitObbVirtualMachine::queryObb(const hkpMoppCode* code, const hkTransform& BvToWorld, const hkVector4& extent, const float& radius)
{
    m_code = code;

    const unsigned char* programCounter = &m_code->m_data[0];

    HK_ALIGN16( hkpMoppEarlyExitObbVirtualMachineQuery query );

    generateQueryFromNode(extent,BvToWorld,radius,query);

    HK_COMPILE_TIME_ASSERT( hkpMoppCode::MAX_PRIMITIVE_PROPERTIES == 1);
    query.m_properties[0] = 0;
    /*
    for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
    {
        query.m_properties[p] = 0;
    }
    */

    m_hitFound = false;

    //call the query with the left-of-decimal place part
    HK_QVM_DBG( hkpMoppDebugger::getInstance().startRecurse() );
    queryOBBOnTree( &query, programCounter);
    return m_hitFound;
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
