// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL !REFLECT
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// Virtual Machine command definitions
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachine.h>
#include <Physics2012/Collide/Shape/hkpShape.h>
#include <Physics2012/Collide/Shape/Query/hkpShapeRayCastInput.h>

// Virtual Machine command definitions
struct HK_EXPORT_PHYSICS_2012 hkpMoppAabbCastVirtualMachineQueryInt
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppAabbCastVirtualMachineQueryInt );

    //the offset of the all previous scales are accumulated here (in B space)
    hkVector4 m_FtoBoffset;
    hkVector4 m_extents;    // in B space
    hkReal    m_extentsSum3;

    //the shifts from all previous scale commands are accumulated here
    int m_shift;

    // this converts  floating point space into form byte space
    hkReal m_FtoBScale;

    // the current offset for the primitives
    unsigned int m_primitiveOffset;
    unsigned int m_properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES];
};

struct HK_EXPORT_PHYSICS_2012 hkpMoppAabbCastVirtualMachineQueryFloat
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppAabbCastVirtualMachineQueryFloat );

    // this is the ray in local int coordinate space
    hkVector4 m_rayEnds[2];
};

/// This class implements an AABB cast within the MOPP.
/// This is pretty much identical to the hkpMoppAabbCastVirtualMachine,
/// so make sure that both versions are kept in sync.
class HK_EXPORT_PHYSICS_2012 hkpMoppAabbCastVirtualMachine: public hkpMoppVirtualMachine
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppAabbCastVirtualMachine );

        inline hkpMoppAabbCastVirtualMachine(){}
        inline ~hkpMoppAabbCastVirtualMachine(){}

        /// Input structure to the AABB cast.
        struct hkpAabbCastInput
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppAabbCastVirtualMachine::hkpAabbCastInput );

            /// The starting position in MOPP space.
            hkVector4 m_from;

            /// the destination position in MOPP space.
            hkVector4 m_to;

            /// The halfExtents of the AABB in MOPP space.
            hkVector4 m_extents;


            /// collision input, only used in addRealHit to forward calls.
            const hkpLinearCastCollisionInput* m_collisionInput;

            /// the body which is encapsulated in the AABB, only used in addRealHit to forward calls.
            const hkpCdBody* m_castBody;

            /// the body containing the MOPP space only used in addRealHit to forward calls.
            const hkpCdBody* m_moppBody;
        };

        /// This functions casts an AABB through the MOPP space and for every hit
        /// it gets the child shape from the shapeCollection and call linearCast.
        void aabbCast( const hkpAabbCastInput& input, hkpCdPointCollector& castCollector, hkpCdPointCollector* startCollector );

    ////////////////////////////////////////////////////////////////
    //
    // THE REMAINDER OF THIS FILE IS FOR INTERNAL USE
    //
    ////////////////////////////////////////////////////////////////
#if defined(HK_PLATFORM_SPU)
    int                  m_dmaGroup;
    const hkUint8*       m_originalBaseAddress;
#endif

    protected:

        /// the MOPP code, remember it has the very important info struct inside.
        const hkpMoppCode*       m_code;

        /// converts from 24 bit int space into floating point space.
        float                   m_ItoFScale;

        hkpShapeType            m_castObjectType;

        /// set to the current hitFraction.
        hkReal                  m_earlyOutFraction;
        hkReal                  m_refEarlyOutFraction;

        /// for being able to forward calls.
        hkpCdPointCollector*     m_castCollector;
        hkpCdPointCollector*     m_startPointCollector;

        const hkpAabbCastInput*  m_input;

        // If set (-1) this mask ensures that the chunkId is stored in the shape key
        int                     m_reindexingMask;

        void queryRayOnTree ( const hkpMoppAabbCastVirtualMachineQueryInt* query, const unsigned char* commands,hkpMoppAabbCastVirtualMachineQueryFloat* const fQuery, int chunkOffset);

        /// This function forwards a hit to a child cast.
        /// You can look into its implementation to see what's going on.
        /// (Maybe this function should be virtual.)
#if ! (defined(HK_ARCH_ARM) || defined(HK_PLATFORM_SPU))
        HK_INLINE
#endif
        void addHit(unsigned int id, const unsigned int properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES], hkUlong chunkId=0);

};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
