// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

// MOPP Virtual Machine implementation

// include all default MOPP headers
#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppAabbCastVirtualMachine.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkpMoppVirtualMachineMacros.h>

#include <Physics2012/Collide/Shape/Compound/Collection/hkpShapeCollection.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/hkpMoppBvTreeShape.h>

#include <Physics2012/Collide/Filter/hkpCollisionFilter.h>
#include <Physics2012/Collide/Agent/Query/hkpLinearCastCollisionInput.h>

#if defined(HK_PLATFORM_SPU)
#   include <Physics2012/Collide/Filter/Spu/hkpSpuCollisionFilterUtil.h>
#endif

void hkpMoppAabbCastVirtualMachine::addHit(unsigned int key, const unsigned int properties[hkpMoppCode::MAX_PRIMITIVE_PROPERTIES], hkUlong chunkOffset_unused)
{
#ifdef HK_MOPP_DEBUGGER_ENABLED
    if ( hkpMoppDebugger::getInstance().find() )
    {
        hkprintf("Adding correct triangle as %i %i\n", key, properties[0]);
    }
#endif

    const HK_SHAPE_CONTAINER* shapeContainer = HK_NULL;
    const hkpMoppBvTreeShape* moppBvTree = (const hkpMoppBvTreeShape*)(m_input->m_moppBody->getShape());
#if ! defined (HK_PLATFORM_SPU)
    shapeContainer = (HK_SHAPE_CONTAINER*)moppBvTree->hkpMoppBvTreeShape::getShapeCollection();
#else
    hkpShapeBuffer collectionBuffer;
    shapeContainer = (HK_SHAPE_CONTAINER*)moppBvTree->hkpMoppBvTreeShape::getShapeCollectionFromPpu(collectionBuffer);
#endif

    // Allocate on Havok stack to avoid blowing the program stack, since this function gets inlined into the recursive query function
    hkpShapeBuffer* shapeBuffer = hkAllocateStack<hkpShapeBuffer>(1);
    const hkpShape* childShape = shapeContainer->getChildShape( key, *shapeBuffer );

#if !defined(HK_PLATFORM_SPU)
    if ( m_input->m_collisionInput->m_filter->isCollisionEnabled( *m_input->m_collisionInput, *m_input->m_castBody, *m_input->m_moppBody, *shapeContainer, hkpShapeKey(key) ) )
#else
    if ( hkpSpuCollisionFilterUtil::s_shapeContainerIsCollisionEnabled( static_cast<const hkpCollisionFilter*>( m_input->m_collisionInput->m_filter ), *m_input->m_collisionInput, *m_input->m_castBody, *m_input->m_moppBody, *shapeContainer, hkpShapeKey(key) ) )
#endif
    {
        //
        //  perform a linear cast
        //
        hkpCdBody childBodyB( m_input->m_moppBody );
        childBodyB.setShape( childShape, key );

        hkpShapeType typeB = childShape->getType();

#if !defined(HK_PLATFORM_SPU)
        hkpCollisionDispatcher::LinearCastFunc linCastFunc = m_input->m_collisionInput->m_dispatcher->getLinearCastFunc( m_castObjectType, typeB );
#else
        hkpSpuCollisionQueryDispatcher::LinearCastFunc linCastFunc =  m_input->m_collisionInput->m_queryDispatcher->getLinearCastFunc( m_castObjectType, typeB );
#endif
        linCastFunc( *m_input->m_castBody, childBodyB, *m_input->m_collisionInput, *m_castCollector, m_startPointCollector );
        m_earlyOutFraction = hkMath::min2(m_earlyOutFraction, m_castCollector->getEarlyOutDistance());
    }

    hkDeallocateStack(shapeBuffer, 1);
}


#if defined(HK_PLATFORM_SPU)
static inline const hkUint8* recheckCache( int chunkOffset, const hkUint8* originalBaseAddress, int dmaGroup )
{
    // Fetch the chunk
    const unsigned char* chunkAddress = originalBaseAddress + chunkOffset;
    unsigned char* chunkBase = (unsigned char*)g_SpuMoppCache->getFromMainMemoryInlined( chunkAddress, HK_MOPP_CHUNK_SIZE, dmaGroup, true );
    HK_ASSERT(0x45657653, ((hkUlong)chunkBase & HK_MOPP_CHUNK_MASK) == 0, "Cache must be aligned to HK_MOPP_CHUNK_SIZE bytes");
    return chunkBase;
}
#endif


#define SPLIT2( POSL, POSH, NEG, I0, I1 )                           \
{                                                                   \
            foffseth = float( (PC1_float * 2.0f) - (255.0f * NEG) );        \
            foffsetl = float( (PC2_float * 2.0f) - (255.0f * NEG) );        \
            const hkReal allExtents = hkReal(2) * (query->m_extents(I0) + query->m_extents(I1)); \
            foffsetl -= float(allExtents);                                  \
            foffseth += float(allExtents);                                  \
            positionl = float(POSL);                                        \
            positionh = float(POSH);                                        \
            goto do_compareN4;                                      \
}

#define SPLIT3( POSL, POSH, NEG )                                   \
{                                                                   \
            foffseth = float( (PC1_float * 3.0f) - (255.0f * NEG) );    \
            foffsetl = float( (PC2_float * 3.0f) - (255.0f * NEG) );    \
            const hkReal allExtents = query->m_extentsSum3;             \
            foffsetl -= float(allExtents);                              \
            foffseth += float(allExtents);                              \
            positionl = float(POSL);                                    \
            positionh = float(POSH);                                    \
            goto do_compareN4;                                      \
}

//
//  The spaces:
//  - original floating point space:  O-space (not used in this class)
//  - the relative MOPP space:        F-space  = O-space - m_code->m_info.m_offset
//  - the root level integer space:   I-space  = F-space * m_code->m_info.m_scale = F-space / m_ItoFScale
//  - the MOPP byte space:            B-space  = F-space * quary->m_FtoBScale - query->m_FtoBoffset]
//

void hkpMoppAabbCastVirtualMachine::queryRayOnTree( const hkpMoppAabbCastVirtualMachineQueryInt* query, const unsigned char* PC,hkpMoppAabbCastVirtualMachineQueryFloat* const fQuery, int chunkOffset)
{
    hkpMoppAabbCastVirtualMachineQueryInt scaledQuery; // for fast scale commands
    while (1)
    {
        HK_MOPP_LOAD_PC();

        float positionh,positionl;

        //a temporary direction ( used when subtractions are involved)
        int tdir=999;
        int offsetRB;
        int offsetLB;

        //these need to be changed later
        float foffseth;
        float foffsetl;
        int offsetl;
        int offseth;

        switch (command)
        {
#define RS fQuery->m_rayEnds[0]
#define RE fQuery->m_rayEnds[1]
#define Q query
        case HK_MOPP_SPLIT_YZ:      SPLIT2( (RS(1) + RS(2)),    (RE(1) + RE(2)), 0, 1, 2);
        case HK_MOPP_SPLIT_YMZ:     SPLIT2( (RS(1) - RS(2)),    (RE(1) - RE(2)), 1, 1, 2);
        case HK_MOPP_SPLIT_XZ:      SPLIT2( (RS(0) + RS(2)),    (RE(0) + RE(2)), 0, 0, 2);
        case HK_MOPP_SPLIT_XMZ:     SPLIT2( (RS(0) - RS(2)),    (RE(0) - RE(2)), 1, 0, 2);
        case HK_MOPP_SPLIT_XY:      SPLIT2( (RS(0) + RS(1)),    (RE(0) + RE(1)), 0, 0, 1);
        case HK_MOPP_SPLIT_XMY:     SPLIT2( (RS(0) - RS(1)),    (RE(0) - RE(1)), 1, 0, 1);

        case HK_MOPP_SPLIT_XYZ:     SPLIT3( (RS(0) + RS(1) + RS(2)),    (RE(0) + RE(1) + RE(2)), 0);
        case HK_MOPP_SPLIT_XYMZ:    SPLIT3( (RS(0) + RS(1) - RS(2)),    (RE(0) + RE(1) - RE(2)), 1);
        case HK_MOPP_SPLIT_XMYZ:    SPLIT3( (RS(0) - RS(1) + RS(2)),    (RE(0) - RE(1) + RE(2)), 1);
        case HK_MOPP_SPLIT_XMYMZ:   SPLIT3( (RS(0) - RS(1) - RS(2)),    (RE(0) - RE(1) - RE(2)), 2);
#undef RS
#undef RE
#undef Q
        case HK_MOPP_SINGLE_SPLIT_Z:
        case HK_MOPP_SINGLE_SPLIT_Y:
        case HK_MOPP_SINGLE_SPLIT_X:
            tdir = command - HK_MOPP_SINGLE_SPLIT_X;
            foffsetl = float(PC1_float);
            foffseth = foffsetl + 1.0f;
            foffsetl -= float(query->m_extents(tdir));
            foffseth += float(query->m_extents(tdir));

            positionl = float((&fQuery->m_rayEnds[0](0))[tdir]);
            positionh = float((&fQuery->m_rayEnds[1](0))[tdir]);
            offsetLB = 0;
            offsetRB = PC2;
            PC += 3;
            goto do_compare;
        case HK_MOPP_SPLIT_JUMP_Z:
        case HK_MOPP_SPLIT_JUMP_Y:
        case HK_MOPP_SPLIT_JUMP_X:
            tdir = command - HK_MOPP_SPLIT_JUMP_X;
            foffseth = float(PC1_float);
            foffsetl = float(PC2_float);
            foffsetl -= float(query->m_extents(tdir));
            foffseth += float(query->m_extents(tdir));
            positionl = float((&fQuery->m_rayEnds[0](0))[tdir]);
            positionh = float((&fQuery->m_rayEnds[1](0))[tdir]);
            offsetLB = (PC3 << 8) + (PC4);
            offsetRB = (PC5 << 8) + (PC6);
            PC += 7;
            goto do_compare;

        case HK_MOPP_SPLIT_Z:
        case HK_MOPP_SPLIT_Y:
        case HK_MOPP_SPLIT_X:
            tdir = command - HK_MOPP_SPLIT_X;
            foffseth = float(PC1_float);
            foffsetl = float(PC2_float);
            foffsetl -= float(query->m_extents(tdir));
            foffseth += float(query->m_extents(tdir));
            positionl = float((&fQuery->m_rayEnds[0](0))[tdir]);
            positionh = float((&fQuery->m_rayEnds[1](0))[tdir]);
do_compareN4:
            offsetLB = 0;
            offsetRB = PC3;
            PC += 4;
do_compare:
            {
                // not in right branch -> traverse left only
                if ( (positionh < foffsetl) && (positionl < foffsetl) )
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                    PC += offsetLB;
                    //the PC is ready for the left branch
                    continue;
                }

                //move to the right branch
                PC += offsetRB;

                // now we have to check for traversing the right
                if ((positionl > foffseth) && (positionh > foffseth))
                {
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                    HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                    continue;
                }

                //the ray may cross the plane
                {
                    //the distance from the start and end to the planePos
                    //these values are for clipping purposes
                    const float la = positionl - foffseth;
                    const float ha = positionl - foffsetl;
                    const float lb = positionh - foffseth;
                    const float hb = positionh - foffsetl;

                    //if the ray goes from a low number to a high number,
                    //then we go left first, otherwise we go right first
                    //now that the ray must be split, we actually create 2 smaller rays
                    hkpMoppAabbCastVirtualMachineQueryFloat leftFloat;

                    leftFloat.m_rayEnds[0] = fQuery->m_rayEnds[0];
                    leftFloat.m_rayEnds[1] = fQuery->m_rayEnds[1];

                    if(la < lb)
                    {

                        //they should have different signs
                        if( (la * lb) < 0.0f)
                        {
                            const float ratio = la / (la-lb);
                            leftFloat.m_rayEnds[1].setInterpolate( fQuery->m_rayEnds[0], fQuery->m_rayEnds[1], hkSimdReal::fromFloat(ratio));
                        }

                        HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseLeft() );
                        //move to the left branch
                        queryRayOnTree( query,  PC - offsetRB + offsetLB,&leftFloat, chunkOffset);
#if defined ( HK_PLATFORM_SPU )
                        const hkUint8* spuAddress = recheckCache( chunkOffset, m_originalBaseAddress, m_dmaGroup );

                        // We may have been given a different way in the cache so our local PC is potentially incorrect
                        // Since each chunk is aligned we can use the bottom bits and the new address
                        PC = (const unsigned char*) ( (hkUlong)spuAddress | ((hkUlong)PC & HK_MOPP_CHUNK_MASK ) );
#endif
                        //they should have different signs
                        if( (ha * hb) < 0.0f)
                        {
                            const float ratio = ha / (ha-hb);
                            fQuery->m_rayEnds[0].setInterpolate( fQuery->m_rayEnds[0], fQuery->m_rayEnds[1], hkSimdReal::fromFloat(ratio));
                        }

                        //we have recursed through one branch, which may have
                        //caused a hit - we must now check if this branch needs
                        //to be traversed at all
                        if( m_earlyOutFraction < m_refEarlyOutFraction )
                        {
                            m_refEarlyOutFraction = m_earlyOutFraction;
                            hkVector4 hitpoint;
                            hkReal fraction = m_earlyOutFraction;
                            hitpoint.setInterpolate( m_input->m_from, m_input->m_to, hkSimdReal::fromFloat(fraction));

                            fQuery->m_rayEnds[1].setSub( hitpoint, m_code->m_info.m_offset);
                            fQuery->m_rayEnds[1].mul(hkSimdReal::fromFloat(query->m_FtoBScale) );
                            fQuery->m_rayEnds[1].sub( query->m_FtoBoffset );

                            //if the point is below the low clipping plane, then
                            //there are definitely no hits on the other branch
                            if( (tdir < 3) && ((&fQuery->m_rayEnds[1](0))[tdir] < foffsetl))
                            {
                                HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                                HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                                return;
                            }
                        }
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseRight() );
                        continue;
                    }
                    else
                    {
                        //they should have different signs
                        if( (ha * hb) < 0.0f)
                        {
                            const float ratio = ha / (ha-hb);
                            leftFloat.m_rayEnds[1].setInterpolate( fQuery->m_rayEnds[0], fQuery->m_rayEnds[1], hkSimdReal::fromFloat(ratio));
                        }

                        HK_QVM_DBG2( deep, hkpMoppDebugger::getInstance().recurseRight() );
                        //move to the right branch
                        queryRayOnTree( query, PC,&leftFloat, chunkOffset);
#if defined ( HK_PLATFORM_SPU )
                        const hkUint8* spuAddress = recheckCache( chunkOffset, m_originalBaseAddress, m_dmaGroup );

                        // We may have been given a different way in the cache so our local PC is potentially incorrect
                        // Since each chunk is aligned we can use the bottom bits and the new address
                        PC = (const unsigned char*) ( (hkUlong)spuAddress | ((hkUlong)PC & HK_MOPP_CHUNK_MASK ) );
#endif
                        //they should have different signs
                        if( (la * lb) < 0.0f)
                        {
                            const float ratio = la / (la-lb);
                            fQuery->m_rayEnds[0].setInterpolate( fQuery->m_rayEnds[0], fQuery->m_rayEnds[1], hkSimdReal::fromFloat(ratio));
                        }
                        //we have recursed through one branch, which may have
                        //caused a hit - we must now check if this branch needs
                        //to be traversed at all
                        if( m_earlyOutFraction < m_refEarlyOutFraction )
                        {
                            m_refEarlyOutFraction = m_earlyOutFraction;
                            hkVector4 hitpoint;
                            hkReal fraction = m_earlyOutFraction;
                            hitpoint.setInterpolate( m_input->m_from, m_input->m_to, hkSimdReal::fromFloat(fraction));

                            fQuery->m_rayEnds[1].setSub( hitpoint, m_code->m_info.m_offset);
                            fQuery->m_rayEnds[1].mul(hkSimdReal::fromFloat(query->m_FtoBScale) );
                            fQuery->m_rayEnds[1].sub( query->m_FtoBoffset );
                            //if the point is below the low clipping plane, then
                            //there are definitely no hits on the other branch

                            if( (tdir < 3) && ((&fQuery->m_rayEnds[1](0))[tdir] > foffseth))
                            {
                                HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                                HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                                return;
                            }
                        }
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().pop( deep ));
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().recurseLeft() );
                        //left branch
                        PC = PC - offsetRB + offsetLB;
                        continue;
                    }
                }
            }
        case HK_MOPP_DOUBLE_CUT24_X:
        case HK_MOPP_DOUBLE_CUT24_Y:
        case HK_MOPP_DOUBLE_CUT24_Z:
            {
                tdir = command - HK_MOPP_DOUBLE_CUT24_X;
                foffsetl = (float) ((PC1<<16) + (PC2<<8) + PC3) * m_ItoFScale;
                foffseth = (float) ((PC4<<16) + (PC5<<8) + PC6) * m_ItoFScale;

                foffsetl *= float(query->m_FtoBScale);
                foffseth *= float(query->m_FtoBScale);

                foffsetl -= float(query->m_FtoBoffset(tdir));
                foffseth -= float(query->m_FtoBoffset(tdir));
                foffsetl -= float(query->m_extents(tdir));
                foffseth += float(query->m_extents(tdir));
                PC += 7;
                goto doCut;
            }

        case HK_MOPP_DOUBLE_CUT_X:
        case HK_MOPP_DOUBLE_CUT_Y:
        case HK_MOPP_DOUBLE_CUT_Z:
            {
                tdir = command - HK_MOPP_DOUBLE_CUT_X;
                foffsetl = float(PC1_float);
                foffseth = float(PC2_float);
                foffsetl -= float(query->m_extents(tdir));
                foffseth += float(query->m_extents(tdir));
                PC += 3;
            }
doCut:
            {
                positionl = float(fQuery->m_rayEnds[0](tdir));
                positionh = float(fQuery->m_rayEnds[1](tdir));

                int sign;
                if ( positionl < positionh)
                {
                    if ( (positionh < foffsetl) ||  (positionl > foffseth)  )
                    {
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                        goto end_of_function;
                    }
                    sign = 0;
                }
                else
                {
                    if ( (positionl < foffsetl) ||  (positionh > foffseth)  )
                    {
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectRight() );
                        HK_QVM_DBG( hkpMoppDebugger::getInstance().rejectLeft() );
                        goto end_of_function;
                    }
                    sign = 1;
                }

                const hkVector4 rayStartPoint = fQuery->m_rayEnds[0];
                const hkVector4 rayEndPoint = fQuery->m_rayEnds[1];

                //
                //  clip start of ray
                //
                {
                    const float R0 = positionl - foffseth;
                    const float R1 = positionh - foffseth;
                    if ( R0 * R1 < 0.0f)
                    {
                        const float ratio = R0 / (R0-R1);
                        fQuery->m_rayEnds[ 1-sign ].setInterpolate( rayStartPoint, rayEndPoint, hkSimdReal::fromFloat(ratio));
                    }
                }

                //
                //  clip end of ray
                //
                {
                    const float L0 = positionl - foffsetl;
                    const float L1 = positionh - foffsetl;
                    if ( L0 * L1 < 0.0f)
                    {
                        const float ratio = L0 / (L0-L1);
                        fQuery->m_rayEnds[ sign ].setInterpolate( rayStartPoint, rayEndPoint, hkSimdReal::fromFloat(ratio));
                    }
                }
                continue;
            }

        HK_MOPP_JUMP_MACRO

        case HK_MOPP_JUMP_CHUNK:
        {
            const int chunkId = ( PC1 << 8 ) |  PC2;
            chunkOffset = HK_MOPP_CHUNK_SIZE * chunkId;
            goto jumpRecheckCache;

        }

        case HK_MOPP_JUMP_CHUNK32:
            {
                chunkOffset = (PC1<<24) + (PC2<<16) + (PC3<<8) + PC4;
jumpRecheckCache:

#if defined(HK_PLATFORM_SPU)
                const hkUint8* spuAddress = recheckCache( chunkOffset, m_originalBaseAddress, m_dmaGroup );
                PC = spuAddress;
#else
                const unsigned char* jumpAddress = m_code->m_data.begin() + chunkOffset;
                PC = jumpAddress;
#endif
                continue;
            }

        case HK_MOPP_DATA_OFFSET:
            {
                // dataOffset = ( PC1 << 8 ) |  PC2;
                // numTerminals = ( PC3 << 8 ) |  PC4;
                // Skip over the command
                PC+=5;
                continue;
            }

        case HK_MOPP_SCALE1:
        case HK_MOPP_SCALE2:
        case HK_MOPP_SCALE3:
        case HK_MOPP_SCALE4:
            {
                const unsigned int shift = command - HK_MOPP_SCALE0;

                hkVector4 extraOffset; extraOffset.set( PC1_float, PC2_float, PC3_float );

                hkSimdReal f; f.setFromInt32(1<<shift);
                fQuery->m_rayEnds[0].sub( extraOffset );
                fQuery->m_rayEnds[1].sub( extraOffset );
                fQuery->m_rayEnds[0].mul( f );
                fQuery->m_rayEnds[1].mul( f );

                //accumulate the offset in root node space
                scaledQuery.m_FtoBoffset.setAdd( query->m_FtoBoffset, extraOffset );
                scaledQuery.m_FtoBoffset.mul( f );

                //the shift has been accumulating
                scaledQuery.m_shift = query->m_shift + shift;
                scaledQuery.m_FtoBScale = query->m_FtoBScale * f.getReal();
                scaledQuery.m_extents.setMul( f, query->m_extents );
                scaledQuery.m_extentsSum3 = query->m_extentsSum3 * f.getReal();

                //no need to copy anything except for the primitive toffset and the properties
                for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES;p++)
                {
                    scaledQuery.m_properties[p] = query->m_properties[p];
                }

                scaledQuery.m_primitiveOffset = query->m_primitiveOffset;
                //no need to copy anything except for the primitive toffset
                query = &scaledQuery;

                PC += 4;
                continue;
            }

        HK_MOPP_CHUNK_TERMINAL_MACRO

        HK_MOPP_REOFFSET_MACRO

        HK_MOPP_PROPERTY_MACRO

        HK_MOPP_DEFAULT_MACRO
        }
    }

end_of_function:
    return;
}

void hkpMoppAabbCastVirtualMachine::aabbCast( const hkpAabbCastInput& input, hkpCdPointCollector& castCollector, hkpCdPointCollector* startCollector )
{
    m_input = &input;

    const hkpMoppBvTreeShape* bvB = static_cast<const hkpMoppBvTreeShape*>( m_input->m_moppBody->getShape() );
    //const hkpShapeCollection* shapeCollectionB = bvB->getShapeCollection();

    //this will be handy for accessing code properties later
    m_code = bvB->getMoppCode();

#ifdef HK_PLATFORM_SPU
    m_dmaGroup = HK_SPU_DMA_GROUP_STALL;
    m_originalBaseAddress = m_code->m_data.begin();
    const int moppBytes = hkMath::min2( HK_MOPP_CHUNK_SIZE, HK_NEXT_MULTIPLE_OF(16, m_code->m_data.getSize()) );
    const hkpMoppChunk* spuCode = (const hkpMoppChunk*)g_SpuMoppCache->getFromMainMemoryInlined( m_originalBaseAddress, moppBytes, m_dmaGroup, true );

    HK_DECLARE_ALIGNED_LOCAL_PTR( hkpMoppCode, spuMoppCode, 16 );
    spuMoppCode->initialize( m_code->m_info, (const hkUint8*)spuCode, moppBytes );
    m_code = spuMoppCode;
#endif

    m_castCollector = &castCollector;
    m_startPointCollector = startCollector;
    m_castObjectType = input.m_castBody->getShape()->getType();

    m_earlyOutFraction = 1.0f;
    m_refEarlyOutFraction = m_earlyOutFraction;

    const unsigned char* programCounter = &m_code->m_data[0];

    hkpMoppAabbCastVirtualMachineQueryFloat fQuery;
    hkpMoppAabbCastVirtualMachineQueryInt   query;

    query.m_FtoBoffset.setZero();

    m_ItoFScale = 1.0f / float(m_code->m_info.getScale());
    query.m_FtoBScale = m_code->m_info.getScale() / ( 1 << 0x10 );
    const hkSimdReal f2b = hkSimdReal::fromFloat(query.m_FtoBScale);
    query.m_extents.setMul(f2b, input.m_extents);
    query.m_extentsSum3 = (query.m_extents.horizontalAdd<3>() * hkSimdReal_3).getReal();

    //***************FLOAT QUERY SETUP
    fQuery.m_rayEnds[0].setSub( input.m_from, m_code->m_info.m_offset);
    fQuery.m_rayEnds[1].setSub( input.m_to,   m_code->m_info.m_offset);
    fQuery.m_rayEnds[0].mul( f2b );
    fQuery.m_rayEnds[1].mul( f2b );

    //any re-offsetting will occur in the tree
    query.m_primitiveOffset = 0;
    query.m_shift = 0;

    for(int p = 0; p < hkpMoppCode::MAX_PRIMITIVE_PROPERTIES; p++)
    {
        query.m_properties[p] = 0;
    }

    HK_QVM_DBG( hkpMoppDebugger::getInstance().startRecurse() );

    // If the MOPP code contains terminal data then we need to reindex the terminals
    m_reindexingMask = (*programCounter == HK_MOPP_DATA_OFFSET) ? 0xffffffff : 0x00000000;

    //call the query with the left-of-decimal place part
    queryRayOnTree( &query, programCounter, &fQuery, 0 );

}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
