// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


inline void hkp26Dop::expand(const hkReal tolerance)
{
    hkReal* HK_RESTRICT v = &m_lx;
    for (int i=0; i < 26;)
    {
        v[i++] -= tolerance; // sub from low
        v[i++] += tolerance; // add to high
    }
}

inline hkReal hkp26Dop::getLow(int i ) const
{
    return (&m_lx)[i*2];
}

inline hkReal hkp26Dop::getHigh(int i ) const
{
    return (&m_hx)[i*2];
}

inline void hkp26Dop::setLow(int i, hkReal l)
{
    (&m_lx)[i<<1] = l;
}

inline void hkp26Dop::setHigh(int i, hkReal h)
{
    (&m_hx)[i<<1] = h;
}

inline hkReal hkp26Dop::getLowDistance(int i ) const
{
    if (i < 3)
    {
        return (&m_lx)[i<<1];
    }
    else if (i < 9)
    {
        return (&m_lx)[i<<1] / ROOT2;
    }
    else return (&m_lx)[i<<1] / ROOT3;

}

inline hkReal hkp26Dop::getHighDistance(int i ) const
{
    if (i < 3)
    {
        return (&m_hx)[i<<1];
    }
    else if (i < 9)
    {
        return (&m_hx)[i<<1] / ROOT2;
    }
    else return (&m_hx)[i<<1] / ROOT3;

}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
