// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/hkpCollide.h>
#include <Common/Base/hkBase.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Machine/hkp26Dop.h>

#define R2 1.4142136f
#define R3 1.7320508f
#define IR2 (1.0f/1.4142136f)
#define IR3 (1.0f/1.7320508f)

const hkReal hkp26Dop::ROOT2 = R2;
const hkReal hkp26Dop::ROOT3 = R3;

/*
    AXIS_X = 0,
    AXIS_Y,
    AXIS_Z,
    AXIS_YZ,
    AXIS_YMZ,
    AXIS_XZ,
    AXIS_XMZ,
    AXIS_XY,
    AXIS_XMY,
    AXIS_XYZ,
    AXIS_XYMZ,
    AXIS_XMYZ,
    AXIS_XMYMZ
*/

HK_ALIGN_REAL( hkReal HK_DOP_AXIS[52] ) =
{
         1,  0,  0, 0, //X
         0,  1,  0, 0, //Y
         0,  0,  1, 0, //Z
         0, IR2, IR2, 0, //YZ
         0, IR2,-IR2, 0, //YMZ
        IR2,  0, IR2, 0, //XZ
        IR2,  0,-IR2, 0, //XMZ
        IR2, IR2,  0, 0, //XY
        IR2,-IR2,  0, 0, //XMY
        IR3, IR3, IR3, 0, //XYZ
        IR3, IR3,-IR3, 0, //XYMZ
        IR3,-IR3, IR3, 0, //XMYZ
        IR3,-IR3,-IR3, 0, //XMYMZ
};

static inline hkReal vmin( const hkVector4& v )
{
    return v.horizontalMin<4>().getReal();
}

static inline hkReal vmax( const hkVector4& v )
{
    return v.horizontalMax<4>().getReal();
}


const hkVector4& hkp26Dop::getAxis(int i)
{
    return *(reinterpret_cast<const hkVector4*>( &HK_DOP_AXIS[ i<<2 ] )); /* i*4 */
}

void hkp26Dop::getPlaneEquations( const hkTransform& dopToWorld, hkVector4* planeEquationsOut )
{
    const hkVector4& crossV0 = hkVector4::getConstant<HK_QUADREAL_0100>();
    const hkVector4& crossV1 = hkVector4::getConstant<HK_QUADREAL_0010>();

    hkVector4* planeEquations = planeEquationsOut;
    int i;

    const hkSimdReal eps = hkSimdReal::fromFloat(0.001f);

    for (i=0; i < 13; ++i)
    {
        // Normals x2

        hkVector4& n0 = *planeEquations; planeEquations++;
        hkVector4& n1 = *planeEquations; planeEquations++;

        n0._setRotatedDir( dopToWorld.getRotation(), getAxis(i) );
        n0.normalize<3>();

        n1.setNeg<4>(n0);

        // About Pos x2
        hkVector4 aboutPos0, aboutPos1;

        hkSimdReal l = hkSimdReal::fromFloat(getLowDistance(i));
        hkSimdReal h = hkSimdReal::fromFloat(getHighDistance(i));

        aboutPos0.setMul(h, n0 );
        aboutPos1.setMul(l, n0 );

        aboutPos0.add( dopToWorld.getTranslation() );
        aboutPos1.add( dopToWorld.getTranslation() );

        // corner
        hkVector4 corner0, corner1;

        corner0.setCross( n0, crossV0 );
        if (corner0.lengthSquared<3>() < eps )
        {
            corner0.setCross( n0, crossV1 );
        }
        corner0.setCross( corner0, n0 );
        corner0.normalize<3,HK_ACC_12_BIT,HK_SQRT_SET_ZERO>();

        corner1.setCross( n1, crossV0 );
        if (corner1.lengthSquared<3>() < eps )
        {
            corner1.setCross( n1, crossV1 );
        }
        corner1.setCross( corner1, n1 );
        corner1.normalize<3,HK_ACC_12_BIT,HK_SQRT_SET_ZERO>();

        corner0.add( aboutPos0 );
        corner1.add( aboutPos1 );

        n0.setComponent<3>(-h);
        n1.setComponent<3>(l);
    }
}


void hkp26Dop::translate( const hkVector4& t )
{
    const hkReal* HK_RESTRICT v = &t(0);

    // The 6dop
    m_lx += v[0];
    m_ly += v[1];
    m_lz += v[2];

    m_hx += v[0];
    m_hy += v[1];
    m_hz += v[2];

    // the rest:
    // y+z
    hkReal ti = v[1] + v[2];
    m_lyz += ti;
    m_hyz += ti;

    // y-z
    ti = v[1] - v[2];
    m_lymz += ti;
    m_hymz += ti;

    // x+z
    ti = v[0] + v[2];
    m_lxz += ti;
    m_hxz += ti;

    // x-z
    ti = v[0] - v[2];
    m_lxmz += ti;
    m_hxmz += ti;

    // x+y
    ti = v[0] + v[1];
    m_lxy += ti;
    m_hxy += ti;

    // x-y
    ti = v[0] - v[1];
    m_lxmy += ti;
    m_hxmy += ti;

    // x+y+z
    ti = v[0] + v[1] + v[2];
    m_lxyz += ti;
    m_hxyz += ti;

    // x+y-z
    ti = v[0] + v[1] - v[2];
    m_lxymz += ti;
    m_hxymz += ti;

    // x-y+z
    ti = v[0] - v[1] + v[2];
    m_lxmyz += ti;
    m_hxmyz += ti;

    // x-y-z
    ti = v[0] - v[1] - v[2];
    m_lxmymz += ti;
    m_hxmymz += ti;


}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
