// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

typedef hkUint32 hkpPrimitiveProperty;


/// Defines the size of each MOPP chunk (512 bytes)
#define HK_MOPP_CHUNK_SIZE 512
#define HK_MOPP_CHUNK_MASK (HK_MOPP_CHUNK_SIZE - 1)
#define HK_MOPP_LOG_CHUNK_SIZE 9


class HK_EXPORT_PHYSICS_2012 hkpMoppChunk
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppChunk );

        unsigned char data[HK_MOPP_CHUNK_SIZE];
};

#if defined (HK_PLATFORM_SPU)

    #include <Common/Base/Memory/PlatformUtils/Spu/SpuDmaCache/hkSpu4WayCache.h>
    typedef hkSpu4WayCache hkpMoppCache;
    extern hkpMoppCache* g_SpuMoppCache;

    #define HK_MOPP_DEFAULT_DMA_GROUP 14

#endif

/// Struct mapping old shape keys to new terminal ids
struct HK_EXPORT_PHYSICS_2012 hkpMoppCodeReindexedTerminal
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppCodeReindexedTerminal );
    HK_DECLARE_REFLECTION();
    hkUint32 m_origShapeKey;
    hkUint32 m_reindexedShapeKey;
};

/// The MOPP code simulates a hierarchical bounding volume tree. Note that hkMoppCodes are reference counted.
class HK_EXPORT_PHYSICS_2012  hkpMoppCode : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP );
        HK_DECLARE_REFLECTION();

            // range of property values
        enum
        {
            MIN_PROPERTY_VALUE = 0,
            MAX_PROPERTY_VALUE = 0xffffffff
        };

            // number of property values
        enum
        {
            MAX_PRIMITIVE_PROPERTIES = 1
        };

        enum BuildType
        {
            BUILT_WITH_CHUNK_SUBDIVISION,
            BUILT_WITHOUT_CHUNK_SUBDIVISION,
            BUILD_NOT_SET
        };

        struct HK_EXPORT_PHYSICS_2012 CodeInfo
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppCode::CodeInfo );
            HK_DECLARE_REFLECTION();

            inline hkReal getScale() const;

            inline void setScale(hkReal inVal);

            hkVector4 m_offset;
        };

    public:

#if !defined(HK_PLATFORM_SPU)

            /// Create empty MOPP code.
        hkpMoppCode( ) { m_info.m_offset.setZero(); m_buildType = BUILD_NOT_SET; }

            /// Create from existing data. "moppData" is used inplace.
        inline hkpMoppCode( const CodeInfo& info, const hkUint8* moppData, int moppBytes, BuildType buildType );
#endif

        virtual ~hkpMoppCode() {} // so that the serialization knows it is virtual.

        inline hkInt32 getCodeSize() const;

            /// Create from existing data. "moppData" is used inplace.
        void initialize( const CodeInfo& info, const hkUint8* moppData, int moppBytes, BuildType buildType  = BUILD_NOT_SET );

    public:

        struct CodeInfo m_info;

        hkArray<hkUint8> m_data;

        hkEnum<BuildType, hkInt8> m_buildType; //+default(hkpMoppCode::BUILT_WITHOUT_CHUNK_SUBDIVISION)
};

HK_REFLECT_ENUM(HK_EXPORT_PHYSICS_2012, hkpMoppCode::BuildType);

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
