// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0


template<typename T>
hkpFreeList<T>::hkpFreeList()
{
    m_elems = HK_NULL;
    m_freeElems = 0;
}

template<typename T>
void hkpFreeList<T>::addElem(T elem)
{
    hkpFreeListElem *e = reinterpret_cast<hkpFreeListElem*>(elem);
    e->m_next = m_elems;
    m_elems = e;
    m_freeElems++;
}


template<typename T>
T hkpFreeList<T>::getElem()
{
    HK_ASSERT_NO_MSG(0x7a5c7d70,  m_elems );
    hkpFreeListElem *e = m_elems;
    m_elems = e->m_next;
    m_freeElems--;
    return reinterpret_cast<T>(e);
}



template<typename T>
void hkpFreeList<T>::reset()
{
    m_elems = HK_NULL;
    m_freeElems = 0;
}

template<typename T>
int hkpFreeList<T>::getNumFreeElems()
{
    return m_freeElems;
}

hkpMoppDefaultSplitter::hkpMoppMaxList::hkpMoppMaxList(int numPrimitives)
{
    buffer = hkMemTempBlockAlloc<hkpMoppCompilerPrimitive *>(numPrimitives);
    m_sizeOfArray = numPrimitives;
    m_currentNumElements = 0;
    lastRemovedElement = HK_NULL;
}



hkpMoppDefaultSplitter::hkpMoppMaxList::~hkpMoppMaxList()
{
    hkMemTempBlockFree<hkpMoppCompilerPrimitive *>(buffer, m_sizeOfArray);
}



void hkpMoppDefaultSplitter::hkpMoppMaxList::addElement(hkpMoppCompilerPrimitive *compPrimitive)
{
    HK_ASSERT_NO_MSG(0x5f2fc6bf,  m_currentNumElements < m_sizeOfArray );
    const hkReal value = compPrimitive->m_extent.m_max;
    int index = m_currentNumElements - 1;

    while ((index >= 0) && (buffer[index]) && (buffer[index]->m_extent.m_max < value))
    {
        buffer[index + 1] = buffer[index]; // move right one position
        index--;
    }

    buffer[index + 1] = compPrimitive;
    m_currentNumElements++;
}



hkpMoppCompilerPrimitive* hkpMoppDefaultSplitter::hkpMoppMaxList::elementAt(int index)
{
    if (index <= m_currentNumElements)
    {
        return buffer[index];
    }
    else
    {
        return HK_NULL;
    }
}


hkpMoppCompilerPrimitive* hkpMoppDefaultSplitter::hkpMoppMaxList::getLastRemovedElement(void)
{
    return lastRemovedElement;
}



int hkpMoppDefaultSplitter::hkpMoppMaxList::size()
{
    return m_currentNumElements;
}

void hkpMoppDefaultSplitter::hkpMoppMaxList::removeElementsLessThan(hkReal position)
{
    int index = m_currentNumElements - 1;
    while ((index >= 0) && (buffer[index]) && (buffer[index]->m_extent.m_max < position))
    {
        lastRemovedElement = buffer[index];
        buffer[index] = HK_NULL; // remove
        m_currentNumElements--;
        index--;
    }
}


void hkpMoppDefaultSplitter::hkpMoppMaxList::removeOverflowElements(int maximumListSize)
{
    int index = m_currentNumElements - 1;
    while (index > maximumListSize)
    {
        lastRemovedElement = buffer[index];
        buffer[index] = HK_NULL; // remove
        m_currentNumElements--;
        index--;
    }
}


void hkpMoppDefaultSplitter::hkpMoppMaxList::removeAllElements()
{
    int index = m_currentNumElements - 1;
    while (index > 0)
    {
        buffer[index] = HK_NULL; // remove
        index--;
    }

    lastRemovedElement = HK_NULL;
    m_currentNumElements = 0;
}


//hkpMoppDefaultSplitter::

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
