// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

// hkpMoppDefaultSplitter definition

#pragma once

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Splitter/hkpMoppCostFunction.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Splitter/hkpMoppSplitter.h>

//
// Havok Memory Optimised Partial Polytope Tree
//

class hkpMoppSplitParams; // forward definition
struct hkpMoppCompilerPrimitive;

class hkpFreeListElem
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpFreeListElem );

    hkpFreeListElem* m_next;
};

template<typename T>
    class hkpFreeList
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpFreeList );
    hkpFreeListElem* m_elems;
    int             m_freeElems;
public:
    inline hkpFreeList();
    inline void addElem(T elem);
    inline T getElem();
    inline void reset();
    inline int getNumFreeElems();
};


class hkpMoppDefaultSplitter: public hkpMoppSplitter
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_HKCLASS );

        //
        //      ******************* internal classes *************************
        //

        struct hkpMoppPrimitiveArray
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppDefaultSplitter::hkpMoppPrimitiveArray );

            hkpMoppCompilerPrimitive* m_primitives;
            int                     m_numPrimitives;
            int                     m_maxPrimitiveSplits;
        };

        //
        //  keeps a sorted list of values
        //
        class hkpMoppMaxList
        {
            public:
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_MOPP, hkpMoppDefaultSplitter::hkpMoppMaxList );

                    inline hkpMoppMaxList(int numPrimitives);
                    inline ~hkpMoppMaxList();
                    inline void addElement(hkpMoppCompilerPrimitive* compPrimitive);
                    inline hkpMoppCompilerPrimitive* elementAt(int index);
                    inline hkpMoppCompilerPrimitive* getLastRemovedElement(void);
                    inline int size();
                    // remove all elements which have a maxDistance less than specified position
                    inline void removeElementsLessThan(hkReal position);

                    // remove all extra elements
                    inline void removeOverflowElements(int maximumListSize);
                    inline void removeAllElements();

            protected:

                    int m_currentNumElements;
                    int m_sizeOfArray;
                    hkpMoppCompilerPrimitive** buffer; // storing compiler primitives in ascending maxDistance order
                    hkpMoppCompilerPrimitive* lastRemovedElement;
        };



        enum hkpMoppDsSide
        {
            HK_MOPP_DS_LEFT,
            HK_MOPP_DS_RIGHT
        };

    public:
        // Construtor and Destructor
        hkpMoppDefaultSplitter();
        ~hkpMoppDefaultSplitter();

        // recursively build the tree
        hkpMoppTreeNode* buildTree(hkpMoppMediator* , hkpMoppCostFunction* , hkpMoppAssembler* , const hkpMoppSplitParams& , hkpMoppScratchArea&);
    protected:

        virtual void releaseNode( class hkpMoppTreeNode* nodeToRelease );
        virtual int getFreeNodes();

    private:
        // pointer to the compiler parameters
        const hkpMoppSplitParams*       m_compileParams;
        // pointer to a temporary maxList used in findSplittingPlane
        hkpMoppMaxList*             m_maxList;

        hkpFreeList<hkpMoppTreeInternalNode*>   m_freeNodes;
        hkpFreeList<hkpMoppTreeTerminal*>       m_freeTerminals;

        // pointer to cost function used in compilation, defaults to m_defaultCostFunction
        hkpMoppCostFunction*                m_costFunction;
        // pointer to the assembler, defaults to m_defaultAssembler
        hkpMoppAssembler*                   m_assembler;
        hkpMoppMediator*                    m_mediator;

        hkpMoppTreeInternalNode*                        m_rootNode;

        int     m_numPlaneDirections;
        const   hkpMoppSplittingPlaneDirection* m_planeDirections;

        int     m_optimalDepth;

        // allocates a new node from our node array
        hkpMoppTreeInternalNode*                createNode();
        // allocates a new node from our node array
        hkpMoppTreeTerminal*    createTerminal(hkpMoppTreeInternalNode* parentNode, const hkpMoppPrimitiveArray& params);

        // function used by split
        inline void calculateMaxMinId( const hkpMoppPrimitiveArray& params, hkpMoppTreeNode* node);

        // Split the given space using a splitting plane with the normal in the direction specified
        hkpMoppTreeNode* split(hkpMoppTreeInternalNode* parentNode, const hkpMoppPrimitiveArray& params, hkpMoppDsSide side, int depth);

        // resort the first three axis: best likelihood first
        void resortAxis( const hkpMoppTreeInternalNode* parentNode, int* directionsOut, hkReal* extraCostsOut);
        static inline hkReal HK_CALL calcAxisLengthCost( hkReal maxExtents, hkReal extents);
        // functions used by findSplittingPlanePositions
        HK_INLINE void checkplaneLeftPos(int minIndex, hkpMoppBasicNode* node, int& bestMaxIndex,
                                    hkpMoppCostFunction::hkpPlanesParams& planeLeftInfo, const hkpMoppPrimitiveArray& params);

        // Find the splitting plane position
        void findSplittingPlanePositions(   hkpMoppBasicNode* node, const hkpMoppSplittingPlaneDirection* plane,
                                            const hkpMoppPrimitiveArray& params, const hkpMoppExtent& extent, int treeDepth);


        // functions used by group Primitives
        inline int findPosition(hkpMoppBasicNode* bestNode, hkpMoppCompilerPrimitive* current);

        inline void sortLeftAndRight(int position, hkpMoppBasicNode* bestNode, int depth, int& maxSplits, int& numSplits,
                                    hkpMoppCompilerPrimitive*& beginUnsorted, hkpMoppCompilerPrimitive*& endUnsorted,
                                    hkpMoppCompilerPrimitive*& beginRight, hkpMoppCompilerPrimitive*& beginMiddle);

        inline void distributeMiddle(hkpMoppCompilerPrimitive*& startLeft, hkpMoppCompilerPrimitive*& endLeft,
                             hkpMoppCompilerPrimitive*& startRight, hkpMoppCompilerPrimitive*& endRight,
                             hkpMoppCompilerPrimitive*& startMiddle, hkpMoppCompilerPrimitive*& endMiddle,
                             const hkpMoppBasicNode* bestNode);

        // Calculate how many Primitives are in front of and behind the plane and create new primitive lists accordingly.
        void groupPrimitives(const hkpMoppPrimitiveArray& in, hkpMoppBasicNode* bestNode, int depth,
                            hkpMoppPrimitiveArray& leftOut, hkpMoppPrimitiveArray& rightOut);
};


#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Splitter/hkpMoppDefaultSplitter.inl>

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
