// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Splitter/hkpMoppSplitTypes.h>

/// A generic interface that allows a user to compress and embed shape data directly in the MOPP
class hkpPrimitiveCompressor
{
    //+hk.MemoryTracker(ignore=True)
    public:
        virtual ~hkpPrimitiveCompressor(){}

            /// Return the size required to store shape data for a given set of primitives
        virtual int calcPrimitivesSize( const hkpMoppPrimitiveId* primitiveIdArray, int numPrimitives ) const = 0;

            /// Embed the data at the position specified.
            /// Note: The data should make no assumptions about alignment or endianess
        virtual void storePrimitives( const hkpMoppPrimitiveId* primitiveIdArray, int numPrimitives, unsigned char* data ) const = 0;
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
