// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

//
// Havok Memory Optimised Partial Polytope Assembler
// This class generates the binary BV code for the VM to execute
//

#pragma once

//forward declarations
class hkpMoppAssemblerNodeInfo;
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Assembler/hkpMoppNodeInfoTypes.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Assembler/hkpMoppAssembler.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>
class hkpMoppMediator;

class hkpMoppDefaultAssembler: public hkpMoppAssembler
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);

        hkpMoppDefaultAssembler(const hkpMoppAssemblerParams &ap, class hkpMoppCodeGenerator* code, hkpMoppMediator* mediator);
        ~hkpMoppDefaultAssembler();                                                                             // standard destructor

            /// update the current assembler params
        void updateParams(const hkpMoppAssemblerParams &ap);

            /// assemble part of the input tree
        void assemble(hkpMoppTreeNode* currentNode, class hkpMoppNodeMgr* mgr, int minElemsToAssemble); // assembles the tree into BV machine code

        void getScaleInfo( hkpMoppTreeNode* rootNode, hkpMoppCode::CodeInfo* moppCodeInfo );

        virtual int getNumSplittingPlaneDirections() const { return 13; }
        virtual const hkpMoppSplittingPlaneDirection* getSplittingPlaneDirections() const   { return &m_directions[0]; }

    protected:
        //
        // some high level helper functions for assembleSubNode
        //

        // initializes the rescaleCommandInfo and reoffset data for top down assembly
        void initTopDown( hkpMoppTreeNode* currentNode,const hkpMoppAssemblerNodeInfo &parentInfo, hkpMoppAssemblerNodeInfo& currentInfo, hkpMoppAssemblerRescaleCommand& rescaleCommandInfo );

        // adds the terminal including extra cuts to the output
        int assembleCutAndTerminalCommand( hkpMoppTreeNode* currentNode,const hkpMoppAssemblerNodeInfo &parentInfo, hkpMoppAssemblerNodeInfo& currentInfo );

        // adds a single command to the output
        int assembleNonTerminalCommand(hkpMoppTreeNode* currentNode,const hkpMoppAssemblerNodeInfo &parentInfo, hkpMoppAssemblerNodeInfo& currentInfo, hkpMoppAssemblerRescaleCommand& rescaleCommandInfo);

        // Adds a jump chunk command to the output
        int assembleJumpChunkCommand( hkpMoppTreeNode* currentNode );

    public:
            //
            // for chunk compile
            //
        int calcChunkPoints(hkpMoppTreeNode* currentNode,const hkpMoppAssemblerNodeInfo &parentInfo, hkpMoppAssemblerNodeInfo& currentInfo, hkArray<hkpMoppPrimitiveId>& terminalsOut);

        int calcTerminalIdsForChunks(hkpMoppTreeNode* currentNode, int chunkId, int currentId );

        void assembleSubNodeIntoChunks(hkpMoppTreeNode* currentNode,const hkpMoppAssemblerNodeInfo &parentInfo, hkpMoppAssemblerNodeInfo& currentInfo, int chunkId, hkArray<hkpMoppPrimitiveId>& terminalsOut);


    protected:

        //
        // some helper functions
        //

        /// converts the splitting planes as returned by the splitter into MOPP byte space
        void findPlanes(const hkpMoppTreeInternalNode* node,const hkpMoppAssemblerNodeInfo& info,int &pleft,int &pright);



        //
        //  rescale
        //
        // check whether we need to rescale (result stored in currentNode->m_doCommands and rescaleCommandInfo)

        /// calculates for each node, whether it should get a rescale command or not
        /// returns the maximum number significant bits for currentNode
        int preCalcScale( hkpMoppTreeNode* currentNode,const hkpMoppAssemblerNodeInfo &parentInfo, hkpMoppAssemblerNodeInfo& currentInfo);

        // subfunctions of preCalcScale
        /// calculate the number of shifts, a theoretical rescale command at this node could shift the current space.
        int calcRescaleBits( const hkpMoppAssemblerNodeInfo &parent,    hkpMoppAssemblerNodeInfo& info );

        /// given that there will be a rescale command, redo the scale command (shift and scale space)
        void recalcRescale( const hkpMoppAssemblerNodeInfo &parent, hkpMoppAssemblerNodeInfo& info, hkpMoppAssemblerRescaleCommand& cmd );

        /// calculate, whether it makes sense to issue a rescale command for this node
        HK_INLINE hkBool shouldRescale( hkpMoppTreeNode* node,const hkpMoppAssemblerNodeInfo &parent, hkpMoppAssemblerNodeInfo& info);

        // flag this node and all nodes up to the root as scale already calculated
        void fixScale( hkpMoppTreeNode* currentNode );



        //
        //  cut
        //


        // check whether we need to cut (result stored in currentNode->m_doCommands and cutCommandInfo)
        void calcCut( hkpMoppTreeNode* currentNode, hkpMoppAssemblerCutInfo& currentInfo);

        void calcTermCut( hkpMoppTreeNode* currentNode, hkpMoppAssemblerCutInfo& currentInfo );


        void calcReoffset( hkpMoppTreeNode* currentNode,const hkpMoppAssemblerNodeInfo &parentInfo, hkpMoppAssemblerNodeInfo& currentInfo );

        // recursive preprocess for cut commands
        void preCalcCutPositions(hkpMoppTreeNode* currentNode,const hkpMoppAssemblerCutInfo &parentInfo, hkpMoppAssemblerCutInfo& currentInfo);

        //
        //  bands
        //
        hkBool shouldAssemble( hkpMoppTreeNode* currentNode, const hkpMoppAssemblerNodeInfo& currentInfo );

        //
        //recursive call to assemble the right child - returns the size of the current node (when assembled)
        //Note: this functino will return a -1 if the size of the branch is > 64 (but the node will store the size)
        //
        int assemblesubNode(hkpMoppTreeNode* node,const hkpMoppAssemblerNodeInfo &parent, hkpMoppAssemblerNodeInfo& currentInfo);

        //
        //add the necessary code to rescale at this node
        //
        void addRescale(const hkpMoppAssemblerRescaleCommand &cmd);

        //
        //add the necessary code to reOffset at this node
        //
        void addTermIdOffset(hkUint32 offset);

        void checkAndAddProperties( hkpMoppTreeNode* currentNode,const hkpMoppAssemblerNodeInfo &parentInfo, hkpMoppAssemblerNodeInfo& currentInfo  );

        inline void updateMaxCutPlanePosition(hkpMoppTreeNode* currentNode, HK_MOPP_SPLIT_DIRECTIONS directionCode, int planePosition);
        inline void updateMinCutPlanePosition(hkpMoppTreeNode* currentNode, HK_MOPP_SPLIT_DIRECTIONS directionCode, int planePosition);

        //
        //find the splitting plane code from a normal
        //
        HK_MOPP_SPLIT_DIRECTIONS getSplitCode(const hkVector4& norm);

        //
        //Adds the split command (and the close-split command (or split-jump even) if needed
        //
        void addSplit(int pright,int pleft,HK_MOPP_SPLIT_DIRECTIONS directionCode,int leftOffset,int rightOffset);

            // adds a jump to a chunk id command
        int addJumpChunk( int chunkId );

            // adds a data offset command. This appears at the start of every chunk
        int addDataOffset( int offset, int numTerminals );

        //
        //Adds the terminal information to the internal code from a list of terminals
        //this function may also need to add primitive properties to the tree if the terminals
        //in the opposing branch differ to this one
        //returns the size of the terminals added
        //
        int addTerminals(hkpMoppTreeTerminal* terminal, const hkpMoppAssemblerNodeInfo& parentInfo, const hkpMoppAssemblerNodeInfo& currentInfo);

            // Adds the specified property to the tree
        void addProperty(int property,int value);


            // Adds a jump to the jumpPos position from the current offset - caters for multi-byte jumps
        void addJump(unsigned int jumpPos);

            // Adds a cut command to the current assembled node if the info flags that it is needed
        void addCut(const hkpMoppTreeNode* currentNode, const hkpMoppAssemblerNodeInfo& currentInfo);

            // release node when assembled. This mean freeing all memory used by node or its children.
            // This is used by the interleaved building process
        void releaseNode( hkpMoppTreeNode* node );



    protected:
        //pointer to the mediator required to obtain the properties from the primitive
        hkpMoppMediator* m_mediator;
        hkpMoppNodeMgr* m_nodeMgr;

        // the output code generator
        hkpMoppCodeGenerator* m_code;

        // an optional pointer, which specifies how we build MOPP chunks out of a single MOPP
    public:
        struct hkpMoppCompilerChunkInfo* m_chunkInfo;

        //
        // variables needed to build the tree
        //

        // pointer to the assembled MOPP code
        int m_minDepthToBuild;          // the min depth of the tree below which everything will be built
        int m_halfTreeDepth;            // the half depth of the tree
        int m_depthTopDownScale;        // the depth of the tree, a top down scale distribution will be used
        int m_minAssembledElems;        // if more nodes than this are assembled, simply stop. This is used to partially build the tree if it does not fit into memory
        int m_numNodesAssembled;        // this counts the number of assembled interior nodes. This is used for interleaved building
        hkpMoppCode::CodeInfo m_codeInfo;

        hkArray<hkpMoppSplittingPlaneDirection> m_directions;

        hkpMoppAssemblerParams m_params;        // a direct copy of the input params
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
