// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0


void hkpMoppCodeGenerator::addCode(int code)
{
    //NB: code is added from the end to the start of the list
    //as the traversal goes from the leaves to the root
    HK_ASSERT_NO_MSG(0x69edca5d,  code >= 0);
    HK_ASSERT_NO_MSG(0x1577cb51,  code < 0x100);

    //copy this byte into the internal list
    m_code[m_size-m_pos-1] = (unsigned char)code;
    //move to the next position
    m_pos++;
    if(m_pos >= m_size)
    {
        resize();
    }
}

void hkpMoppCodeGenerator::addCommand4(int code, int param)
{
    HK_ASSERT_NO_MSG(0x7c69701b,  param >=0 && param < 0x10 );
    addCode( code + param );
}

void hkpMoppCodeGenerator::addCommand5(int code, int param)
{
    HK_ASSERT_NO_MSG(0x5b08b857,  param >=0 && param < 0x20 );
    addCode( code + param );
}

void hkpMoppCodeGenerator::addCommand8(int code, int param)
{
    HK_ASSERT_NO_MSG(0x601e552e,  param >=0 && param < 0x100 );
    addCode(param);
    addCode(code);  //the address
}

void hkpMoppCodeGenerator::addCommand16(int code, int param)
{
    HK_ASSERT_NO_MSG(0x19ee5a3f,  param >=0 && param < 0x10000 );
    addCode(param&0x0ff);               //the address - LO
    addCode(param>>8);                  //HI
    addCode(code);
}

void hkpMoppCodeGenerator::addCommand24(int code, int param)
{
    HK_ASSERT_NO_MSG(0x707eb4db,  param >=0 && param < 0x1000000 );
    addCode((param&0x0ff));             //the address - LO
    addCode((param&0x0ff00)>>8);        //MID
    addCode((param&0x0ff0000)>>16);     //HI
    addCode(code);
}

void hkpMoppCodeGenerator::addParam24(int param)
{
    HK_ASSERT_NO_MSG(0x424ad75b,  param >=0 && param < 0x1000000 );
    addCode((param&0x0ff));             //the address - LO
    addCode((param&0x0ff00)>>8);        //MID
    addCode((param&0x0ff0000)>>16);     //HI
}

void hkpMoppCodeGenerator::addParam32(int param)
{
    addCode((param&0xff));              //the address - LO
    addCode((param&0xff00)>>8);
    addCode((param&0xff0000)>>16);
    addCode((param&0xff000000)>>24);    //HI
}

void hkpMoppCodeGenerator::addCommand32(int code, unsigned int param)
{
    addCode((param&0x0ff));             //the address - LO
    addCode((param&0x0ff00)>>8);        //the address - MID LO
    addCode((param&0x0ff0000)>>16);     //MID HI
    addCode((param&0xff000000)>>24);    //HI
    addCode(code);
}

void hkpMoppCodeGenerator::pad( int size )
{
    for (int i=0; i < size; i++)
    {
        addCode(0xCD);
    }
}

void hkpMoppCodeGenerator::undo( int size )
{
    m_pos -= size;
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
