// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0


#pragma once

// Code generator for MOPP
class hkpMoppCodeGenerator : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_MOPP);

        // constructor which creates an initial sized list
        hkpMoppCodeGenerator(int numBytes = 1024 * 1024);

        ~hkpMoppCodeGenerator();

        // add data into the resulting code
        inline void addCode(int code);
        inline void addParam24( int param );
        inline void addParam32( int param );
        inline void addCommand4(int code, int param);
        inline void addCommand5(int code, int param);
        inline void addCommand8(int code, int param);
        inline void addCommand16(int code, int param);
        inline void addCommand24(int code, int param);
        inline void addCommand32(int code, unsigned int param);

        inline void pad( int size );
        inline void undo( int size );

        /// returns the current position of the code that was added to the tree
        int getPos() const {return m_pos;}

        /// returns the current size of the code
        int getSize() const {return m_size;}

        /// hkReallocates the code with the correct size and copies all data into that
        class hkpMoppCode* compileCode();

        struct JumpCommandInfo
        {
            int m_position; // Offset location for a MOPP_JUMP_CHUNK32 command
            int m_chunkId;  // The chunkId for the jump command. Only used for debugging.
        };

        // Verifies that all jump commands are valid
        void validateJumpCommands() const;


    ////////////////////////////////////////////////////////////////
    //
    // THE REMAINDER OF THIS FILE IS FOR INTERNAL USE
    //
    ////////////////////////////////////////////////////////////////

    protected:
        //resize the internal storage
        void resize();
        //will store size of code
        int m_size;
        //will store the position the new code is to be added at
        int m_pos;
    public:
        //this will hold the code
        unsigned char* m_code;

        // Cached list of HK_MOPP_JUMP_CHUNK32 commands that have been written
        // We need to keep this so that they can be converted from indices to offsets later on
        hkArray<JumpCommandInfo> m_jumpCommands;
};

#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Assembler/hkpMoppCodeGenerator.inl>

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
