// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

//
// Havok Memory Optimised Partial Polytope Code
// This class provides utility functions for generating code
//

// include all default MOPP headers
#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/hkbuilder.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Builder/Assembler/hkpMoppCodeGenerator.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCode.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/Code/hkpMoppCommands.h>


hkpMoppCodeGenerator::hkpMoppCodeGenerator(int size)
{
    //initial size
    m_code = hkMemTempBlockAlloc<unsigned char>(size);
    //member variable to store size of list
    m_size = size;
    //member variable to store the current code position
    m_pos = 0;
}

hkpMoppCodeGenerator::~hkpMoppCodeGenerator()
{
    if (m_code)
        hkMemTempBlockFree<unsigned char>(m_code, m_size);
}

void hkpMoppCodeGenerator::resize()
{
    // Allocate
    unsigned char* temp = hkMemTempBlockAlloc<unsigned char>(m_size*2);

    // Initialize
    hkString::memSet( temp, 0xCD, m_size );

    // copy the old list halfway down the new one
    hkString::memCpy(&temp[m_size],m_code,m_size);

    // Deallocate old
    hkMemTempBlockFree<unsigned char>(m_code, m_size);
    m_code = &temp[0];

    // increase the size of the list
    m_size *= 2;
}

hkpMoppCode* hkpMoppCodeGenerator::compileCode()
{
    validateJumpCommands();

    //resize the list to contain no "empty" space
    const int prefetchInstructionPadding = 3;
    int finalSize = m_pos;
    hkpMoppCode* code = new hkpMoppCode();
    code->m_data.reserveExactly( finalSize+prefetchInstructionPadding );
    code->m_data.setSize( finalSize+prefetchInstructionPadding );

    hkString::memCpy( &code->m_data[0], &m_code[m_size-m_pos], finalSize );
    hkString::memSet(&code->m_data[finalSize], 0xcd, prefetchInstructionPadding );

    hkMemTempBlockFree<unsigned char>(m_code, m_size);
    m_code = HK_NULL;

    m_pos = 0;
    //reset the size
    m_size = finalSize;
    return code;
}

void hkpMoppCodeGenerator::validateJumpCommands() const
{
#ifdef HK_DEBUG
    for (int i=0; i<m_jumpCommands.getSize(); i++)
    {
        const JumpCommandInfo& jc = m_jumpCommands[i];
        HK_ASSERT_NO_MSG(0x7584cd60, m_code[ getSize() - jc.m_position] == HK_MOPP_JUMP_CHUNK32);
    }
#endif // HK_DEBUG
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
