// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Compound/Collection/hkpShapeCollection.h>
#include <Physics2012/Collide/Shape/Convex/Triangle/hkpTriangleShape.h>

class hkpMoppBvTreeShape;

/// This shape is a very simple container for triangle soups and can't handle triangle strips.
/// It does not allow sharing of triangle data with the renderer through referencing.
/// Use hkpExtendedMeshShape or your own implementation of a hkpShapeCollection to share triangle data with the renderer.
class HK_EXPORT_PHYSICS_2012 hkpSimpleMeshShape : public hkpShapeCollection
{
    //+hk.ReflectedFile("hkpSimpleMeshShape")

    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SHAPE);
        HK_DECLARE_REFLECTION();
        HKCD_DECLARE_SHAPE_TYPE(hkcdShapeType::TRIANGLE_COLLECTION);

    public:

            /// Default constructor.
            /// The data for this shape is public, so simply fill in the
            /// member data after construction.
        hkpSimpleMeshShape( hkReal radius = hkConvexShapeDefaultRadius );

#ifndef HK_PLATFORM_SPU
        void afterReflectNew();
#endif

        //
        // hkpShapeCollection interface
        //

            /// Get the first child shape key.
        virtual hkpShapeKey getFirstKey() const;

            /// Get the next child shape key.
        virtual hkpShapeKey getNextKey( hkpShapeKey oldKey ) const;

            /// hkpShapeCollection interface implementation.
        const hkpShape* getChildShape( hkpShapeKey key, hkpShapeBuffer& buffer ) const;

            // hkpShapeCollection interface implementation.
        virtual void setWeldingInfo( hkpShapeKey key, hkInt16 weldingInfo);

            // hkpShapeCollection interface implementation.
        virtual void initWeldingInfo( hkpWeldingUtility::WeldingType weldingType );


            /// Gets the extra radius for every triangle.
        inline hkReal getRadius() const;

            /// Sets the extra radius for every triangle.
        inline void setRadius(hkReal r );


        //
        // hkpShape interface
        //


            // hkpShape interface implementation.
        virtual void getAabb(const hkTransform& localToWorld, hkReal tolerance, hkAabb& out) const;

    public:

        struct Triangle
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpSimpleMeshShape::Triangle );
            HK_DECLARE_REFLECTION();

            int m_a;
            int m_b;
            int m_c;

            hkUint16 m_weldingInfo; // +default(0)
        };

            /// Array of vertices that the triangles can index into.
        hkArray<hkVector4> m_vertices;

            /// Array of triangles. The triangles are triples of ints that are indices into the m_vertices array.
        hkArray<struct Triangle> m_triangles;

            /// Material indices. If you are not using material information, leave this array as 0 size.
        hkArray<hkUint8> m_materialIndices;

            /// The radius of the storage mesh shape. It is initialized to .05
        hkReal m_radius;

            /// A a welding type per triangle
        hkEnum<hkpWeldingUtility::WeldingType, hkUint8> m_weldingType; // +default(hkpWeldingUtility::WELDING_TYPE_NONE)
};

#include <Physics2012/Collide/Shape/Compound/Collection/SimpleMesh/hkpSimpleMeshShape.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
