// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Compound/Collection/Mesh/hkpMeshMaterial.h>

    /// The name given to materials for faces which are not in any selection.
#define DEFAULT_MESH_MATERIAL_NAME "Default"



/// In the content tools, a string can be attached to sets of triangles using mesh section materials or triangle
/// selections from the Havok Mesh Channel Toolbox. A material table containing hkpNamedMeshMaterials will be built
/// by the create rigid bodies filter. This table is intended only as an intermediate structure which can be replaced
/// by a user-designed subclass of hkpMeshMaterial.
class HK_EXPORT_PHYSICS_2012 hkpNamedMeshMaterial : public hkpMeshMaterial
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpNamedMeshMaterial );
        HK_DECLARE_REFLECTION();

        hkpNamedMeshMaterial() : m_name( DEFAULT_MESH_MATERIAL_NAME ) { m_filterInfo = 0; }

        hkpNamedMeshMaterial( const hkStringPtr& name ) : m_name( name ) { m_filterInfo = 0; }

        inline hkBool32 operator==( const hkpNamedMeshMaterial& other ) const { return ( other.m_filterInfo == m_filterInfo ) && ( other.m_name == m_name ); }

    public:
        hkStringPtr m_name;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
