// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if defined(HK_PLATFORM_SPU)
#   include <Common/GeometryUtilities/Spu/hkSpuConfig.h>
#   include <Common/Base/Memory/PlatformUtils/Spu/SpuDmaCache/hkSpu4WayCache.h>
extern class hkSpu4WayCache* g_SpuCollideUntypedCache;
#endif

//
//  Sets the shape info at the given shape key

HK_INLINE void hkpListShape::setShapeInfo(hkpShapeKey shapeKey, hkUint16 newShapeInfo)
{
    m_childInfo[shapeKey].m_shapeInfo = newShapeInfo;
}

//
//  Gets the shape info at the given shape key

HK_INLINE hkUint16 hkpListShape::getShapeInfo(hkpShapeKey shapeKey) const
{
#ifdef HK_PLATFORM_SPU
    const ChildInfo* cInfo = hkGetArrayElemUsingCacheHalfSize<ChildInfo>(m_childInfo.begin(), shapeKey, g_SpuCollideUntypedCache, HK_SPU_UNTYPED_CACHE_LINE_SIZE);
    return cInfo->m_shapeInfo;
#else
    return m_childInfo[shapeKey].m_shapeInfo;
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
