// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <Physics2012/Collide/Query/CastUtil/hkpWorldRayCastOutput.h>
#include <Physics2012/Collide/Query/Multithreaded/RayCastQuery/hkpRayCastQueryJobs.h>
#include <Physics2012/Collide/Shape/Query/hkpShapeRayCastOutput.h>


class HK_EXPORT_PHYSICS_2012 hkpShapeRayCastJobUtil
{
    public:
        // Returns a pointer to the next 'free' hkpShapeRayCastOutput.
        // This can either be:
        // - the next truly free entry (if there's room left in the array)
        // - the furthest hit in the array (if the array is already full and we need to drop entries)
        // - HK_NULL if the array is full and the current hit is further away than the furthest hit in the entry
        HK_INLINE static hkpWorldRayCastOutputPpu* getNextFreeResult(hkpShapeRayCastCommand* command, hkpWorldRayCastOutputPpu* resultsArray, hkpWorldRayCastOutputPpu*& nextFreeResult, hkReal hitFraction);
};


class HK_EXPORT_PHYSICS_2012 hkpWorldRayCastJobUtil
{
    public:
        // Returns a pointer to the next 'free' hkpWorldRayCastOutput.
        // This can either be:
        // - the next truly free entry (if there's room left in the array)
        // - the furthest hit in the array (if the array is already full and we need to drop entries)
        // - HK_NULL if the array is full and the current hit is further away than the furthest hit in the entry
        HK_INLINE static hkpWorldRayCastOutputPpu* getNextFreeResult(hkpWorldRayCastCommand* command, hkpWorldRayCastOutputPpu* resultsArray, hkpWorldRayCastOutputPpu*& nextFreeResult, hkReal hitFraction);
};

template <typename COMMAND, typename OUTPUT>
class HK_EXPORT_PHYSICS_2012 hkpRayCastJobUtil
{
    public:
        // Returns a pointer to the next 'free' OUTPUT.
        // This can either be:
        // - the next truly free entry (if there's room left in the array)
        // - the furthest hit in the array (if the array is already full and we need to drop entries)
        // - HK_NULL if the array is full and the current hit is further away than the furthest hit in the entry
        HK_INLINE static OUTPUT* getNextFreeResult(COMMAND* command, OUTPUT* resultsArray, OUTPUT*& nextFreeResult, hkReal hitFraction, hkReal& maxHitFractionOut);
};

#include <Physics2012/Collide/Query/Multithreaded/RayCastQuery/Util/hkpCollisionQueryUtil.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
