// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <Common/Base/Thread/JobQueue/hkJobQueue.h>
#include <Physics2012/Collide/Agent/hkpProcessCollisionInput.h>
#include <Physics2012/Collide/BroadPhase/hkpBroadPhaseCastCollector.h>
#include <Physics2012/Collide/Shape/Query/hkpShapeRayCastInput.h>

class hkpFixedBufferRayHitCollector;
struct hkpWorldRayCastCommand;
struct hkpWorldRayCastOutput;
struct hkpWorldRayCastInput;


class hkCpuWorldRayCastCollector : public hkpBroadPhaseCastCollector
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkCpuWorldRayCastCollector );
        hkCpuWorldRayCastCollector() : m_fixedBufferRayHitCollector(HK_NULL){ resetHitInfo();}
        void resetHitInfo(){m_hitFraction = 1.0f; m_hit = false;}

    protected:

        // hkpBroadPhaseCastCollector interface
        virtual hkReal addBroadPhaseHandle( const hkpBroadPhaseHandle* broadPhaseHandle, int castIndex );

    public:

        // global, command-independent data
        const hkpCollisionFilter*           m_filter;
        hkReal                      m_hitFraction;
        hkBool                      m_hit;

        // command-dependent data
        hkpWorldRayCastCommand*         m_command;
        const hkpWorldRayCastInput*     m_originalInput;
        hkpWorldRayCastOutput*          m_result;
        hkpWorldRayCastOutput*          m_nextFreeResult;

        hkpShapeRayCastInput            m_workInput;

        hkpFixedBufferRayHitCollector*  m_fixedBufferRayHitCollector;

        hkVector4 m_earlyOutHitFraction;
};

hkJobQueue::JobStatus HK_CALL hkCpuWorldRayCastJob( hkJobQueue& jobQueue, hkJobQueue::JobQueueEntry& nextJobOut );

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
