// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


hkpFixedBufferRayHitCollector::hkpFixedBufferRayHitCollector(hkpWorldRayCastOutput_Storage* buffer, int capacity) : hkpRayHitCollector()
{
    HK_ASSERT(0xaf35461e, capacity > 0, "Capacity has to be > 0.");

    m_rayCastOutputBase = buffer;
    m_nextFreeOutput    = buffer;
    m_capacity          = capacity;
    m_numOutputs        = 0;

    m_collidableOnPpu = HK_NULL;
}


void hkpFixedBufferRayHitCollector::addRayHit(const hkpCdBody& cdBody, const hkpShapeRayCastCollectorOutput& hitInfo)
{
    HK_ASSERT(0xaf635e1f, g_FixedBufferRayHitCollectorAddRayHitCallbackFunc, "You have to register either the default addRayHit() function using hkpFixedBufferRayHitCollector::registerDefaultAddRayHitFunction() or a custom function using registerFixedBufferRayHitCollectorAddRayHitCallbackFunction().");
    g_FixedBufferRayHitCollectorAddRayHitCallbackFunc(cdBody, hitInfo, this);
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
