// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Query/hkpRayHitCollector.h>
#include <Physics2012/Collide/Query/CastUtil/hkpWorldRayCastOutput.h>

/// This class implements the hkpRayHitCollector, and stores all the points the ray hits.
/// It never causes an early out for the ray cast.
class HK_EXPORT_PHYSICS_2012 hkpAllRayHitCollector : public hkpRayHitCollector
{
    public:
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkpAllRayHitCollector);
            /// Constructor calls reset.
        inline hkpAllRayHitCollector();

            /// Resets this structure by clearing the hits list, and resetting the early out distance.
            /// You must call this if you want to reuse an object of this class for another raycast.
        inline void reset();

        inline virtual ~hkpAllRayHitCollector();

            /// Get all the hits
        inline const hkArray<hkpWorldRayCastOutput>& getHits() const;

            /// Sort the hits so that the closest hits occur earliest in the hit list
        void sortHits();

    protected:

        virtual void addRayHit( const hkpCdBody& cdBody, const hkpShapeRayCastCollectorOutput& hitInfo );

    protected:
        hkInplaceArray<hkpWorldRayCastOutput,8> m_hits;
};

#include <Physics2012/Collide/Query/Collector/RayCollector/hkpAllRayHitCollector.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
