// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/Query/hkpCdPointCollector.h>
#include <Physics2012/Collide/Query/Collector/PointCollector/hkpRootCdPoint.h>


/// This class collects the closest contact point, but does not
/// gather any other information. This is useful if you are interested only in the
/// distance, normal and position and not in hkShapeKeys and rootCollidables.
/// Use this class for the maximum performance.
///
/// \note Read the notes for hkpCdPointCollector.
class HK_EXPORT_PHYSICS_2012 hkpSimpleClosestContactCollector : public hkpCdPointCollector
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpSimpleClosestContactCollector);

            /// Constructor calls reset
        inline hkpSimpleClosestContactCollector();

            /// Resets the early out condition.
            /// You must call this function if you want to reuse an object of this class.
        inline void reset();

        inline virtual ~hkpSimpleClosestContactCollector();

            /// Returns true, if this class has collected a hit.
        inline hkBool hasHit( ) const;

            /// Returns only the physical hit information: position, normal, distance
        inline const hkContactPoint& getHitContact() const;

    protected:

            // this implementation keeps track of the hkpCdPoint with the smallest distance
        virtual void addCdPoint( const hkpCdPoint& pointInfo ) ;

    protected:
        hkBool m_hasHit;
        hkContactPoint  m_hitPoint;
};

#include <Physics2012/Collide/Query/Collector/PointCollector/hkpSimpleClosestContactCollector.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
