// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Physics/ContactPoint/hkContactPoint.h>
#include <Physics2012/Collide/Shape/hkpShape.h>

class hkpCollidable;
    /// This class is used by the default collectors, hkpAllCdPointCollector, and hkpClosestCdPointCollector.
    /// As most of data in a hkpCdPoint is just temporary,
    /// we can only extract the root information from a hkpCdPoint.
    ///
    /// If you need more detailed information, you have to implement a collector yourself.
struct HK_EXPORT_PHYSICS_2012 hkpRootCdPoint
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpRootCdPoint );

    // HAVOK 2010.2 CUSTOM CODE - STL 2010/06/30 - Add shape key heirarchies to hkpRootCdPoint.  Code from
    // David Wong of Havok.
    //
    enum { MAX_HIERARCHY_DEPTH = 5 };
    //
    // HAVOK 2010.2 CUSTOM CODE - STL 2010/06/30 - Add shape key heirarchies to hkpRootCdPoint.  Code from
    // David Wong of Havok.

    HK_INLINE const hkContactPoint& getContact() const { return m_contact; }
    HK_INLINE void setContact(const hkContactPoint& cp) { m_contact = cp; }
    HK_INLINE void setContact(hkVector4Parameter pos, hkVector4Parameter norm, hkReal d) { m_contact.set(pos,norm,d); }
    HK_INLINE void setContact(hkVector4Parameter pos, hkVector4Parameter norm, hkSimdRealParameter d) { m_contact.setPositionNormalAndDistance(pos,norm,d); }
    HK_INLINE void setContactDistance(hkReal d) { m_contact.setDistance(d); }
    HK_INLINE void setContactDistance(hkSimdRealParameter d) { m_contact.setDistanceSimdReal(d); }

        /// The physical information of the contact point.
        /// Note: if this information contains cast results, then m_contact.getDistance
        /// is a fraction between 0 and 1 (and not the Euclidean distance).
    hkContactPoint m_contact;

        /// The root collidable of object A
    const hkpCollidable*    m_rootCollidableA;

        /// The shape key of the colliding shape of object A.
        /// Note: if your root collidable is a hkpMeshShape, this will be the subpart and triangle index
    hkpShapeKey m_shapeKeyA;


    // HAVOK 2010.2 CUSTOM CODE - STL 2010/06/30 - Add shape key heirarchies to hkpRootCdPoint.  Code from
    // David Wong of Havok.
    //
    hkpShapeKey m_shapeKeysA[MAX_HIERARCHY_DEPTH];
    //
    // HAVOK 2010.2 CUSTOM CODE - STL 2010/06/30 - Add shape key heirarchies to hkpRootCdPoint.  Code from
    // David Wong of Havok.

        /// The root collidable of object B
    const hkpCollidable*    m_rootCollidableB;

        /// The shape key of the colliding shape of object B.
        /// Note: if your root collidable is a hkpMeshShape, this will be the subpart and triangle index
    hkpShapeKey m_shapeKeyB;

    // HAVOK 2010.2 CUSTOM CODE - STL 2010/06/30 - Add shape key heirarchies to hkpRootCdPoint.  Code from
    // David Wong of Havok.
    //
    hkpShapeKey m_shapeKeysB[MAX_HIERARCHY_DEPTH];
    //
    // HAVOK 2010.2 CUSTOM CODE - STL 2010/06/30 - Add shape key heirarchies to hkpRootCdPoint.  Code from
    // David Wong of Havok.
    /// Comparison operator for sorting RootCdPoints

        /// Comparison operator for sorting RootCdPoints
    inline hkBool32 operator<( const hkpRootCdPoint& b ) const;
};

#include <Physics2012/Collide/Query/Collector/PointCollector/hkpRootCdPoint.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
