// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


#include <Physics2012/Collide/Agent/Query/hkpCdPointCollector.h>
#include <Physics2012/Collide/Query/Collector/PointCollector/hkpRootCdPoint.h>


#if defined(HK_PLATFORM_SPU)
    // on spu these global variables are used to pass the ppu collidable ptr from the job to the collector's addCdPoint() function
    // (as we are going through the standard hkpCdPointCollector interface where there is no way to pass additional parameters through)
    extern const hkpCollidable* g_spuFixedBufferCdPointCollectorCollidableAOnPpu;
    extern const hkpCollidable* g_spuFixedBufferCdPointCollectorCollidableBOnPpu;
#endif

typedef void (HK_CALL *hkFixedBufferCdPointCollectorAddCdPointCallbackFunc)(const hkpCdPoint& event, class hkpFixedBufferCdPointCollector* collector);

///
/// This collector class will always collect the n closest points (with n == 'capacity' as supplied in the constructor).
/// For now it is only used with hkCollisionQuery jobs. Its usage is hardcoded into the jobs, so you cannot derive and
/// use your derived class instead, but you can register your own custom addCdPoint() callback function by calling
/// registerFixedBufferCdPointCollectorAddCdPointCallbackFunction().
///
class HK_EXPORT_PHYSICS_2012 hkpFixedBufferCdPointCollector : public hkpCdPointCollector
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_AGENT, hkpFixedBufferCdPointCollector);

    public:

            /// The constructor needs to be passed in a pointer to the result array and its maximum capacity.
        HK_INLINE hkpFixedBufferCdPointCollector(hkpRootCdPoint* buffer, int capacity);

            /// Resets the early out condition and empties the array of hits.
            /// You must call this function if you want to reuse an object of this class.
        HK_INLINE void reset();

        HK_INLINE const hkpRootCdPoint* getHits() const;

        HK_INLINE int getNumHits() const;

            /// Removes the first hit and copies elements down one slot as in the STL array.
        HK_INLINE void removeFirstHitAndCopy();

        HK_INLINE void removeHit( int index );

        HK_INLINE hkBool hasHit() const;

            /// Sort the hits so that the closest hits are earliest in the hit list
        void sortHits();

            /// Call this static function to register the collector's default addCdPoint() callback implementation.
        static void HK_CALL registerDefaultAddCdPointFunction();
        static void HK_CALL registerCustomAddCdPointFunction(hkFixedBufferCdPointCollectorAddCdPointCallbackFunc func);

    public:

            /// The collector's default addCdPoint() implementation.
            ///
            /// This implementation will collect up to n closest points (with n == 'capacity' as supplied in the class constructor).
            /// As long as there's room available in the internal array, new points will simply be appended.
            /// Once the maximum capacity is reached we will check if the new point is closer than the already available furthest
            /// point and replace the latter accordingly.
        static void HK_CALL addCdPointImplementation(const hkpCdPoint& event, hkpFixedBufferCdPointCollector* collector);

    protected:

        virtual HK_INLINE void addCdPoint(const hkpCdPoint& event);

    public:

        hkpRootCdPoint* m_pointsArrayBase;  // the result array's base address
        int             m_capacity;         // the maximum number of entries available in the result array
        int             m_numPoints;        // the current number of entries available in the result array

};


//
// User callback registering stuff for hkpFixedBufferCdPointCollector::addCdPoint()
//
extern hkFixedBufferCdPointCollectorAddCdPointCallbackFunc g_FixedBufferCdPointCollectorAddCdPointCallbackFunc;


/// Register your custom hkpFixedBufferCdPointCollector::addCdPoint() implementation with this function.
///
/// Note that when using the hkpFixedBufferCdPointCollector you can only ever have one global, shared addCdPoint() implementation.
HK_INLINE void registerFixedBufferCdPointCollectorAddCdPointCallbackFunction(hkFixedBufferCdPointCollectorAddCdPointCallbackFunc func)
{
    g_FixedBufferCdPointCollectorAddCdPointCallbackFunc = func;
}


#include <Physics2012/Collide/Query/Collector/PointCollector/hkpFixedBufferCdPointCollector.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
